/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;
import org.aspectj.ajdt.internal.compiler.ast.AdviceDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.DeclareDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureNode;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.ResolvedMember;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.problem.ProblemHandler;

public class AsmBuilder
extends AbstractSyntaxTreeVisitorAdapter {
    private final Stack stack;
    private final CompilationResult currCompilationResult;
    private Initializer inInitializer = null;

    public static void build(CompilationUnitDeclaration unit, StructureModel structureModel) {
        LangUtil.throwIaxIfNull(unit, "unit");
        new AsmBuilder(unit.compilationResult()).internalBuild(unit, structureModel);
    }

    private AsmBuilder(CompilationResult result) {
        LangUtil.throwIaxIfNull(result, "result");
        this.currCompilationResult = result;
        this.stack = new Stack();
    }

    private void internalBuild(CompilationUnitDeclaration unit, StructureModel structureModel) {
        StructureNode addToNode;
        LangUtil.throwIaxIfNull(structureModel, "structureModel");
        if (!this.currCompilationResult.equals(unit.compilationResult())) {
            throw new IllegalArgumentException("invalid unit: " + unit);
        }
        File file = new File(new String(unit.getFileName()));
        int startLine = this.getStartLine(unit);
        int endLine = this.getEndLine(unit);
        SourceLocation sourceLocation = new SourceLocation(file, startLine, endLine);
        ProgramElementNode cuNode = new ProgramElementNode(new String(file.getName()), ProgramElementNode.Kind.FILE_JAVA, sourceLocation, 0, "", new ArrayList());
        ImportReference currentPackage = unit.currentPackage;
        if (null == currentPackage) {
            addToNode = structureModel.getRoot();
        } else {
            StringBuffer nameBuffer = new StringBuffer();
            char[][] importName = currentPackage.getImportName();
            int last = importName.length - 1;
            int i = 0;
            while (i < importName.length) {
                nameBuffer.append(new String(importName[i]));
                if (i < last) {
                    nameBuffer.append('.');
                }
                ++i;
            }
            String pkgName = nameBuffer.toString();
            ProgramElementNode pkgNode = null;
            Iterator it = structureModel.getRoot().getChildren().iterator();
            while (it.hasNext()) {
                ProgramElementNode currNode = (ProgramElementNode)it.next();
                if (!pkgName.equals(currNode.getName())) continue;
                pkgNode = currNode;
                break;
            }
            if (pkgNode == null) {
                pkgNode = new ProgramElementNode(pkgName, ProgramElementNode.Kind.PACKAGE, new ArrayList());
                structureModel.getRoot().addChild(pkgNode);
            }
            addToNode = pkgNode;
        }
        ListIterator itt = addToNode.getChildren().listIterator();
        while (itt.hasNext()) {
            ProgramElementNode child = (ProgramElementNode)itt.next();
            ISourceLocation childLoc = child.getSourceLocation();
            if (null == childLoc || !childLoc.getSourceFile().equals(file)) continue;
            itt.remove();
        }
        addToNode.addChild(cuNode);
        this.stack.push(cuNode);
        unit.traverse((IAbstractSyntaxTreeVisitor)this, unit.scope);
        try {
            structureModel.addToFileMap(file.getCanonicalPath(), cuNode);
        }
        catch (IOException e) {
            System.err.println("IOException " + e.getMessage() + " creating path for " + file);
        }
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        String name = new String(typeDeclaration.name);
        ProgramElementNode.Kind kind = ProgramElementNode.Kind.CLASS;
        if (typeDeclaration instanceof AspectDeclaration) {
            kind = ProgramElementNode.Kind.ASPECT;
        } else if (typeDeclaration.isInterface()) {
            kind = ProgramElementNode.Kind.INTERFACE;
        }
        ProgramElementNode peNode = new ProgramElementNode(name, kind, this.makeLocation(typeDeclaration), typeDeclaration.modifiers, "", new ArrayList());
        ((StructureNode)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        this.stack.pop();
    }

    public boolean visit(MemberTypeDeclaration memberTypeDeclaration, ClassScope scope) {
        String name = new String(memberTypeDeclaration.name);
        ProgramElementNode.Kind kind = ProgramElementNode.Kind.CLASS;
        if (memberTypeDeclaration instanceof AspectDeclaration) {
            kind = ProgramElementNode.Kind.ASPECT;
        } else if (memberTypeDeclaration.isInterface()) {
            kind = ProgramElementNode.Kind.INTERFACE;
        }
        ProgramElementNode peNode = new ProgramElementNode(name, kind, this.makeLocation(memberTypeDeclaration), memberTypeDeclaration.modifiers, "", new ArrayList());
        ((StructureNode)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(MemberTypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(LocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        String name = new String(memberTypeDeclaration.name);
        String fullName = new String(memberTypeDeclaration.binding.constantPoolName());
        int dollar = fullName.indexOf(36);
        fullName = fullName.substring(dollar + 1);
        ProgramElementNode.Kind kind = ProgramElementNode.Kind.CLASS;
        if (memberTypeDeclaration.isInterface()) {
            kind = ProgramElementNode.Kind.INTERFACE;
        }
        ProgramElementNode peNode = new ProgramElementNode(fullName, kind, this.makeLocation(memberTypeDeclaration), memberTypeDeclaration.modifiers, "", new ArrayList());
        this.findEnclosingClass(this.stack).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(LocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        this.stack.pop();
    }

    public boolean visit(AnonymousLocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        return this.visit((LocalTypeDeclaration)memberTypeDeclaration, scope);
    }

    public void endVisit(AnonymousLocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        this.stack.pop();
    }

    private StructureNode findEnclosingClass(Stack stack) {
        int i = stack.size() - 1;
        while (i >= 0) {
            ProgramElementNode pe = (ProgramElementNode)stack.get(i);
            if (pe.getProgramElementKind() == ProgramElementNode.Kind.CLASS) {
                return pe;
            }
            --i;
        }
        return (StructureNode)stack.peek();
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        ProgramElementNode.Kind kind = ProgramElementNode.Kind.METHOD;
        String label = new String(methodDeclaration.selector);
        if (methodDeclaration instanceof AdviceDeclaration) {
            kind = ProgramElementNode.Kind.ADVICE;
            label = this.translateAdviceName(label);
        } else if (methodDeclaration instanceof PointcutDeclaration) {
            kind = ProgramElementNode.Kind.POINTCUT;
            label = this.translatePointcutName(label);
        } else if (methodDeclaration instanceof DeclareDeclaration) {
            DeclareDeclaration declare = (DeclareDeclaration)methodDeclaration;
            label = this.translateDeclareName(declare.toString());
            if (label.indexOf("warning") != -1) {
                kind = ProgramElementNode.Kind.DECLARE_WARNING;
            }
            if (label.indexOf("error") != -1) {
                kind = ProgramElementNode.Kind.DECLARE_ERROR;
            }
        } else if (methodDeclaration instanceof InterTypeDeclaration) {
            kind = ProgramElementNode.Kind.INTRODUCTION;
            label = this.translateInterTypeDecName(new String(((InterTypeDeclaration)methodDeclaration).selector));
        }
        ProgramElementNode peNode = new ProgramElementNode(label, kind, this.makeLocation(methodDeclaration), methodDeclaration.modifiers, "", new ArrayList());
        if (kind == ProgramElementNode.Kind.METHOD && label.equals("main")) {
            ((ProgramElementNode)this.stack.peek()).setRunnable(true);
        }
        if (methodDeclaration.binding != null) {
            ResolvedMember member = EclipseFactory.makeResolvedMember(methodDeclaration.binding);
            peNode.setBytecodeName(member.getName());
            peNode.setBytecodeSignature(member.getSignature());
        }
        ((StructureNode)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        ProgramElementNode peNode = new ProgramElementNode(new String(fieldDeclaration.name), ProgramElementNode.Kind.FIELD, this.makeLocation(fieldDeclaration), fieldDeclaration.modifiers, "", new ArrayList());
        ((StructureNode)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.stack.pop();
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        if (constructorDeclaration.isDefaultConstructor) {
            this.stack.push(null);
            return true;
        }
        ProgramElementNode peNode = new ProgramElementNode(new String(constructorDeclaration.selector), ProgramElementNode.Kind.CONSTRUCTOR, this.makeLocation(constructorDeclaration), constructorDeclaration.modifiers, "", new ArrayList());
        ((StructureNode)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(Initializer initializer, MethodScope scope) {
        if (initializer == this.inInitializer) {
            return false;
        }
        this.inInitializer = initializer;
        ProgramElementNode peNode = new ProgramElementNode("...", ProgramElementNode.Kind.INITIALIZER, this.makeLocation(initializer), initializer.modifiers, "", new ArrayList());
        ((StructureNode)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        initializer.block.traverse(this, scope);
        this.stack.pop();
        return false;
    }

    private ISourceLocation makeLocation(AstNode node) {
        String fileName = new String(this.currCompilationResult.getFileName());
        int startLine = this.getStartLine(node);
        int endLine = this.getEndLine(node);
        SourceLocation loc = null;
        loc = startLine <= endLine ? new SourceLocation(new File(fileName), startLine, endLine) : new SourceLocation(new File(fileName), startLine);
        return loc;
    }

    private int getStartLine(AstNode n) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, n.sourceStart);
    }

    private int getEndLine(AstNode n) {
        if (n instanceof AbstractVariableDeclaration) {
            return this.getEndLine((AbstractVariableDeclaration)n);
        }
        if (n instanceof AbstractMethodDeclaration) {
            return this.getEndLine((AbstractMethodDeclaration)n);
        }
        if (n instanceof TypeDeclaration) {
            return this.getEndLine((TypeDeclaration)n);
        }
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, n.sourceEnd);
    }

    private int getStartLine(AbstractVariableDeclaration avd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, avd.declarationSourceStart);
    }

    private int getEndLine(AbstractVariableDeclaration avd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, avd.declarationSourceEnd);
    }

    private int getStartLine(AbstractMethodDeclaration amd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, amd.declarationSourceStart);
    }

    private int getEndLine(AbstractMethodDeclaration amd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, amd.declarationSourceEnd);
    }

    private int getStartLine(TypeDeclaration td) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, td.declarationSourceStart);
    }

    private int getEndLine(TypeDeclaration td) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, td.declarationSourceEnd);
    }

    private String translateAdviceName(String label) {
        if (label.indexOf("before") != -1) {
            return "before";
        }
        if (label.indexOf("returning") != -1) {
            return "after returning";
        }
        if (label.indexOf("after") != -1) {
            return "after";
        }
        if (label.indexOf("around") != -1) {
            return "around";
        }
        return "<advice>";
    }

    private String translateDeclareName(String name) {
        int colonIndex = name.indexOf(":");
        if (colonIndex != -1) {
            return name.substring(0, colonIndex);
        }
        return name;
    }

    private String translateInterTypeDecName(String name) {
        int index = name.lastIndexOf(36);
        if (index != -1) {
            return name.substring(index + 1);
        }
        return name;
    }

    private String translatePointcutName(String name) {
        int index = name.indexOf("$$") + 2;
        int endIndex = name.lastIndexOf(36);
        if (index != -1 && endIndex != -1) {
            return name.substring(index, endIndex);
        }
        return name;
    }
}

