/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.core.builder.ReferenceCollection;

public class AjState {
    AjBuildManager buildManager;
    long lastSuccessfulBuildTime = -1L;
    long currentBuildTime = -1L;
    AjBuildConfig buildConfig;
    AjBuildConfig newBuildConfig;
    Map classesFromFile = new HashMap();
    Map references = new HashMap();
    Map classesFromName = new HashMap();
    ArrayList qualifiedStrings;
    ArrayList simpleStrings;
    Set addedFiles;
    Set deletedFiles;
    List addedClassFiles;

    public AjState(AjBuildManager buildManager) {
        this.buildManager = buildManager;
    }

    void successfulCompile(AjBuildConfig config) {
        this.buildConfig = config;
        this.lastSuccessfulBuildTime = this.currentBuildTime;
    }

    boolean prepareForNextBuild(AjBuildConfig newBuildConfig) {
        this.currentBuildTime = System.currentTimeMillis();
        this.addedClassFiles = new ArrayList();
        if (this.lastSuccessfulBuildTime == -1L || this.buildConfig == null) {
            return false;
        }
        this.simpleStrings = new ArrayList();
        this.qualifiedStrings = new ArrayList();
        HashSet oldFiles = new HashSet(this.buildConfig.getFiles());
        HashSet newFiles = new HashSet(newBuildConfig.getFiles());
        this.addedFiles = new HashSet(newFiles);
        this.addedFiles.removeAll(oldFiles);
        this.deletedFiles = new HashSet(oldFiles);
        this.deletedFiles.removeAll(newFiles);
        this.newBuildConfig = newBuildConfig;
        return true;
    }

    private Collection getModifiedFiles() {
        return this.getModifiedFiles(this.lastSuccessfulBuildTime);
    }

    Collection getModifiedFiles(long lastBuildTime) {
        ArrayList<File> ret = new ArrayList<File>();
        Iterator i = this.buildConfig.getFiles().iterator();
        while (i.hasNext()) {
            long modTime;
            File file = (File)i.next();
            if (!file.exists() || (modTime = file.lastModified()) < lastBuildTime) continue;
            ret.add(file);
        }
        return ret;
    }

    public List getFilesToCompile(boolean firstPass) {
        ArrayList sourceFiles = new ArrayList();
        if (firstPass) {
            Collection modifiedFiles = this.getModifiedFiles();
            sourceFiles.addAll(modifiedFiles);
            sourceFiles.addAll(this.addedFiles);
            this.deleteClassFiles();
            this.addAffectedSourceFiles(sourceFiles);
        } else {
            this.addAffectedSourceFiles(sourceFiles);
        }
        return sourceFiles;
    }

    private void deleteClassFiles() {
        Iterator i = this.deletedFiles.iterator();
        while (i.hasNext()) {
            File deletedFile = (File)i.next();
            this.addDependentsOf(deletedFile);
            List unwovenClassFiles = (List)this.classesFromFile.get(deletedFile);
            this.classesFromFile.remove(deletedFile);
            if (unwovenClassFiles == null) continue;
            Iterator j = unwovenClassFiles.iterator();
            while (j.hasNext()) {
                UnwovenClassFile classFile = (UnwovenClassFile)j.next();
                this.deleteClassFile(classFile);
            }
        }
    }

    private void deleteClassFile(UnwovenClassFile classFile) {
        this.classesFromName.remove(classFile.getClassName());
        this.buildManager.bcelWeaver.deleteClassFile(classFile.getClassName());
        try {
            classFile.deleteRealFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void noteClassesFromFile(CompilationResult result, String sourceFileName, List unwovenClassFiles) {
        File sourceFile = new File(sourceFileName);
        if (result != null) {
            this.references.put(sourceFile, new ReferenceCollection(result.qualifiedReferences, result.simpleNameReferences));
        }
        List previous = (List)this.classesFromFile.get(sourceFile);
        ArrayList<UnwovenClassFile> newClassFiles = new ArrayList<UnwovenClassFile>();
        Iterator i = unwovenClassFiles.iterator();
        while (i.hasNext()) {
            UnwovenClassFile cf = (UnwovenClassFile)i.next();
            cf = this.writeClassFile(cf, this.findAndRemoveClassFile(cf.getClassName(), previous));
            newClassFiles.add(cf);
            this.classesFromName.put(cf.getClassName(), cf);
        }
        if (previous != null && !previous.isEmpty()) {
            Iterator i2 = previous.iterator();
            while (i2.hasNext()) {
                UnwovenClassFile cf = (UnwovenClassFile)i2.next();
                this.deleteClassFile(cf);
            }
        }
        this.classesFromFile.put(sourceFile, newClassFiles);
    }

    private UnwovenClassFile findAndRemoveClassFile(String name, List previous) {
        if (previous == null) {
            return null;
        }
        Iterator i = previous.iterator();
        while (i.hasNext()) {
            UnwovenClassFile cf = (UnwovenClassFile)i.next();
            if (!cf.getClassName().equals(name)) continue;
            i.remove();
            return cf;
        }
        return null;
    }

    private UnwovenClassFile writeClassFile(UnwovenClassFile cf, UnwovenClassFile previous) {
        if (this.simpleStrings == null) {
            this.addedClassFiles.add(cf);
            return cf;
        }
        try {
            ClassFileReader reader;
            byte[] newBytes;
            byte[] oldBytes;
            block8: {
                if (previous == null) {
                    this.addedClassFiles.add(cf);
                    this.addDependentsOf(cf.getClassName());
                    return cf;
                }
                oldBytes = previous.getBytes();
                newBytes = cf.getBytes();
                if (newBytes.length == oldBytes.length) {
                    int i = newBytes.length;
                    while (--i >= 0) {
                        if (newBytes[i] == oldBytes[i]) {
                            continue;
                        }
                        break block8;
                    }
                    this.buildManager.bcelWorld.addSourceObjectType(previous.getJavaClass());
                    return previous;
                }
            }
            if (!(reader = new ClassFileReader(oldBytes, previous.getFilename().toCharArray())).isLocal() && !reader.isAnonymous() && reader.hasStructuralChanges(newBytes)) {
                this.addDependentsOf(cf.getClassName());
            }
        }
        catch (ClassFormatException e) {
            this.addDependentsOf(cf.getClassName());
        }
        this.addedClassFiles.add(cf);
        return cf;
    }

    protected void addAffectedSourceFiles(List sourceFiles) {
        char[][] simpleNames;
        if (this.qualifiedStrings.isEmpty() && this.simpleStrings.isEmpty()) {
            return;
        }
        char[][][] qualifiedNames = ReferenceCollection.internQualifiedNames(this.qualifiedStrings);
        if (qualifiedNames.length < this.qualifiedStrings.size()) {
            qualifiedNames = null;
        }
        if ((simpleNames = ReferenceCollection.internSimpleNames(this.simpleStrings)).length < this.simpleStrings.size()) {
            simpleNames = null;
        }
        Iterator i = this.references.entrySet().iterator();
        while (i.hasNext()) {
            File file;
            Map.Entry entry = i.next();
            ReferenceCollection refs = (ReferenceCollection)entry.getValue();
            if (refs == null || !refs.includes(qualifiedNames, simpleNames) || !(file = (File)entry.getKey()).exists() || sourceFiles.contains(file)) continue;
            sourceFiles.add(file);
        }
        this.qualifiedStrings.clear();
        this.simpleStrings.clear();
    }

    protected void addDependentsOf(String qualifiedTypeName) {
        String typeName;
        int lastDot = qualifiedTypeName.lastIndexOf(46);
        if (lastDot != -1) {
            String packageName = qualifiedTypeName.substring(0, lastDot).replace('.', '/');
            if (!this.qualifiedStrings.contains(packageName)) {
                this.qualifiedStrings.add(packageName);
            }
            typeName = qualifiedTypeName.substring(lastDot + 1);
        } else {
            this.qualifiedStrings.add("");
            typeName = qualifiedTypeName;
        }
        int memberIndex = typeName.indexOf(36);
        if (memberIndex > 0) {
            typeName = typeName.substring(0, memberIndex);
        }
        if (!this.simpleStrings.contains(typeName)) {
            this.simpleStrings.add(typeName);
        }
    }

    protected void addDependentsOf(File sourceFile) {
        List l = (List)this.classesFromFile.get(sourceFile);
        if (l == null) {
            return;
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            UnwovenClassFile cf = (UnwovenClassFile)i.next();
            this.addDependentsOf(cf.getClassName());
        }
    }
}

