/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.aspectj.ajdt.internal.compiler.AjCompiler;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.parser.AjParser;
import org.aspectj.ajdt.internal.compiler.problem.AjProblemReporter;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjState;
import org.aspectj.ajdt.internal.core.builder.EclipseAdapterUtils;
import org.aspectj.ajdt.internal.core.builder.EmacsStructureModelManager;
import org.aspectj.ajdt.internal.core.builder.StatefulNameEnvironment;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureModel;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.CountingMessageHandler;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelWeaver;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

public class AjBuildManager {
    static final boolean FAIL_IF_RUNTIME_NOT_FOUND = false;
    private IProgressListener progressListener = null;
    private int compiledCount;
    private int sourceFileCount;
    private StructureModel structureModel;
    public AjBuildConfig buildConfig;
    AjState state = new AjState(this);
    BcelWeaver bcelWeaver;
    public BcelWorld bcelWorld;
    public CountingMessageHandler handler;

    public AjBuildManager(IMessageHandler holder) {
        this.handler = CountingMessageHandler.makeCountingMessageHandler(holder);
    }

    public boolean doGenerateModel() {
        return this.buildConfig.isGenerateModelMode();
    }

    public boolean batchBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler) throws IOException, AbortException {
        return this.doBuild(buildConfig, baseHandler, true);
    }

    public boolean incrementalBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler) throws IOException, AbortException {
        return this.doBuild(buildConfig, baseHandler, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doBuild(AjBuildConfig buildConfig, IMessageHandler baseHandler, boolean batch) throws IOException, AbortException {
        boolean bl;
        block20: {
            boolean bl2;
            block18: {
                boolean bl3;
                block17: {
                    try {
                        block19: {
                            boolean canIncremental;
                            if (batch) {
                                this.state = new AjState(this);
                            }
                            if (!(canIncremental = this.state.prepareForNextBuild(buildConfig)) && !batch) {
                                boolean bl4 = this.doBuild(buildConfig, baseHandler, true);
                                Object var10_7 = null;
                                this.handler = null;
                                return bl4;
                            }
                            this.handler = CountingMessageHandler.makeCountingMessageHandler(baseHandler);
                            String check = this.checkRtJar(buildConfig);
                            if (check != null) {
                                MessageUtil.warn(this.handler, check);
                            }
                            this.setBuildConfig(buildConfig);
                            this.setupModel();
                            if (batch) {
                                this.initBcelWorld(this.handler);
                            }
                            if (this.handler.hasErrors()) {
                                bl3 = false;
                                break block17;
                            }
                            if (batch) {
                                if (buildConfig.isEmacsSymMode() || buildConfig.isGenerateModelMode()) {
                                    this.bcelWorld.setModel(StructureModelManager.INSTANCE.getStructureModel());
                                }
                                this.performCompilation(buildConfig.getFiles());
                                if (this.handler.hasErrors()) {
                                    bl2 = false;
                                    break block18;
                                }
                            } else {
                                List files = this.state.getFilesToCompile(true);
                                int i = 0;
                                while (true) {
                                    if (i >= 5 || files.isEmpty()) {
                                        if (!files.isEmpty()) {
                                            break;
                                        }
                                        break block19;
                                    }
                                    this.performCompilation(files);
                                    if (this.handler.hasErrors()) {
                                        boolean bl5 = false;
                                        Object var10_10 = null;
                                        this.handler = null;
                                        return bl5;
                                    }
                                    files = this.state.getFilesToCompile(false);
                                    ++i;
                                }
                                boolean bl6 = this.batchBuild(buildConfig, baseHandler);
                                Object var10_11 = null;
                                this.handler = null;
                                return bl6;
                            }
                        }
                        if (buildConfig.isEmacsSymMode()) {
                            new EmacsStructureModelManager().externalizeModel();
                        }
                        this.state.successfulCompile(buildConfig);
                        boolean weaved = this.weaveAndGenerateClassFiles();
                        if (buildConfig.isGenerateModelMode()) {
                            StructureModelManager.INSTANCE.fireModelUpdated();
                        }
                        bl = !this.handler.hasErrors();
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        this.handler = null;
                        throw throwable;
                    }
                }
                Object var10_8 = null;
                this.handler = null;
                return bl3;
            }
            Object var10_9 = null;
            this.handler = null;
            return bl2;
        }
        Object var10_12 = null;
        this.handler = null;
        return bl;
    }

    private void setupModel() {
        String rootLabel = "<root>";
        StructureModel model = StructureModelManager.INSTANCE.getStructureModel();
        ProgramElementNode.Kind kind = ProgramElementNode.Kind.FILE_JAVA;
        if (this.buildConfig.getConfigFile() != null) {
            rootLabel = this.buildConfig.getConfigFile().getName();
            model.setConfigFile(this.buildConfig.getConfigFile().getAbsolutePath());
            kind = ProgramElementNode.Kind.FILE_LST;
        }
        model.setRoot(new ProgramElementNode(rootLabel, kind, new ArrayList()));
        HashMap modelFileMap = new HashMap();
        model.setFileMap(new HashMap());
        this.setStructureModel(model);
    }

    private void initBcelWorld(IMessageHandler handler) throws IOException {
        this.bcelWorld = new BcelWorld(this.buildConfig.getClasspath(), handler);
        this.bcelWorld.setXnoInline(this.buildConfig.isXnoInline());
        this.bcelWeaver = new BcelWeaver(this.bcelWorld);
        Iterator i = this.buildConfig.getAspectpath().iterator();
        while (i.hasNext()) {
            File f = (File)i.next();
            this.bcelWeaver.addLibraryJarFile(f);
        }
        String lintMode = this.buildConfig.getLintMode();
        if (this.buildConfig.getLintMode().equals("default")) {
            this.bcelWorld.getLint().loadDefaultProperties();
        } else {
            this.bcelWorld.getLint().setAll(this.buildConfig.getLintMode());
        }
        if (this.buildConfig.getLintSpecFile() != null) {
            this.bcelWorld.getLint().setFromProperties(this.buildConfig.getLintSpecFile());
        }
        Iterator i2 = this.buildConfig.getInJars().iterator();
        while (i2.hasNext()) {
            File inJar = (File)i2.next();
            this.bcelWeaver.addJarFile(inJar, this.buildConfig.getOutputDir());
        }
        this.bcelWorld.resolve("org.aspectj.lang.JoinPoint");
    }

    public World getWorld() {
        return this.bcelWorld;
    }

    void addAspectClassFilesToWeaver(List addedClassFiles) throws IOException {
        Iterator i = addedClassFiles.iterator();
        while (i.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i.next();
            this.bcelWeaver.addClassFile(classFile);
        }
    }

    public boolean weaveAndGenerateClassFiles() throws IOException {
        this.handler.handleMessage(MessageUtil.info("weaving"));
        if (this.progressListener != null) {
            this.progressListener.setText("weaving aspects");
        }
        this.bcelWeaver.setProgressListener(this.progressListener, 0.5, 0.5 / (double)this.state.addedClassFiles.size());
        this.addAspectClassFilesToWeaver(this.state.addedClassFiles);
        if (this.buildConfig.isNoWeave()) {
            if (this.buildConfig.getOutputJar() != null) {
                this.bcelWeaver.dumpUnwoven(this.buildConfig.getOutputJar());
            } else {
                this.bcelWeaver.dumpUnwoven();
            }
        } else if (this.buildConfig.getOutputJar() != null) {
            this.bcelWeaver.weave(this.buildConfig.getOutputJar());
        } else {
            this.bcelWeaver.weave();
        }
        if (this.progressListener != null) {
            this.progressListener.setProgress(1.0);
        }
        return true;
    }

    public FileSystem getLibraryAccess(String[] classpaths, String[] filenames) {
        String defaultEncoding = (String)this.buildConfig.getJavaOptions().get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        return new FileSystem(classpaths, filenames, defaultEncoding);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public CompilationUnit[] getCompilationUnits(String[] filenames, String[] encodings) {
        int fileCount = filenames.length;
        CompilationUnit[] units = new CompilationUnit[fileCount];
        HashtableOfObject knownFileNames = new HashtableOfObject(fileCount);
        String defaultEncoding = (String)this.buildConfig.getJavaOptions().get("org.eclipse.jdt.core.encoding");
        if ("".equals(defaultEncoding)) {
            defaultEncoding = null;
        }
        int i = 0;
        while (i < fileCount) {
            String encoding = encodings[i];
            if (encoding == null) {
                encoding = defaultEncoding;
            }
            units[i] = new CompilationUnit(null, filenames[i], encoding);
            ++i;
        }
        return units;
    }

    public String extractDestinationPathFromSourceFile(CompilationResult result) {
        ICompilationUnit compilationUnit = result.compilationUnit;
        if (compilationUnit != null) {
            char[] fileName = compilationUnit.getFileName();
            int lastIndex = CharOperation.lastIndexOf(File.separatorChar, fileName);
            if (lastIndex == -1) {
                return System.getProperty("user.dir");
            }
            return new String(CharOperation.subarray(fileName, 0, lastIndex));
        }
        return System.getProperty("user.dir");
    }

    public void performCompilation(List files) {
        EclipseFactory factory;
        if (this.progressListener != null) {
            this.compiledCount = 0;
            this.sourceFileCount = files.size();
            this.progressListener.setText("compiling source files");
        }
        String[] filenames = new String[files.size()];
        String[] encodings = new String[files.size()];
        int i = 0;
        while (i < files.size()) {
            filenames[i] = ((File)files.get(i)).getPath();
            ++i;
        }
        List cps = this.buildConfig.getFullClasspath();
        String[] classpaths = new String[cps.size()];
        int i2 = 0;
        while (i2 < cps.size()) {
            classpaths[i2] = (String)cps.get(i2);
            ++i2;
        }
        INameEnvironment environment = this.getLibraryAccess(classpaths, filenames);
        if (!this.state.classesFromName.isEmpty()) {
            environment = new StatefulNameEnvironment(environment, this.state.classesFromName);
        }
        AjCompiler compiler = new AjCompiler(environment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.buildConfig.getJavaOptions(), this.getBatchRequestor(), this.getProblemFactory());
        AjProblemReporter pr = new AjProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compiler.options, this.getProblemFactory());
        compiler.problemReporter = pr;
        AjLookupEnvironment le = new AjLookupEnvironment(compiler, compiler.options, pr, environment);
        le.factory = factory = new EclipseFactory(le);
        pr.world = factory;
        le.factory.buildManager = this;
        compiler.lookupEnvironment = le;
        compiler.parser = new AjParser(pr, compiler.options.parseLiteralExpressionsAsConstants, compiler.options.sourceLevel >= 3);
        CompilerOptions options = compiler.options;
        options.produceReferenceInfo(true);
        compiler.compile(this.getCompilationUnits(filenames, encodings));
        environment.cleanup();
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(){
            int lineDelta = 0;

            public void acceptResult(CompilationResult compilationResult) {
                if (AjBuildManager.this.progressListener != null) {
                    AjBuildManager.this.compiledCount++;
                    AjBuildManager.this.progressListener.setProgress((double)AjBuildManager.this.compiledCount / 2.0 / (double)AjBuildManager.this.sourceFileCount);
                    AjBuildManager.this.progressListener.setText("compiled: " + new String(compilationResult.getFileName()));
                }
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    IProblem[] problems = compilationResult.getAllProblems();
                    int i = 0;
                    while (i < problems.length) {
                        IMessage message = EclipseAdapterUtils.makeMessage(compilationResult.compilationUnit, problems[i]);
                        AjBuildManager.this.handler.handleMessage(message);
                        ++i;
                    }
                }
                AjBuildManager.this.outputClassFiles(compilationResult);
            }
        };
    }

    private boolean proceedOnError() {
        return true;
    }

    public void outputClassFiles(CompilationResult unitResult) {
        if (unitResult == null) {
            return;
        }
        String sourceFileName = new String(unitResult.fileName);
        if (!unitResult.hasErrors() || this.proceedOnError()) {
            ArrayList<UnwovenClassFile> unwovenClassFiles = new ArrayList<UnwovenClassFile>();
            Enumeration classFiles = unitResult.compiledTypes.elements();
            while (classFiles.hasMoreElements()) {
                ClassFile classFile = (ClassFile)classFiles.nextElement();
                String filename = new String(classFile.fileName());
                filename = filename.replace('/', File.separatorChar) + ".class";
                File destinationPath = this.buildConfig.getOutputDir();
                if (destinationPath == null) {
                    filename = new File(filename).getName();
                    filename = new File(this.extractDestinationPathFromSourceFile(unitResult), filename).getPath();
                } else {
                    filename = new File(destinationPath, filename).getPath();
                }
                unwovenClassFiles.add(new UnwovenClassFile(filename, classFile.getBytes()));
            }
            this.state.noteClassesFromFile(unitResult, sourceFileName, unwovenClassFiles);
        } else {
            this.state.noteClassesFromFile(null, sourceFileName, Collections.EMPTY_LIST);
        }
    }

    private void setBuildConfig(AjBuildConfig buildConfig) {
        this.buildConfig = buildConfig;
        this.handler.reset();
    }

    String makeClasspathString() {
        if (this.buildConfig == null || this.buildConfig.getClasspath() == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        Iterator it = this.buildConfig.getClasspath().iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(it.next().toString());
        }
        return buf.toString();
    }

    public String checkRtJar(AjBuildConfig buildConfig) {
        if ("1.1.0".equals("DEVELOPMENT")) {
            return null;
        }
        if (buildConfig == null || buildConfig.getClasspath() == null) {
            return "no classpath specified";
        }
        Iterator it = buildConfig.getClasspath().iterator();
        while (it.hasNext()) {
            File p = new File((String)it.next());
            if (!p.isFile() || !p.getName().equals("aspectjrt.jar")) continue;
            try {
                String version = null;
                Manifest manifest = new JarFile(p).getManifest();
                if (manifest == null) {
                    return "no manifest found in " + p.getAbsolutePath() + ", expected " + "1.1.0";
                }
                Attributes attr = manifest.getAttributes("org/aspectj/lang/");
                if (null != attr && null != (version = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION))) {
                    version = version.trim();
                }
                if ("DEVELOPMENT".equals(version)) {
                    return null;
                }
                if (!"1.1.0".equals(version)) {
                    return "bad version number found in " + p.getAbsolutePath() + " expected " + "1.1.0" + " found " + version;
                }
            }
            catch (IOException ioe) {
                return "bad jar file found in " + p.getAbsolutePath() + " error: " + ioe;
            }
            return null;
        }
        return "couldn't find aspectjrt.jar on classpath, checked: " + this.makeClasspathString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AjBuildManager(");
        buf.append(")");
        return buf.toString();
    }

    public void setStructureModel(StructureModel structureModel) {
        this.structureModel = structureModel;
    }

    public StructureModel getStructureModel() {
        return this.structureModel;
    }

    public IProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(IProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

