/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class SuperFixerVisitor
extends AbstractSyntaxTreeVisitorAdapter {
    Set superMethodsCalled = new HashSet();
    AbstractMethodDeclaration method;
    ReferenceBinding targetClass;

    SuperFixerVisitor(AbstractMethodDeclaration method, ReferenceBinding targetClass) {
        this.method = method;
        this.targetClass = targetClass;
    }

    public void endVisit(MessageSend call, BlockScope scope) {
        MethodBinding superAccessBinding;
        char[] accessName;
        if (call.codegenBinding == null) {
            return;
        }
        MethodBinding superBinding = call.codegenBinding;
        if (superBinding instanceof ProblemMethodBinding) {
            return;
        }
        if (superBinding instanceof InterTypeMethodBinding) {
            return;
        }
        if (call.isSuperAccess() && !call.binding.isStatic()) {
            call.receiver = new ThisReference(call.receiver.sourceStart, call.receiver.sourceEnd);
            accessName = NameMangler.superDispatchMethod(EclipseFactory.fromBinding(this.targetClass), new String(superBinding.selector)).toCharArray();
        } else if (call.receiver.isThis() && call.binding.isProtected() && !call.binding.isStatic()) {
            accessName = superBinding.declaringClass.equals(this.targetClass) ? NameMangler.protectedDispatchMethod(EclipseFactory.fromBinding(this.targetClass), new String(superBinding.selector)).toCharArray() : NameMangler.superDispatchMethod(EclipseFactory.fromBinding(this.targetClass), new String(superBinding.selector)).toCharArray();
        } else {
            return;
        }
        call.codegenBinding = superAccessBinding = new MethodBinding(1, accessName, superBinding.returnType, superBinding.parameters, superBinding.thrownExceptions, this.targetClass);
        ResolvedMember targetMember = EclipseFactory.makeResolvedMember(superBinding);
        this.superMethodsCalled.add(targetMember);
    }
}

