/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.SuperFixerVisitor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;

public abstract class InterTypeDeclaration
extends MethodDeclaration {
    public TypeReference onType;
    protected ReferenceBinding onTypeBinding;
    protected ResolvedTypeMunger munger;
    protected int declaredModifiers;
    protected char[] declaredSelector;

    public InterTypeDeclaration(CompilationResult result, TypeReference onType) {
        super(result);
        this.onType = onType;
        this.modifiers = 9;
    }

    public void setDeclaredModifiers(int modifiers) {
        this.declaredModifiers = modifiers;
    }

    public void setSelector(char[] selector) {
        this.declaredSelector = selector;
        this.selector = CharOperation.concat(selector, Integer.toHexString(this.sourceStart).toCharArray());
    }

    public void resolve(ClassScope upperScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        InterTypeScope newParent = new InterTypeScope((Scope)upperScope, this.onTypeBinding);
        this.scope.parent = newParent;
        this.scope.isStatic = Modifier.isStatic(this.declaredModifiers);
        super.resolve(newParent);
        this.fixSuperCallsInBody();
    }

    public abstract EclipseTypeMunger build(ClassScope var1);

    public void fixSuperCallsInBody() {
        SuperFixerVisitor v = new SuperFixerVisitor(this, this.onTypeBinding);
        this.traverse((IAbstractSyntaxTreeVisitor)v, (ClassScope)null);
        this.munger.setSuperMethodsCalled(v.superMethodsCalled);
    }

    protected void resolveOnType(ClassScope classScope) {
        this.checkSpec();
        this.onTypeBinding = (ReferenceBinding)this.onType.getTypeBinding(classScope);
        if (!this.onTypeBinding.isValidBinding()) {
            classScope.problemReporter().invalidType(this.onType, this.onTypeBinding);
            this.ignoreFurtherInvestigation = true;
        }
    }

    protected void checkSpec() {
        if (Modifier.isProtected(this.declaredModifiers)) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "protected inter-type declarations are not allowed");
            this.ignoreFurtherInvestigation = true;
        }
    }

    protected List makeEffectiveSignatureAttribute(ResolvedMember sig, Shadow.Kind kind, boolean weaveBody) {
        ArrayList<EclipseAttributeAdapter> l = new ArrayList<EclipseAttributeAdapter>(1);
        l.add(new EclipseAttributeAdapter(new AjAttribute.EffectiveSignatureAttribute(sig, kind, weaveBody)));
        return l;
    }

    protected void setMunger(ResolvedTypeMunger munger) {
        munger.getSignature().setPosition(this.sourceStart, this.sourceEnd);
        munger.getSignature().setSourceContext(new EclipseSourceContext(this.compilationResult));
        this.munger = munger;
    }

    protected int generateInfoAttributes(ClassFile classFile) {
        Shadow.Kind kind = this.getShadowKindForBody();
        List l = kind != null ? this.makeEffectiveSignatureAttribute(this.munger.getSignature(), kind, true) : new ArrayList(0);
        return classFile.generateMethodInfoAttribute(this.binding, l);
    }

    protected abstract Shadow.Kind getShadowKindForBody();

    public ResolvedMember getSignature() {
        return this.munger.getSignature();
    }
}

