/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.ajc;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.ConfigParser;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.batch.Main;

public class BuildArgParser
extends Main {
    private static final String BUNDLE_NAME = "org.aspectj.ajdt.ajc.messages";
    private static boolean LOADED_BUNDLE = false;
    private final StringBuffer errorSink;

    public static String getUsage() {
        if (!LOADED_BUNDLE) {
            new BuildArgParser();
        }
        return Main.bind("misc.usage", Main.bind("compiler.version"));
    }

    public BuildArgParser(PrintWriter writer) {
        super(writer, writer, false);
        Main.bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        if (!LOADED_BUNDLE) {
            LOADED_BUNDLE = true;
        }
        this.errorSink = writer instanceof StringPrintWriter ? ((StringPrintWriter)writer).stringWriter.getBuffer() : null;
    }

    public BuildArgParser() {
        this(new StringPrintWriter(new StringWriter()));
    }

    public AjBuildConfig genBuildConfig(String[] args, IMessageHandler handler) {
        AjBuildConfig buildConfig = new AjBuildConfig();
        try {
            this.filenames = new String[]{""};
            ArrayList fileList = new ArrayList();
            AjcConfigParser parser = new AjcConfigParser(buildConfig, handler);
            parser.parseCommandLine(args);
            boolean incrementalMode = buildConfig.isIncrementalMode() || buildConfig.isIncrementalFileMode();
            List files = parser.getFiles();
            if (!LangUtil.isEmpty(files)) {
                if (incrementalMode) {
                    MessageUtil.error(handler, "incremental mode only handles source files using -sourceroots");
                } else {
                    fileList.addAll(files);
                }
            }
            ArrayList<String> javaArgList = new ArrayList<String>();
            javaArgList.add("-warn:none");
            javaArgList.add("-classpath");
            javaArgList.add(System.getProperty("user.dir"));
            javaArgList.add("-bootclasspath");
            javaArgList.add(System.getProperty("user.dir"));
            javaArgList.addAll(parser.getUnparsedArgs());
            super.configure(javaArgList.toArray(new String[javaArgList.size()]));
            if (buildConfig.getSourceRoots() != null) {
                Iterator i = buildConfig.getSourceRoots().iterator();
                while (i.hasNext()) {
                    fileList.addAll(this.collectSourceRootFiles((File)i.next()));
                }
            }
            buildConfig.setFiles(fileList);
            if (this.destinationPath != null) {
                buildConfig.setOutputDir(new File(this.destinationPath));
            }
            buildConfig.setClasspath(this.getClasspath(parser));
            if (incrementalMode && 0 == buildConfig.getSourceRoots().size()) {
                MessageUtil.error(handler, "specify a source root when in incremental mode");
            }
            this.setDebugOptions();
            buildConfig.setJavaOptions(this.options);
        }
        catch (InvalidInputException iie) {
            MessageUtil.error(handler, iie.getMessage());
        }
        return buildConfig;
    }

    public String getOtherMessages(boolean flush) {
        if (null == this.errorSink) {
            return null;
        }
        String result = this.errorSink.toString().trim();
        if (0 == result.length()) {
            result = null;
        }
        if (flush) {
            this.errorSink.setLength(0);
        }
        return result;
    }

    private void setDebugOptions() {
        this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
    }

    private Collection collectSourceRootFiles(File dir) {
        return Arrays.asList(FileUtil.listFiles(dir, FileUtil.aspectjSourceFileFilter));
    }

    public List getClasspath(AjcConfigParser parser) {
        ArrayList ret = new ArrayList();
        if (parser.bootclasspath == null) {
            this.addClasspath(System.getProperty("sun.boot.class.path", ""), ret);
        } else {
            this.addClasspath(parser.bootclasspath, ret);
        }
        String extdirs = parser.extdirs;
        if (extdirs == null) {
            extdirs = System.getProperty("java.ext.dirs", "");
        }
        this.addExtDirs(extdirs, ret);
        if (parser.classpath == null) {
            this.addClasspath(System.getProperty("java.class.path", ""), ret);
        } else {
            this.addClasspath(parser.classpath, ret);
        }
        return ret;
    }

    private void addExtDirs(String extdirs, List classpathCollector) {
        StringTokenizer tokenizer = new StringTokenizer(extdirs, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File dirFile = new File(tokenizer.nextToken());
            if (!dirFile.exists() || !dirFile.isDirectory()) continue;
            File[] files = FileUtil.listFiles(dirFile, new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            });
            int i = 0;
            while (i < files.length) {
                classpathCollector.add(files[i].getAbsolutePath());
                ++i;
            }
        }
    }

    private void addClasspath(String classpath, List classpathCollector) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            classpathCollector.add(tokenizer.nextToken());
        }
    }

    private class AjcConfigParser
    extends ConfigParser {
        private String bootclasspath = null;
        private String classpath = null;
        private String extdirs = null;
        private List unparsedArgs = new ArrayList();
        private AjBuildConfig buildConfig;
        private IMessageHandler handler;

        public AjcConfigParser(AjBuildConfig buildConfig, IMessageHandler handler) {
            this.buildConfig = buildConfig;
            this.handler = handler;
        }

        public List getUnparsedArgs() {
            return this.unparsedArgs;
        }

        public void parseOption(String arg, LinkedList args) {
            int nextArgIndex = args.indexOf(arg) + 1;
            if (LangUtil.isEmpty(arg)) {
                this.showWarning("empty arg found");
            } else if (arg.equals("-injars")) {
                if (args.size() > nextArgIndex) {
                    this.buildConfig.getAjOptions().put("org.aspectj.ajdt.core.compiler.injars", "preserve");
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (jarFile.exists() && FileUtil.hasZipSuffix(filename)) {
                            this.buildConfig.getInJars().add(jarFile);
                            continue;
                        }
                        this.showError("bad injar: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-aspectpath")) {
                if (args.size() > nextArgIndex) {
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String filename = st.nextToken();
                        File jarFile = this.makeFile(filename);
                        if (jarFile.exists() && FileUtil.hasZipSuffix(filename)) {
                            this.buildConfig.getAspectpath().add(jarFile);
                            continue;
                        }
                        this.showError("bad aspectpath: " + filename);
                    }
                    args.remove(args.get(nextArgIndex));
                }
            } else if (arg.equals("-sourceroots")) {
                if (args.size() > nextArgIndex) {
                    ArrayList<File> sourceRoots = new ArrayList<File>();
                    StringTokenizer st = new StringTokenizer(((ConfigParser.Arg)args.get(nextArgIndex)).getValue(), File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        File f = this.makeFile(st.nextToken());
                        if (f.isDirectory() && f.canRead()) {
                            sourceRoots.add(f);
                            continue;
                        }
                        this.showError("bad sourceroot: " + f);
                    }
                    if (0 < sourceRoots.size()) {
                        this.buildConfig.setSourceRoots(sourceRoots);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-sourceroots requires list of directories");
                }
            } else if (arg.equals("-outjar")) {
                if (args.size() > nextArgIndex) {
                    this.buildConfig.getAjOptions().put("org.aspectj.ajdt.core.compiler.outjar", "generate");
                    File jarFile = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    if (FileUtil.hasZipSuffix(jarFile)) {
                        try {
                            if (!jarFile.exists()) {
                                jarFile.createNewFile();
                            }
                            this.buildConfig.setOutputJar(jarFile);
                        }
                        catch (IOException ioe) {
                            this.showError("unable to create outjar file: " + jarFile);
                        }
                    } else {
                        this.showError("invalid -outjar file: " + jarFile);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-outjar requires jar path argument");
                }
            } else if (arg.equals("-incremental")) {
                this.buildConfig.setIncrementalMode(true);
            } else if (arg.equals("-XincrementalFile")) {
                if (args.size() > nextArgIndex) {
                    File file = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    this.buildConfig.setIncrementalFile(file);
                    if (!file.canRead()) {
                        this.showError("bad -XincrementalFile : " + file);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-XincrementalFile requires file argument");
                }
            } else if (arg.equals("-emacssym")) {
                this.buildConfig.setEmacsSymMode(true);
                this.buildConfig.setGenerateModelMode(true);
            } else if (arg.equals("-noweave") || arg.equals("-XnoWeave")) {
                this.buildConfig.setNoWeave(true);
            } else if (arg.equals("-XserializableAspects")) {
                this.buildConfig.setXserializableAspects(true);
            } else if (arg.equals("-XnoInline")) {
                this.buildConfig.setXnoInline(true);
            } else if (arg.equals("-Xlintfile")) {
                if (args.size() > nextArgIndex) {
                    File lintSpecFile = this.makeFile(((ConfigParser.Arg)args.get(nextArgIndex)).getValue());
                    if (lintSpecFile.canRead() && lintSpecFile.getName().endsWith(".properties")) {
                        this.buildConfig.setLintSpecFile(lintSpecFile);
                    } else {
                        this.showError("bad -Xlintfile file: " + lintSpecFile);
                        this.buildConfig.setLintSpecFile(null);
                    }
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-Xlintfile requires .properties file argument");
                }
            } else if (arg.equals("-Xlint")) {
                this.buildConfig.getAjOptions().put("org.aspectj.ajdt.core.compiler.Xlint", "generate");
                this.buildConfig.setLintMode("default");
            } else if (arg.startsWith("-Xlint:")) {
                if (7 < arg.length()) {
                    this.buildConfig.setLintMode(arg.substring(7));
                } else {
                    this.showError("invalid lint option " + arg);
                }
            } else if (arg.equals("-bootclasspath")) {
                if (args.size() > nextArgIndex) {
                    this.bootclasspath = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-bootclasspath requires classpath entries");
                }
            } else if (arg.equals("-classpath")) {
                if (args.size() > nextArgIndex) {
                    this.classpath = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-classpath requires classpath entries");
                }
            } else if (arg.equals("-extdirs")) {
                if (args.size() > nextArgIndex) {
                    this.extdirs = ((ConfigParser.Arg)args.get(nextArgIndex)).getValue();
                    args.remove(args.get(nextArgIndex));
                } else {
                    this.showError("-extdirs requires list of external directories");
                }
            } else if (arg.equals("-d")) {
                this.dirLookahead(arg, args, nextArgIndex);
            } else if (new File(arg).isDirectory()) {
                this.showError("dir arg not permitted: " + arg);
            } else {
                this.unparsedArgs.add(arg);
            }
        }

        protected void dirLookahead(String arg, LinkedList argList, int nextArgIndex) {
            this.unparsedArgs.add(arg);
            ConfigParser.Arg next = (ConfigParser.Arg)argList.get(nextArgIndex);
            String value = next.getValue();
            if (!LangUtil.isEmpty(value) && new File(value).isDirectory()) {
                this.unparsedArgs.add(value);
                argList.remove(next);
                return;
            }
        }

        public void showError(String message) {
            MessageUtil.error(this.handler, ConfigParser.CONFIG_MSG + message);
        }

        protected void showWarning(String message) {
            MessageUtil.warn(this.handler, message);
        }
    }

    private static class StringPrintWriter
    extends PrintWriter {
        public final StringWriter stringWriter;

        StringPrintWriter(StringWriter sw) {
            super(sw);
            this.stringWriter = sw;
        }
    }
}

