/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import org.aspectj.asm.StructureNode;

public class BuildConfigNode
extends StructureNode {
    private String resourcePath;
    private Kind kind;
    private boolean isActive = true;

    public BuildConfigNode(String name, Kind kind, String resourcePath) {
        super(name, kind.toString());
        this.kind = kind;
        this.resourcePath = resourcePath;
    }

    public BuildConfigNode(String name, String kind, String resourcePath, List children) {
        super(name, kind, children);
        this.resourcePath = resourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public boolean isValidResource() {
        return this.name.endsWith(".java") || this.name.endsWith(".aj") || this.name.endsWith(".lst");
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Kind getBuildConfigNodeKind() {
        return this.kind;
    }

    public static class Kind
    implements Serializable {
        public static final Kind FILE_JAVA = new Kind("Java source file");
        public static final Kind FILE_ASPECTJ = new Kind("AspectJ source file");
        public static final Kind FILE_LST = new Kind("build configuration file");
        public static final Kind ERROR = new Kind("error");
        public static final Kind DIRECTORY = new Kind("directory");
        public static final Kind[] ALL = new Kind[]{FILE_JAVA, FILE_ASPECTJ, FILE_LST, DIRECTORY};
        private final String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Kind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o.equals(this.name);
        }

        public boolean isDeclareKind() {
            return this.name.startsWith("declare");
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL[this.ordinal];
        }
    }
}

