/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.asm.StructureModel;

public class BuildConfigModel
extends StructureModel {
    private String sourceFile;

    public BuildConfigModel(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public BuildConfigNode getNodeForPath(String path) {
        BuildConfigNode upPathMatch = this.searchUpPaths(path);
        if (upPathMatch != null && upPathMatch != this.root) {
            return upPathMatch;
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        BuildConfigNode node = (BuildConfigNode)this.root;
        return this.getNodeForPathHelper(st, node);
    }

    private BuildConfigNode searchUpPaths(String path) {
        Iterator it = this.root.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode node = (BuildConfigNode)it.next();
            if (!node.getName().equals(path)) continue;
            return node;
        }
        return null;
    }

    private BuildConfigNode getNodeForPathHelper(StringTokenizer st, BuildConfigNode node) {
        BuildConfigNode parent = node;
        while (st.hasMoreElements()) {
            String pathItem = (String)st.nextElement();
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                node = (BuildConfigNode)it.next();
                String childName = node.getName();
                if (!childName.equals(pathItem)) continue;
                return this.getNodeForPathHelper(st, node);
            }
        }
        return parent;
    }

    public List getActiveNodes(BuildConfigNode.Kind kind) {
        ArrayList nodes = new ArrayList();
        this.getActiveNodesHelper((BuildConfigNode)this.getRoot(), kind, nodes);
        return nodes;
    }

    private void getActiveNodesHelper(BuildConfigNode node, BuildConfigNode.Kind kind, List nodes) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode currNode = (BuildConfigNode)it.next();
            if (currNode.getBuildConfigNodeKind().equals(kind) && currNode.isActive()) {
                nodes.add(currNode);
            }
            this.getActiveNodesHelper(currNode, kind, nodes);
        }
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }
}

