/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildConfigListener;
import org.aspectj.ajde.BuildConfigManager;
import org.aspectj.ajde.internal.LstBuildConfigFileParser;
import org.aspectj.ajde.internal.LstBuildConfigFileUpdater;
import org.aspectj.ajde.ui.BuildConfigModel;
import org.aspectj.ajde.ui.BuildConfigNode;
import org.aspectj.asm.StructureNode;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.ConfigParser;

public class LstBuildConfigManager
implements BuildConfigManager {
    private List configFiles = new ArrayList();
    private List listeners = new ArrayList();
    private LstBuildConfigFileUpdater fileUpdater = new LstBuildConfigFileUpdater();
    protected String currConfigFilePath = null;
    private static final FilenameFilter SOURCE_FILE_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".java") || name.endsWith(".aj") || name.endsWith(".lst");
        }
    };
    private static final FileFilter DIR_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static final Comparator ALPHABETICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            BuildConfigNode n1 = (BuildConfigNode)o1;
            BuildConfigNode n2 = (BuildConfigNode)o2;
            return n1.getName().compareTo(n2.getName());
        }
    };

    public BuildConfigModel buildModel(String configFilePath) {
        File configFile = new File(configFilePath);
        String rootPath = configFile.getParent();
        String configFileName = configFile.getName();
        BuildConfigModel model = new BuildConfigModel(configFilePath);
        List configFiles = new ArrayList();
        List importedFiles = new ArrayList();
        List badEntries = null;
        try {
            LstBuildConfigFileParser configParser = new LstBuildConfigFileParser(configFilePath);
            configParser.parseConfigFile(new File(configFilePath));
            configFiles = configParser.getFiles();
            importedFiles = configParser.getImportedFiles();
            badEntries = configParser.getProblemEntries();
        }
        catch (ConfigParser.ParseException pe) {
            Message message = new Message(pe.getMessage(), IMessage.ERROR, pe, new SourceLocation(pe.getFile(), pe.getLine(), 1));
            Ajde.getDefault().getTaskListManager().addSourcelineTask(message);
        }
        List relativePaths = this.relativizeFilePaths(configFiles, rootPath);
        BuildConfigNode root = new BuildConfigNode(configFileName, BuildConfigNode.Kind.FILE_LST, rootPath);
        this.buildDirTree(root, rootPath, importedFiles, configFileName);
        model.setRoot(root);
        this.addFilesToDirTree(model, relativePaths, badEntries);
        this.pruneEmptyDirs(root);
        this.sortModel((BuildConfigNode)model.getRoot(), ALPHABETICAL_COMPARATOR);
        this.addProblemEntries(root, badEntries);
        return model;
    }

    private void addProblemEntries(BuildConfigNode root, List badEntries) {
        Iterator it = badEntries.iterator();
        while (it.hasNext()) {
            root.addChild(new BuildConfigNode(it.next().toString(), BuildConfigNode.Kind.ERROR, null));
        }
    }

    public void writeModel(BuildConfigModel model) {
        List activeSourceFiles = model.getActiveNodes(BuildConfigNode.Kind.FILE_ASPECTJ);
        activeSourceFiles.addAll(model.getActiveNodes(BuildConfigNode.Kind.FILE_JAVA));
        List activeImportedFiles = model.getActiveNodes(BuildConfigNode.Kind.FILE_LST);
        this.fileUpdater.writeConfigFile(model.getSourceFile(), activeSourceFiles, activeImportedFiles);
    }

    public void writePaths(String configFilePath, List files) {
        this.fileUpdater.writeConfigFile(configFilePath, files);
    }

    public void addFilesToConfig(String configFilePath, List paths) {
    }

    public void removeFilesFromConfig(String configFilePath, List files) {
    }

    private List relativizeFilePaths(List configFiles, String rootPath) {
        ArrayList<String> relativePathsList = new ArrayList<String>();
        Iterator it = configFiles.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            relativePathsList.add(this.fileUpdater.relativizePath(file.getPath(), rootPath));
        }
        return relativePathsList;
    }

    private void buildDirTree(BuildConfigNode node, String rootPath, List importedFiles, String configFileName) {
        File[] dirs = new File(node.getResourcePath()).listFiles(DIR_FILTER);
        if (dirs == null) {
            return;
        }
        int i = 0;
        while (i < dirs.length) {
            BuildConfigNode dir = new BuildConfigNode(dirs[i].getName(), BuildConfigNode.Kind.DIRECTORY, dirs[i].getPath());
            File[] files = dirs[i].listFiles(SOURCE_FILE_FILTER);
            int j = 0;
            while (j < files.length) {
                if (files[j] != null) {
                    String filePath = this.fileUpdater.relativizePath(files[j].getPath(), rootPath);
                    BuildConfigNode.Kind kind = BuildConfigNode.Kind.FILE_JAVA;
                    if (!files[j].getName().endsWith(".lst")) {
                        BuildConfigNode file = new BuildConfigNode(files[j].getName(), kind, filePath);
                        file.setActive(false);
                        dir.addChild(file);
                    }
                }
                ++j;
            }
            node.addChild(dir);
            boolean foundMatch = false;
            Iterator it = importedFiles.iterator();
            while (it.hasNext()) {
                File importedFile = (File)it.next();
                if (!importedFile.getParentFile().getAbsolutePath().equals(dirs[i].getAbsolutePath())) continue;
                foundMatch = true;
                BuildConfigNode importedFileNode = new BuildConfigNode(importedFile.getName(), BuildConfigNode.Kind.FILE_LST, this.fileUpdater.relativizePath(importedFile.getPath(), rootPath));
                importedFileNode.setActive(true);
                boolean found = false;
                Iterator it2 = dir.getChildren().iterator();
                while (it2.hasNext()) {
                    if (!((BuildConfigNode)it2.next()).getName().equals(importedFile.getName())) continue;
                    found = true;
                }
                if (found) continue;
                dir.addChild(importedFileNode);
            }
            this.buildDirTree(dir, rootPath, importedFiles, configFileName);
            ++i;
        }
        if (node.getName().endsWith(".lst")) {
            File[] files = new File(rootPath).listFiles(SOURCE_FILE_FILTER);
            if (files == null) {
                return;
            }
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2] != null && !files[i2].getName().equals(configFileName)) {
                    BuildConfigNode.Kind kind = BuildConfigNode.Kind.FILE_JAVA;
                    if (files[i2].getName().endsWith(".lst")) {
                        kind = BuildConfigNode.Kind.FILE_LST;
                    }
                    BuildConfigNode file = new BuildConfigNode(files[i2].getName(), kind, files[i2].getName());
                    file.setActive(false);
                    node.addChild(file);
                }
                ++i2;
            }
        }
    }

    private void addFilesToDirTree(BuildConfigModel model, List configFiles, List badEntries) {
        Iterator it = configFiles.iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            if (path.startsWith("..")) {
                File file = new File(path);
                BuildConfigNode node = new BuildConfigNode(file.getName(), BuildConfigNode.Kind.FILE_JAVA, path);
                BuildConfigNode upPath = model.getNodeForPath(file.getParentFile().getPath());
                if (upPath == model.getRoot()) {
                    upPath = new BuildConfigNode(file.getParentFile().getPath(), BuildConfigNode.Kind.DIRECTORY, file.getParentFile().getAbsolutePath());
                    model.getRoot().addChild(upPath);
                }
                node.setActive(true);
                upPath.addChild(node);
                continue;
            }
            if (!new File(path).isAbsolute()) {
                String name = new File(path).getName();
                BuildConfigNode existingNode = model.getNodeForPath(path);
                existingNode.setActive(true);
                continue;
            }
            badEntries.add("Use relative paths only, omitting: " + path);
        }
    }

    private boolean pruneEmptyDirs(BuildConfigNode node) {
        ArrayList<BuildConfigNode> nodesToRemove = new ArrayList<BuildConfigNode>();
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode currNode = (BuildConfigNode)it.next();
            boolean hasValidChildren = this.pruneEmptyDirs(currNode);
            if (currNode.isValidResource() || hasValidChildren) continue;
            nodesToRemove.add(currNode);
        }
        Iterator it2 = nodesToRemove.iterator();
        while (it2.hasNext()) {
            StructureNode currNode = (StructureNode)it2.next();
            node.removeChild(currNode);
        }
        return node.getChildren().size() > 0;
    }

    public String getActiveConfigFile() {
        if (this.currConfigFilePath == null) {
            return null;
        }
        if (this.currConfigFilePath.equals("<all project files>")) {
            return Ajde.getDefault().getProjectProperties().getDefaultBuildConfigFile();
        }
        return this.currConfigFilePath;
    }

    public void setActiveConfigFile(String currConfigFilePath) {
        this.currConfigFilePath = currConfigFilePath.equals("<all project files>") ? Ajde.getDefault().getProjectProperties().getDefaultBuildConfigFile() : currConfigFilePath;
        this.notifyConfigChanged();
    }

    public void addListener(BuildConfigListener configurationListener) {
        this.listeners.add(configurationListener);
    }

    public void removeListener(BuildConfigListener configurationListener) {
        this.listeners.remove(configurationListener);
    }

    private void notifyConfigChanged() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((BuildConfigListener)it.next()).currConfigChanged(this.currConfigFilePath);
        }
    }

    private void notifyConfigsListUpdated() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((BuildConfigListener)it.next()).configsListUpdated(this.configFiles);
        }
    }

    private void sortModel(BuildConfigNode node, Comparator comparator) {
        if (node == null || node.getChildren() == null) {
            return;
        }
        Collections.sort(node.getChildren(), comparator);
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            BuildConfigNode nextNode = (BuildConfigNode)it.next();
            if (nextNode == null) continue;
            this.sortModel(nextNode, comparator);
        }
    }
}

