/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.netty.connect;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.server.listener.connect.AbstractConnectStateListener;
import asia.stampy.server.netty.ServerNettyMessageGateway;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import javax.annotation.Resource;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Resource
@StampyLibrary(libraryName="stampy-NETTY-client-server-RI")
public class NettyConnectStateListener
extends AbstractConnectStateListener<ServerNettyMessageGateway> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected void ensureCleanup() {
        ((ServerNettyMessageGateway)this.getGateway()).addHandler((ChannelHandler)new SimpleChannelUpstreamHandler(){

            public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                HostPort hostPort = new HostPort((InetSocketAddress)ctx.getChannel().getRemoteAddress());
                if (NettyConnectStateListener.this.connectedClients.contains(hostPort)) {
                    log.debug("{} session terminated with outstanding connection, cleaning up", (Object)hostPort);
                    NettyConnectStateListener.this.connectedClients.remove(hostPort);
                }
            }
        });
    }
}

