/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.server.netty;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.netty.AbstractStampyNettyMessageGateway;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Resource
@StampyLibrary(libraryName="stampy-NETTY-client-server-RI")
public class ServerNettyMessageGateway
extends AbstractStampyNettyMessageGateway {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
    private Channel server;

    private ServerBootstrap init() {
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.factory);
        this.initializeChannel((Bootstrap)bootstrap);
        return bootstrap;
    }

    public void closeConnection(HostPort hostPort) {
        this.getHandler().close(hostPort);
    }

    public void connect() throws Exception {
        if (this.server == null) {
            ServerBootstrap bootstrap = this.init();
            this.server = bootstrap.bind((SocketAddress)new InetSocketAddress(this.getPort()));
            log.info("Bound to {}", (Object)this.getPort());
        } else if (this.server.isConnected()) {
            log.warn("Already connected");
        } else {
            log.error("Acceptor in unrecognized state: isBound {}, isConnected {}, ", (Object)this.server.isBound(), (Object)this.server.isConnected());
        }
    }

    public void shutdown() throws Exception {
        if (this.server == null || !this.server.isConnected()) {
            return;
        }
        ChannelFuture cf = this.server.close();
        cf.awaitUninterruptibly();
        this.server = null;
        log.info("Server has been shut down");
    }
}

