/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.netty;

import asia.stampy.common.StampyLibrary;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

@ChannelHandler.Sharable
@StampyLibrary(libraryName="stampy-NETTY-client-server-RI")
public class StompBasedFrameDecoder
extends FrameDecoder {
    private final int maxLength;
    private final boolean failFast;
    private boolean discarding;

    public StompBasedFrameDecoder(int maxLength) {
        this(maxLength, false);
    }

    public StompBasedFrameDecoder(int maxLength, boolean failFast) {
        this.maxLength = maxLength;
        this.failFast = failFast;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        int eol = StompBasedFrameDecoder.findEndOfMessage(buffer);
        if (eol != -1) {
            ChannelBuffer frame;
            int length = eol - buffer.readerIndex();
            assert (length >= 0) : "Invalid length=" + length;
            if (this.discarding) {
                frame = null;
                buffer.skipBytes(length);
                if (!this.failFast) {
                    this.fail(ctx, "over " + (this.maxLength + length) + " bytes");
                }
            } else {
                byte delim = buffer.getByte(buffer.readerIndex() + length);
                int delimLength = delim == 13 ? 2 : 1;
                frame = this.extractFrame(buffer, buffer.readerIndex(), length + delimLength);
                buffer.skipBytes(length + delimLength);
            }
            return frame;
        }
        int buffered = buffer.readableBytes();
        if (!this.discarding && buffered > this.maxLength) {
            this.discarding = true;
            if (this.failFast) {
                this.fail(ctx, buffered + " bytes buffered already");
            }
        }
        if (this.discarding) {
            buffer.skipBytes(buffer.readableBytes());
        }
        return null;
    }

    private void fail(ChannelHandlerContext ctx, String msg) {
        Channels.fireExceptionCaught((Channel)ctx.getChannel(), (Throwable)new TooLongFrameException("Frame length exceeds " + this.maxLength + " (" + msg + ')'));
    }

    private static int findEndOfMessage(ChannelBuffer buffer) {
        int wIdx = buffer.writerIndex();
        int rIdx = buffer.readerIndex();
        for (int i = buffer.readerIndex(); i < wIdx; ++i) {
            byte b = buffer.getByte(i);
            if (b == 0) {
                return i;
            }
            if (wIdx - rIdx == 2 && b == 13 && i < wIdx - 1 && buffer.getByte(i + 1) == 10) {
                return i;
            }
            if (wIdx - rIdx != 1 || b != 10) continue;
            return i;
        }
        return -1;
    }
}

