/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.netty;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.DefaultUnparseableMessageHandler;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.gateway.MessageListenerHaltException;
import asia.stampy.common.gateway.StampyHandlerHelper;
import asia.stampy.common.gateway.UnparseableMessageHandler;
import asia.stampy.common.heartbeat.StampyHeartbeatContainer;
import asia.stampy.common.message.StampyMessage;
import asia.stampy.common.parsing.StompMessageParser;
import asia.stampy.common.parsing.UnparseableException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelHandler.Sharable
@StampyLibrary(libraryName="stampy-NETTY-client-server-RI")
public abstract class StampyNettyChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StompMessageParser parser = new StompMessageParser();
    private StampyHeartbeatContainer heartbeatContainer;
    private AbstractStampyMessageGateway gateway;
    private static final String ILLEGAL_ACCESS_ATTEMPT = "Illegal access attempt";
    private Executor executor = Executors.newSingleThreadExecutor();
    private UnparseableMessageHandler unparseableMessageHandler = new DefaultUnparseableMessageHandler();
    private Map<HostPort, Channel> sessions = new ConcurrentHashMap<HostPort, Channel>();
    private StampyHandlerHelper helper = new StampyHandlerHelper();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        final HostPort hostPort = this.createHostPort(ctx);
        log.debug("Received raw message {} from {}", e.getMessage(), (Object)hostPort);
        this.helper.resetHeartbeat(hostPort);
        if (!this.helper.isValidObject(e.getMessage())) {
            log.error("Object {} is not a valid STOMP message, closing connection {}", e.getMessage(), (Object)hostPort);
            this.illegalAccess(ctx);
            return;
        }
        final String msg = (String)e.getMessage();
        if (this.helper.isHeartbeat(msg)) {
            log.trace("Received heartbeat");
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                StampyNettyChannelHandler.this.asyncProcessing(hostPort, msg);
            }
        };
        this.getExecutor().execute(runnable);
    }

    protected HostPort createHostPort(ChannelHandlerContext ctx) {
        return new HostPort((InetSocketAddress)ctx.getChannel().getRemoteAddress());
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        HostPort hostPort = this.createHostPort(ctx);
        this.sessions.put(hostPort, ctx.getChannel());
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        HostPort hostPort = this.createHostPort(ctx);
        this.sessions.remove(hostPort);
        ctx.sendUpstream((ChannelEvent)e);
    }

    public Set<HostPort> getConnectedHostPorts() {
        return Collections.unmodifiableSet(this.sessions.keySet());
    }

    public boolean isConnected(HostPort hostPort) {
        return this.sessions.containsKey(hostPort);
    }

    public void broadcastMessage(String message) {
        for (Channel channel : this.sessions.values()) {
            this.sendMessage(message, null, channel);
        }
    }

    public void sendMessage(String message, HostPort hostPort) {
        this.sendMessage(message, hostPort, this.sessions.get(hostPort));
    }

    private synchronized void sendMessage(String message, HostPort hostPort, Channel channel) {
        if (channel == null || !channel.isConnected()) {
            log.error("Channel is not connected, cannot send message {}", (Object)message);
            return;
        }
        if (hostPort == null) {
            hostPort = new HostPort((InetSocketAddress)channel.getRemoteAddress());
        }
        this.helper.resetHeartbeat(hostPort);
        channel.write((Object)message);
    }

    public void close(HostPort hostPort) {
        if (!this.isConnected(hostPort)) {
            log.warn("{} is already closed");
            return;
        }
        Channel channel = this.sessions.get(hostPort);
        ChannelFuture cf = channel.close();
        cf.awaitUninterruptibly();
        log.info("Session for {} has been closed", (Object)hostPort);
    }

    protected void asyncProcessing(HostPort hostPort, String msg) {
        StampyMessage sm = null;
        try {
            sm = this.getParser().parseMessage(msg);
            this.getGateway().notifyMessageListeners(sm, hostPort);
        }
        catch (UnparseableException e) {
            this.helper.handleUnparseableMessage(hostPort, msg, e);
        }
        catch (MessageListenerHaltException e) {
        }
        catch (Exception e) {
            this.helper.handleUnexpectedError(hostPort, msg, sm, e);
        }
    }

    protected void illegalAccess(ChannelHandlerContext ctx) {
        ChannelFuture cf = ctx.getChannel().write((Object)ILLEGAL_ACCESS_ATTEMPT);
        cf.awaitUninterruptibly();
        cf = ctx.getChannel().close();
        cf.awaitUninterruptibly();
    }

    public StompMessageParser getParser() {
        return this.parser;
    }

    public void setParser(StompMessageParser parser) {
        this.parser = parser;
        this.helper.setParser(parser);
    }

    public StampyHeartbeatContainer getHeartbeatContainer() {
        return this.heartbeatContainer;
    }

    public void setHeartbeatContainer(StampyHeartbeatContainer heartbeatContainer) {
        this.heartbeatContainer = heartbeatContainer;
        this.helper.setHeartbeatContainer(heartbeatContainer);
    }

    public AbstractStampyMessageGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(AbstractStampyMessageGateway gateway) {
        this.gateway = gateway;
        this.helper.setGateway(gateway);
    }

    public UnparseableMessageHandler getUnparseableMessageHandler() {
        return this.unparseableMessageHandler;
    }

    public void setUnparseableMessageHandler(UnparseableMessageHandler unparseableMessageHandler) {
        this.unparseableMessageHandler = unparseableMessageHandler;
        this.helper.setUnparseableMessageHandler(unparseableMessageHandler);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        HostPort hostPort = this.createHostPort(ctx);
        log.error("Unexpected Netty exception for " + hostPort, e.getCause());
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

