/*
 * Decompiled with CFR 0.152.
 */
package asia.stampy.common.netty;

import asia.stampy.common.StampyLibrary;
import asia.stampy.common.gateway.AbstractStampyMessageGateway;
import asia.stampy.common.gateway.HostPort;
import asia.stampy.common.message.interceptor.InterceptException;
import asia.stampy.common.netty.StampyNettyChannelHandler;
import asia.stampy.common.netty.StompBasedFrameDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StampyLibrary(libraryName="stampy-NETTY-client-server-RI")
public abstract class AbstractStampyNettyMessageGateway
extends AbstractStampyMessageGateway {
    public static Charset CHARSET = Charset.forName("UTF-8");
    private StampyNettyChannelHandler handler;
    private List<ChannelHandler> handlers = new ArrayList<ChannelHandler>();

    protected void initializeChannel(Bootstrap bootstrap) {
        ChannelPipelineFactory factory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
                AbstractStampyNettyMessageGateway.this.setupChannelPipeline((ChannelPipeline)pipeline, AbstractStampyNettyMessageGateway.this.getMaxMessageSize());
                return pipeline;
            }
        };
        bootstrap.setPipelineFactory(factory);
    }

    public void broadcastMessage(String stompMessage) throws InterceptException {
        this.getHandler().broadcastMessage(stompMessage);
    }

    public void sendMessage(String stompMessage, HostPort hostPort) throws InterceptException {
        this.getHandler().sendMessage(stompMessage, hostPort);
    }

    public boolean isConnected(HostPort hostPort) {
        return this.getHandler().isConnected(hostPort);
    }

    public Set<HostPort> getConnectedHostPorts() {
        return this.getHandler().getConnectedHostPorts();
    }

    public StampyNettyChannelHandler getHandler() {
        return this.handler;
    }

    public void setHandler(StampyNettyChannelHandler channelHandler) {
        this.handler = channelHandler;
    }

    public void addHandler(ChannelHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(ChannelHandler handler) {
        this.handlers.remove(handler);
    }

    protected void setupChannelPipeline(ChannelPipeline pipeline, int maxLength) {
        this.addHandlers(pipeline);
        StringEncoder encoder = new StringEncoder(CHARSET);
        StringDecoder decoder = new StringDecoder(CHARSET);
        StompBasedFrameDecoder stomp = new StompBasedFrameDecoder(maxLength);
        pipeline.addLast("stompDecoder", (ChannelHandler)stomp);
        pipeline.addLast("stringDecoder", (ChannelHandler)decoder);
        pipeline.addLast("stringEncoder", (ChannelHandler)encoder);
        pipeline.addLast("stampyChannelHandler", (ChannelHandler)this.getHandler());
    }

    private void addHandlers(ChannelPipeline pipeline) {
        for (ChannelHandler handler : this.handlers) {
            pipeline.addLast(handler.toString(), handler);
        }
    }
}

