/*
 * Decompiled with CFR 0.152.
 */
package asia.ivity.android.tiledscrollview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import asia.ivity.android.tiledscrollview.ConfigurationSet;
import asia.ivity.android.tiledscrollview.OnZoomLevelChangedListener;
import asia.ivity.android.tiledscrollview.R;
import asia.ivity.android.tiledscrollview.TiledScrollViewWorker;

public class TiledScrollView
extends FrameLayout {
    private TiledScrollViewWorker mScrollView;
    private ImageButton mBtnZoomDown;
    private ImageButton mBtnZoomUp;
    private boolean mZoomButtonsEnabled = true;

    public TiledScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public TiledScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        LayoutInflater lf = LayoutInflater.from((Context)this.getContext());
        this.mScrollView = new TiledScrollViewWorker(this.getContext(), attrs);
        this.mScrollView.setOnZoomLevelChangedListener(new OnZoomLevelChangedListener(){

            @Override
            public void onZoomLevelChanged(ZoomLevel newLevel) {
                TiledScrollView.this.updateZoomButtons();
            }
        });
        this.addView((View)this.mScrollView);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.asia_ivity_android_tiledscrollview_TiledScrollView);
        this.mZoomButtonsEnabled = a.getBoolean(5, true);
        if (this.mZoomButtonsEnabled) {
            View btns = lf.inflate(2130903040, (ViewGroup)this, false);
            this.mBtnZoomDown = (ImageButton)btns.findViewById(2131099648);
            this.mBtnZoomUp = (ImageButton)btns.findViewById(2131099649);
            this.mBtnZoomDown.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TiledScrollView.this.mScrollView.zoomDown();
                }
            });
            this.mBtnZoomUp.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    TiledScrollView.this.mScrollView.zoomUp();
                }
            });
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = 81;
            this.addView(btns, (ViewGroup.LayoutParams)params);
            this.updateZoomButtons();
        }
    }

    public void addConfigurationSet(ZoomLevel level, ConfigurationSet set) {
        this.mScrollView.addConfigurationSet(level, set);
        this.updateZoomButtons();
    }

    private void updateZoomButtons() {
        if (this.mZoomButtonsEnabled) {
            if (!this.mScrollView.canZoomFurtherDown() && !this.mScrollView.canZoomFurtherUp()) {
                this.mBtnZoomDown.setVisibility(8);
                this.mBtnZoomUp.setVisibility(8);
            } else {
                this.mBtnZoomDown.setVisibility(0);
                this.mBtnZoomUp.setVisibility(0);
                this.mBtnZoomDown.setEnabled(this.mScrollView.canZoomFurtherDown());
                this.mBtnZoomUp.setEnabled(this.mScrollView.canZoomFurtherUp());
            }
        }
    }

    public void cleanupOldTiles() {
        this.mScrollView.cleanupOldTiles();
    }

    public void addMarker(int x, int y, String description) {
        this.mScrollView.addMarker(x, y, description);
    }

    public void setMarkerOnClickListener(View.OnClickListener listener) {
        this.mScrollView.setMarkerOnClickListener(listener);
    }

    public static enum ZoomLevel {
        DEFAULT,
        LEVEL_1,
        LEVEL_2;


        public ZoomLevel upLevel() {
            switch (this) {
                case DEFAULT: {
                    return LEVEL_1;
                }
                case LEVEL_1: {
                    return LEVEL_2;
                }
                case LEVEL_2: {
                    return LEVEL_2;
                }
            }
            return this;
        }

        public ZoomLevel downLevel() {
            switch (this) {
                case DEFAULT: {
                    return DEFAULT;
                }
                case LEVEL_1: {
                    return DEFAULT;
                }
                case LEVEL_2: {
                    return LEVEL_1;
                }
            }
            return this;
        }
    }
}

