/*
 * Decompiled with CFR 0.152.
 */
package asia.ivity.android.tiledscrollview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import asia.ivity.android.tiledscrollview.ConfigurationSet;
import asia.ivity.android.tiledscrollview.OnZoomLevelChangedListener;
import asia.ivity.android.tiledscrollview.R;
import asia.ivity.android.tiledscrollview.Tile;
import asia.ivity.android.tiledscrollview.TiledScrollView;
import asia.ivity.android.tiledscrollview.TwoDScrollView;
import asia.ivity.android.tiledscrollview.ZoomingFrameLayout;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class TiledScrollViewWorker
extends TwoDScrollView {
    static final int UPDATE_TILES = 123;
    static final int FILL_TILES_DELAY = 200;
    private Animation mFadeInAnimation;
    private OnZoomLevelChangedListener onZoomLevelChangedListener = null;
    private List<Marker> mMarkers = new ArrayList<Marker>();
    private View.OnClickListener mOnMarkerOnClickListener;
    private List<ImageView> mMarkerViews = new ArrayList<ImageView>();
    TiledScrollView.ZoomLevel mCurrentZoomLevel = TiledScrollView.ZoomLevel.DEFAULT;
    Map<TiledScrollView.ZoomLevel, ConfigurationSet> mConfigurationSets = new HashMap<TiledScrollView.ZoomLevel, ConfigurationSet>();
    private FrameLayout mContainer;
    private static final String TAG = TiledScrollViewWorker.class.getSimpleName();
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 123: {
                    try {
                        TiledScrollViewWorker.this.fillTiles();
                        break;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    };
    private Map<Tile, SoftReference<ImageView>> tiles = new ConcurrentHashMap<Tile, SoftReference<ImageView>>();
    private boolean inZoomMode = false;
    private boolean ignoreLastFinger = false;
    private float mOrigSeparation;
    private static final float ZOOMJUMP = 75.0f;

    public void setMarkerOnClickListener(View.OnClickListener mOnMarkerOnClickListener) {
        this.mOnMarkerOnClickListener = mOnMarkerOnClickListener;
    }

    public void setOnZoomLevelChangedListener(OnZoomLevelChangedListener listener) {
        this.onZoomLevelChangedListener = listener;
    }

    public void addMarker(int x, int y, String description) {
        this.mMarkers.add(new Marker(x, y, description));
    }

    private ConfigurationSet getCurrentConfigurationSet() {
        if (this.mConfigurationSets.containsKey((Object)this.mCurrentZoomLevel)) {
            return this.mConfigurationSets.get((Object)this.mCurrentZoomLevel);
        }
        return this.mConfigurationSets.get((Object)TiledScrollView.ZoomLevel.DEFAULT);
    }

    public void addConfigurationSet(TiledScrollView.ZoomLevel level, ConfigurationSet set) {
        this.mConfigurationSets.put(level, set);
    }

    public TiledScrollViewWorker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.readAttributes(attrs);
        this.init();
    }

    public TiledScrollViewWorker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.readAttributes(attrs);
        this.init();
    }

    private void readAttributes(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.asia_ivity_android_tiledscrollview_TiledScrollView);
        int imageWidth = a.getInt(3, -1);
        int imageHeight = a.getInt(4, -1);
        int tileWidth = a.getInt(1, -1);
        int tileHeight = a.getInt(2, -1);
        String filePattern = a.getString(0);
        if (imageWidth == -1 || imageHeight == -1 || tileWidth == -1 || tileHeight == -1 || filePattern == null) {
            throw new IllegalArgumentException("Please set all attributes correctly!");
        }
        this.mConfigurationSets.put(TiledScrollView.ZoomLevel.DEFAULT, new ConfigurationSet(filePattern, tileWidth, tileHeight, imageWidth, imageHeight));
    }

    private void init() {
        this.mFadeInAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)2130968576);
        this.mContainer = new ZoomingFrameLayout(this.getContext());
        ConfigurationSet set = this.getCurrentConfigurationSet();
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(set.getImageWidth(), set.getImageHeight());
        this.mContainer.setMinimumWidth(set.getImageWidth());
        this.mContainer.setMinimumHeight(set.getImageHeight());
        this.mContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)lp);
        this.mContainer.setBackgroundColor(17170443);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        try {
            this.fillTiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        Message msg = Message.obtain();
        msg.what = 123;
        if (this.mHandler.hasMessages(123)) {
            this.mHandler.removeMessages(123);
        }
        this.mHandler.sendMessageDelayed(msg, 200L);
    }

    private void fillTiles() throws IOException {
        Rect visible = new Rect();
        this.mContainer.getDrawingRect(visible);
        for (ImageView iv : this.mMarkerViews) {
            this.mContainer.removeView((View)iv);
        }
        final int left = visible.left + this.getScrollX();
        final int top = visible.top + this.getScrollY();
        final ConfigurationSet set = this.getCurrentConfigurationSet();
        final int width = this.getMeasuredWidth() + this.getScrollX() + set.getTileWidth();
        final int height = this.getMeasuredHeight() + this.getScrollY() + set.getTileHeight();
        new AsyncTask<Void, ImageView, Void>(){

            protected Void doInBackground(Void ... params) {
                for (int y = top; y < height; y += set.getTileHeight()) {
                    int tileY = new Double(Math.ceil(y / set.getTileHeight())).intValue();
                    for (int x = left; x < width; x += set.getTileWidth()) {
                        int tileX = new Double(Math.ceil(x / set.getTileWidth())).intValue();
                        Tile tile = new Tile(tileX, tileY);
                        if (TiledScrollViewWorker.this.tiles.containsKey(tile) && ((SoftReference)TiledScrollViewWorker.this.tiles.get(tile)).get() != null) continue;
                        try {
                            this.publishProgress(new ImageView[]{TiledScrollViewWorker.this.getNewTile(tile)});
                            continue;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }

            protected void onProgressUpdate(ImageView ... ivs) {
                for (ImageView iv : ivs) {
                    if (iv == null) continue;
                    Tile tile = (Tile)iv.getTag();
                    iv.setId(new Random().nextInt());
                    FrameLayout.LayoutParams lp2 = new FrameLayout.LayoutParams(-2, -2);
                    lp2.leftMargin = tile.x * set.getTileWidth();
                    lp2.topMargin = tile.y * set.getTileHeight();
                    lp2.gravity = 51;
                    iv.setLayoutParams((ViewGroup.LayoutParams)lp2);
                    TiledScrollViewWorker.this.mContainer.addView((View)iv, (ViewGroup.LayoutParams)lp2);
                    TiledScrollViewWorker.this.tiles.put(tile, new SoftReference<ImageView>(iv));
                }
            }

            protected void onPostExecute(Void aVoid) {
                if (TiledScrollViewWorker.this.mMarkerViews.isEmpty()) {
                    Bitmap b = BitmapFactory.decodeResource((Resources)TiledScrollViewWorker.this.getContext().getResources(), (int)2130837516);
                    for (Marker m : TiledScrollViewWorker.this.mMarkers) {
                        Log.d((String)TAG, (String)("Adding: " + m));
                        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2);
                        lp.leftMargin = m.getX() - b.getWidth() / 2;
                        lp.topMargin = m.getY() - b.getHeight() / 2;
                        lp.gravity = 51;
                        ImageView iv = new ImageView(TiledScrollViewWorker.this.getContext());
                        iv.setTag((Object)m);
                        iv.setImageResource(2130837516);
                        iv.setLayoutParams((ViewGroup.LayoutParams)lp);
                        if (TiledScrollViewWorker.this.mOnMarkerOnClickListener != null) {
                            iv.setOnClickListener(TiledScrollViewWorker.this.mOnMarkerOnClickListener);
                        }
                        TiledScrollViewWorker.this.mMarkerViews.add(iv);
                    }
                }
                for (ImageView iv : TiledScrollViewWorker.this.mMarkerViews) {
                    TiledScrollViewWorker.this.mContainer.addView((View)iv, iv.getLayoutParams());
                }
            }
        }.execute((Object[])null);
    }

    private ImageView getNewTile(Tile tile) throws IOException {
        ImageView iv = new ImageView(this.getContext());
        ConfigurationSet set = this.getCurrentConfigurationSet();
        String path = set.getFilePattern().replace("%col%", new Integer(tile.y).toString()).replace("%row%", new Integer(tile.x).toString());
        try {
            InputStream is = this.getResources().getAssets().open(path);
            Bitmap bm = BitmapFactory.decodeStream((InputStream)is);
            iv.setImageBitmap(bm);
            iv.setMinimumWidth(bm.getWidth());
            iv.setMinimumHeight(bm.getHeight());
            iv.setMaxWidth(bm.getWidth());
            iv.setMaxHeight(bm.getHeight());
            is.close();
        }
        catch (IOException e) {
            throw new IOException("Cannot open asset at:" + path);
        }
        iv.setTag((Object)tile);
        return iv;
    }

    public void cleanupOldTiles() {
        Log.d((String)TAG, (String)"Cleanup old tiles");
        Rect actualRect = new Rect(this.getScrollX(), this.getScrollY(), this.getWidth() + this.getScrollX(), this.getHeight() + this.getScrollY());
        for (Tile tile : this.tiles.keySet()) {
            ImageView v = this.tiles.get(tile).get();
            Rect r = new Rect();
            v.getHitRect(r);
            if (Rect.intersects((Rect)actualRect, (Rect)r)) continue;
            this.mContainer.removeView((View)v);
            this.tiles.remove(tile);
        }
    }

    @Override
    public boolean onTouchEvent(MotionEvent e) {
        int action = e.getAction() & 0xFF;
        this.inZoomMode = e.getPointerCount() == 2;
        if (this.inZoomMode) {
            switch (action) {
                case 5: {
                    this.mOrigSeparation = this.calculateSeparation(e);
                    break;
                }
                case 6: {
                    this.ignoreLastFinger = true;
                    break;
                }
                case 2: {
                    float newSeparation = this.calculateSeparation(e);
                    TiledScrollView.ZoomLevel next = this.mCurrentZoomLevel;
                    if (newSeparation - this.mOrigSeparation > 75.0f) {
                        Log.d((String)TAG, (String)"Zoom In!");
                        next = this.mCurrentZoomLevel.upLevel();
                        this.mOrigSeparation = newSeparation;
                    } else if (this.mOrigSeparation - newSeparation > 75.0f) {
                        Log.d((String)TAG, (String)"Zoom Out!");
                        next = this.mCurrentZoomLevel.downLevel();
                        this.mOrigSeparation = newSeparation;
                    }
                    this.changeZoomLevel(next);
                }
            }
            return true;
        }
        if (this.ignoreLastFinger) {
            if (action == 1) {
                this.ignoreLastFinger = false;
            }
            return true;
        }
        return super.onTouchEvent(e);
    }

    private void changeZoomLevel(TiledScrollView.ZoomLevel next) {
        if (next != this.mCurrentZoomLevel && this.mConfigurationSets.containsKey((Object)next)) {
            this.mCurrentZoomLevel = next;
            Log.d((String)TAG, (String)("new zoom level: " + (Object)((Object)this.mCurrentZoomLevel)));
            this.tiles.clear();
            double x = this.getScrollX();
            double y = this.getScrollY();
            double w = this.mContainer.getWidth();
            double h = this.mContainer.getHeight();
            this.removeAllViews();
            this.init();
            double newW = this.getCurrentConfigurationSet().getImageWidth();
            double newH = this.getCurrentConfigurationSet().getImageHeight();
            Log.d((String)TAG, (String)("1: " + x + ", " + y));
            Log.d((String)TAG, (String)("2: " + w + ", " + h));
            Log.d((String)TAG, (String)("3: " + newW + ", " + newH));
            Log.d((String)TAG, (String)("new sX: " + (double)((int)x) / w * newW));
            Log.d((String)TAG, (String)("new sY: " + (double)((int)y) / h * newH));
            this.smoothScrollTo((int)(x / w * newW), (int)(y / h * newH));
            if (this.onZoomLevelChangedListener != null) {
                this.onZoomLevelChangedListener.onZoomLevelChanged(this.mCurrentZoomLevel);
            }
            try {
                this.fillTiles();
            }
            catch (IOException e1) {
                Log.e((String)TAG, (String)"Problem loading new tiles.", (Throwable)e1);
            }
        }
    }

    private float calculateSeparation(MotionEvent e) {
        float x = e.getX(0) - e.getX(1);
        float y = e.getY(0) - e.getY(1);
        return FloatMath.sqrt((float)(x * x + y * y));
    }

    public boolean canZoomFurtherDown() {
        return this.mCurrentZoomLevel.downLevel() != this.mCurrentZoomLevel && this.mConfigurationSets.containsKey((Object)this.mCurrentZoomLevel.downLevel());
    }

    public void zoomDown() {
        this.changeZoomLevel(this.mCurrentZoomLevel.downLevel());
    }

    public boolean canZoomFurtherUp() {
        return this.mCurrentZoomLevel.upLevel() != this.mCurrentZoomLevel && this.mConfigurationSets.containsKey((Object)this.mCurrentZoomLevel.upLevel());
    }

    public void zoomUp() {
        this.changeZoomLevel(this.mCurrentZoomLevel.upLevel());
    }

    public class Marker {
        private int x;
        private int y;
        private String description;

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public String getDescription() {
            return this.description;
        }

        public Marker(int x, int y, String description) {
            this.x = x;
            this.y = y;
            this.description = description;
        }

        public String toString() {
            return "Marker{x=" + this.x + ", y=" + this.y + ", description='" + this.description + '\'' + '}';
        }
    }
}

