/*
 * Decompiled with CFR 0.152.
 */
package asia.ivity.android.marqueeview;

import android.content.Context;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

public class MarqueeView
extends LinearLayout {
    private TextView mTextField;
    private ScrollView mScrollView;
    private static final int TEXTVIEW_VIRTUAL_WIDTH = 2000;
    private Animation mMoveTextOut = null;
    private Animation mMoveTextIn = null;
    private Paint mPaint;
    private boolean mMarqueeNeeded = false;
    private static final String TAG = MarqueeView.class.getSimpleName();
    private float mTextDifference;
    private static final int MS_PER_PX = 60;
    private static final int PAUSE_BETWEEN_ANIMATIONS = 2000;
    private int mSpeed = 60;
    private int mPauseBetweenAnimations = 2000;
    private Interpolator mInterpolator = new LinearInterpolator();
    private boolean mCancelled = false;
    private int mWidth;
    private Runnable mAnimationStartRunnable;
    private static final boolean DEBUG = true;

    public void setSpeed(int speed) {
        this.mSpeed = speed;
    }

    public void setPauseBetweenAnimations(int pause) {
        this.mPauseBetweenAnimations = pause;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public MarqueeView(Context context) {
        super(context);
        this.init(context);
    }

    public MarqueeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.getChildCount() == 0 || this.getChildCount() > 1) {
            throw new RuntimeException("MarqueeView must have exactly one child element.");
        }
        View v = this.getChildAt(0);
        if (!(v instanceof TextView)) {
            throw new RuntimeException("The child view of this MarqueeView must be a TextView instance.");
        }
        if (changed) {
            this.initView(this.getContext());
        }
        this.mWidth = this.getMeasuredWidth();
        this.prepare();
        this.setupTextMarquee();
    }

    public void setOnClickListener(View.OnClickListener l) {
        super.setOnClickListener(l);
        this.mTextField.setOnClickListener(l);
    }

    public void startMarquee() {
        this.prepareTextFields();
        if (this.mMarqueeNeeded) {
            this.startTextFieldAnimation();
        }
        this.mCancelled = false;
    }

    private void startTextFieldAnimation() {
        this.mAnimationStartRunnable = new Runnable(){

            @Override
            public void run() {
                MarqueeView.this.mTextField.startAnimation(MarqueeView.this.mMoveTextOut);
            }
        };
        this.postDelayed(this.mAnimationStartRunnable, this.mPauseBetweenAnimations);
    }

    public void reset() {
        Log.d((String)TAG, (String)"Resetting animation.");
        this.mCancelled = true;
        if (this.mAnimationStartRunnable != null) {
            this.removeCallbacks(this.mAnimationStartRunnable);
        }
        this.mTextField.clearAnimation();
        this.prepareTextFields();
        this.mMoveTextOut.reset();
        this.mMoveTextIn.reset();
        this.mScrollView.removeView((View)this.mTextField);
        this.mScrollView.addView((View)this.mTextField);
        this.mTextField.setEllipsize(TextUtils.TruncateAt.END);
        this.invalidate();
    }

    private void prepareTextFields() {
        this.mTextField.setEllipsize(TextUtils.TruncateAt.END);
        this.cutTextView(this.mTextField);
    }

    private void setupTextMarquee() {
        int duration = (int)(this.mTextDifference * (float)this.mSpeed);
        this.mMoveTextOut = new TranslateAnimation(0.0f, -this.mTextDifference, 0.0f, 0.0f);
        this.mMoveTextOut.setDuration((long)duration);
        this.mInterpolator = new LinearInterpolator();
        this.mMoveTextOut.setInterpolator(this.mInterpolator);
        this.mMoveTextOut.setFillAfter(true);
        this.mMoveTextIn = new TranslateAnimation(-this.mTextDifference, 0.0f, 0.0f, 0.0f);
        this.mMoveTextIn.setDuration((long)duration);
        this.mMoveTextIn.setStartOffset((long)this.mPauseBetweenAnimations);
        this.mMoveTextIn.setInterpolator(this.mInterpolator);
        this.mMoveTextIn.setFillAfter(true);
        this.mMoveTextOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                MarqueeView.this.expandTextView(MarqueeView.this.mTextField);
            }

            public void onAnimationEnd(Animation animation) {
                if (MarqueeView.this.mCancelled) {
                    return;
                }
                MarqueeView.this.mTextField.startAnimation(MarqueeView.this.mMoveTextIn);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mMoveTextIn.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                MarqueeView.this.cutTextView(MarqueeView.this.mTextField);
                if (MarqueeView.this.mCancelled) {
                    return;
                }
                MarqueeView.this.startTextFieldAnimation();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
    }

    private void prepare() {
        float diff1 = this.mTextDifference;
        this.mPaint.setTextSize(this.mTextField.getTextSize());
        this.mPaint.setTypeface(this.mTextField.getTypeface());
        float mTextTextWidth = this.mPaint.measureText(this.mTextField.getText().toString());
        this.mMarqueeNeeded = mTextTextWidth > (float)this.mWidth;
        this.mTextDifference = Math.abs(mTextTextWidth - (float)this.mWidth) + 5.0f;
        Log.d((String)TAG, (String)("mTextTextWidth: " + mTextTextWidth));
        Log.d((String)TAG, (String)("getMeasuredWidth: " + this.mWidth));
        Log.d((String)TAG, (String)("mMarqueeNeeded: " + this.mMarqueeNeeded));
        Log.d((String)TAG, (String)("mTextDifference: " + this.mTextDifference));
        if (diff1 != this.mTextDifference) {
            this.setupTextMarquee();
        }
    }

    private void initView(Context context) {
        LinearLayout.LayoutParams sv1lp = new LinearLayout.LayoutParams(-1, -2);
        sv1lp.gravity = 1;
        this.mScrollView = new ScrollView(context);
        this.mTextField = (TextView)this.getChildAt(0);
        this.removeView((View)this.mTextField);
        Log.d((String)TAG, (String)("Count: " + this.getChildCount()));
        this.mScrollView.addView((View)this.mTextField, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(2000, -2));
        this.addView((View)this.mScrollView, (ViewGroup.LayoutParams)sv1lp);
    }

    private void expandTextView(TextView textView) {
        ViewGroup.LayoutParams lp = textView.getLayoutParams();
        lp.width = 2000;
        textView.setLayoutParams(lp);
    }

    private void cutTextView(TextView textView) {
        if (textView.getWidth() != this.mWidth) {
            ViewGroup.LayoutParams lp = textView.getLayoutParams();
            lp.width = this.mWidth;
            textView.setLayoutParams(lp);
        }
    }
}

