/*
 * Decompiled with CFR 0.152.
 */
package as.leap.vertx.rpc.impl;

import as.leap.vertx.rpc.RPCServer;
import as.leap.vertx.rpc.VertxRPCException;
import as.leap.vertx.rpc.impl.RPCBase;
import as.leap.vertx.rpc.impl.RPCRequest;
import as.leap.vertx.rpc.impl.RPCResponse;
import as.leap.vertx.rpc.impl.RPCServerOptions;
import as.leap.vertx.rpc.impl.SharedWrapper;
import as.leap.vertx.rpc.impl.WrapperType;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import rx.Observable;

public class VertxRPCServer
extends RPCBase
implements RPCServer {
    private static final Logger log = LoggerFactory.getLogger(VertxRPCServer.class);
    private final LocalMap<String, SharedWrapper> serviceMapping;
    private final MessageConsumer<byte[]> consumer;
    private RPCServerOptions options;
    private Vertx vertx;

    public VertxRPCServer(RPCServerOptions options) {
        super(options.getWireProtocol());
        this.vertx = options.getVertx();
        this.checkBusAddress(options.getBusAddress());
        this.options = options;
        if (options.getServiceMapping().size() == 0) {
            throw new VertxRPCException("please add service implementation to RPCServerOptions.");
        }
        this.serviceMapping = options.getServiceMapping();
        this.consumer = options.getVertx().eventBus().consumer(options.getBusAddress());
        this.consumer.setMaxBufferedMessages(options.getMaxBufferedMessages());
        this.registryService();
    }

    private void registryService() {
        this.consumer.handler(message -> {
            try {
                RPCRequest request = this.asObject((byte[])message.body(), RPCRequest.class);
                this.call(request, (Message<byte[]>)message);
            }
            catch (Exception e) {
                this.replyFail(e, (Message<byte[]>)message);
            }
        });
    }

    private void call(RPCRequest request, Message<byte[]> message) {
        try {
            Object service = ((SharedWrapper)this.serviceMapping.get((Object)request.getServiceName())).getValue();
            Class[] argClasses = new Class[]{};
            Object[] args = new Object[]{};
            if (request.getArgs() != null && request.getArgs().size() > 0) {
                List<Object> argList = request.getArgs();
                int argCount = argList.size() >>> 1;
                args = new Object[argCount];
                argClasses = new Class[argCount];
                for (int i = 0; i < argList.size(); i += 2) {
                    Class<?> argClass;
                    int index = i >>> 1;
                    String argClassName = (String)argList.get(i);
                    byte[] argBytes = (byte[])argList.get(i + 1);
                    Object arg = this.asObject(argBytes, argClass = Class.forName(argClassName));
                    if (arg instanceof WrapperType) {
                        argClasses[index] = ((WrapperType)arg).getClazz();
                        args[index] = ((WrapperType)arg).getValue();
                        continue;
                    }
                    argClasses[index] = arg.getClass();
                    args[index] = arg;
                }
            }
            RPCBase.CallbackType callbackType = RPCBase.CallbackType.valueOf(message.headers().get("callbackType"));
            Object[] finalArgs = args;
            Class[] finalArgClasses = argClasses;
            this.vertx.executeBlocking(future -> {
                this.options.getRpcHook().beforeHandler(request.getServiceName(), request.getMethodName(), finalArgs, message.headers().remove("callbackType"));
                future.complete();
            }, false, event -> this.executeInvoke(callbackType, request, message, service, finalArgClasses, finalArgs));
        }
        catch (Exception e) {
            this.replyFail(e, message);
        }
    }

    private <T> void executeInvoke(RPCBase.CallbackType callbackType, RPCRequest request, Message<byte[]> message, Object service, Class<?>[] argClasses, Object[] args) {
        try {
            switch (callbackType) {
                case REACTIVE: {
                    Observable observable = (Observable)service.getClass().getMethod(request.getMethodName(), argClasses).invoke(service, args);
                    observable.subscribe(result -> this.replySuccess(result, message), ex -> this.replyFail((Throwable)ex, message));
                    break;
                }
                case ASYNC_HANDLER: {
                    argClasses = Arrays.copyOf(argClasses, argClasses.length + 1);
                    argClasses[argClasses.length - 1] = Handler.class;
                    args = Arrays.copyOf(args, args.length + 1);
                    args[args.length - 1] = event -> {
                        if (event.succeeded()) {
                            this.replySuccess(event.result(), message);
                        } else {
                            this.replyFail(event.cause(), message);
                        }
                    };
                    service.getClass().getMethod(request.getMethodName(), argClasses).invoke(service, args);
                    break;
                }
                case COMPLETABLE_FUTURE: {
                    CompletableFuture future = (CompletableFuture)service.getClass().getMethod(request.getMethodName(), argClasses).invoke(service, args);
                    future.whenComplete((result, ex) -> {
                        if (ex != null) {
                            this.replyFail((Throwable)ex, message);
                        } else {
                            this.replySuccess(result, message);
                        }
                    });
                    break;
                }
                case SYNC: {
                    Class[] finalArgClasses = argClasses;
                    Object[] finalArgs = args;
                    this.vertx.executeBlocking(event -> {
                        try {
                            Object result = service.getClass().getMethod(request.getMethodName(), finalArgClasses).invoke(service, finalArgs);
                            event.complete(result);
                        }
                        catch (ReflectiveOperationException e) {
                            if (e instanceof InvocationTargetException) {
                                event.fail(((InvocationTargetException)e).getTargetException());
                            }
                            event.fail((Throwable)e);
                        }
                    }, false, event -> {
                        if (event.succeeded()) {
                            this.replySuccess(event.result(), message);
                        } else {
                            this.replyFail(event.cause(), message);
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            this.replyFail(e, message);
        }
    }

    private <T> void replySuccess(T result, Message<byte[]> message) {
        this.vertx.executeBlocking(future -> {
            this.options.getRpcHook().afterHandler(result, message.headers());
            future.complete();
        }, false, event -> {
            byte[] resultBytes = new byte[]{};
            try {
                String resultClassName;
                if (Optional.ofNullable(result).isPresent()) {
                    Class<?> resultClass = result.getClass();
                    resultClassName = this.isWrapType(resultClass) ? WrapperType.class.getName() : resultClass.getName();
                    resultBytes = this.asBytes(result);
                } else {
                    resultClassName = WrapperType.class.getName();
                }
                RPCResponse response = new RPCResponse(resultClassName, resultBytes);
                byte[] responseBytes = this.asBytes(response);
                message.reply((Object)responseBytes);
            }
            catch (Exception e) {
                this.replyFail(e, message);
            }
        });
    }

    private void replyFail(Throwable ex, Message<byte[]> message) {
        this.vertx.executeBlocking(future -> {
            log.error((Object)ex.getMessage(), ex);
            this.options.getRpcHook().afterHandler(ex, message.headers());
            future.complete();
        }, false, event -> {
            Throwable realEx = ex.getCause() != null && !ex.getCause().equals(ex) ? ex.getCause() : ex;
            JsonObject exJson = new JsonObject().put("message", realEx.getMessage());
            exJson.put("exClass", ex.getClass().getName());
            Stream.of(realEx.getClass().getDeclaredFields()).forEach(field -> {
                field.setAccessible(true);
                try {
                    exJson.put(field.getName(), field.get(realEx));
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            });
            message.fail(500, exJson.encode());
        });
    }

    @Override
    public void shutdown(Handler<AsyncResult<Void>> handler) {
        if (Optional.ofNullable(handler).isPresent()) {
            this.consumer.unregister(handler);
        } else {
            this.consumer.unregister();
        }
    }
}

