/*
 * Decompiled with CFR 0.152.
 */
package as.leap.vertx.rpc.impl;

import as.leap.vertx.rpc.WireProtocol;
import as.leap.vertx.rpc.impl.WrapperType;
import io.protostuff.JsonIOUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

abstract class RPCBase {
    protected static final String CALLBACK_TYPE = "callbackType";
    private WireProtocol wireProtocol;

    public RPCBase(WireProtocol wireProtocol) {
        this.wireProtocol = wireProtocol;
    }

    void checkBusAddress(String address) {
        Objects.requireNonNull(address, "service's event bus address can not be null.");
    }

    boolean isWrapType(Class clazz) {
        return clazz.isPrimitive() || Collection.class.isAssignableFrom(clazz) || clazz.isArray() || Map.class.isAssignableFrom(clazz) || clazz.isEnum() || Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> byte[] toBytes(Schema<T> schema, T object) throws Exception {
        LinkedBuffer buffer = LinkedBuffer.allocate();
        byte[] bytes = new byte[]{};
        try {
            switch (this.wireProtocol) {
                case PROTOBUF: {
                    bytes = ProtobufIOUtil.toByteArray(object, schema, (LinkedBuffer)buffer);
                    return bytes;
                }
                case JSON: {
                    bytes = JsonIOUtil.toByteArray(object, schema, (boolean)false, (LinkedBuffer)buffer);
                    return bytes;
                }
            }
            return bytes;
        }
        finally {
            buffer.clear();
        }
    }

    <T> byte[] getWrapTypeBytes(Object object, Class<T> clazz) throws Exception {
        WrapperType<Object> wrapperType = new WrapperType<Object>(object, clazz);
        Schema schema = RuntimeSchema.getSchema(WrapperType.class);
        return this.toBytes(schema, wrapperType);
    }

    <T> byte[] asBytes(T object) throws Exception {
        return this.asBytes(object, object.getClass());
    }

    byte[] asBytes(Object object, Class clazz) throws Exception {
        if (this.isWrapType(clazz)) {
            return this.getWrapTypeBytes(object, clazz);
        }
        Schema schema = RuntimeSchema.getSchema((Class)clazz);
        return this.toBytes(schema, object);
    }

    <T> T asObject(byte[] bytes, Class<T> clazz) throws IOException {
        Schema schema = RuntimeSchema.getSchema(clazz);
        Object object = schema.newMessage();
        switch (this.wireProtocol) {
            case PROTOBUF: {
                ProtobufIOUtil.mergeFrom((byte[])bytes, (Object)object, (Schema)schema);
                break;
            }
            case JSON: {
                if (bytes.length == 0) {
                    object = null;
                    break;
                }
                JsonIOUtil.mergeFrom((byte[])bytes, (Object)object, (Schema)schema, (boolean)false);
            }
        }
        return (T)object;
    }

    protected static enum CallbackType {
        ASYNC_HANDLER,
        REACTIVE,
        COMPLETABLE_FUTURE,
        SYNC;

    }
}

