/*
 * Decompiled with CFR 0.152.
 */
package as.leap.las.sdk;

import as.leap.las.sdk.types.LASPointer;
import as.leap.las.sdk.types.TypesUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LASUpdate {
    private Map<String, Object> modifierOps = new LinkedHashMap<String, Object>();

    public LASUpdate() {
    }

    public LASUpdate(Map map) {
        this.modifierOps = TypesUtils.toMap(map);
    }

    public static LASUpdate getUpdate() {
        return new LASUpdate();
    }

    public static LASUpdate getUpdate(Map map) {
        return new LASUpdate(map);
    }

    public LASUpdate set(String key, Object value) {
        this.addMultiFieldOperation(key, value);
        return this;
    }

    public LASUpdate setBright(String key, Object value) {
        if (value instanceof Map) {
            for (Object childKey : ((Map)value).keySet()) {
                this.setBright(key + "." + childKey, ((Map)value).get(childKey));
            }
        } else {
            this.addMultiFieldOperation(key, value);
        }
        return this;
    }

    public LASUpdate setMany(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public LASUpdate unset(String key) {
        HashMap<String, String> del = new HashMap<String, String>();
        del.put("__op", "Delete");
        this.addMultiFieldOperation(key, del);
        return this;
    }

    public LASUpdate unsetMany(String ... keys) {
        for (String key : keys) {
            this.unset(key);
        }
        return this;
    }

    public LASUpdate unsetMany(List<String> keys) {
        for (String key : keys) {
            this.unset(key);
        }
        return this;
    }

    public LASUpdate removeRelation(String relationKey, LASPointer ... pointers) {
        return this.removeRelation(relationKey, Arrays.asList(pointers));
    }

    public LASUpdate removeRelation(String relationKey, List<LASPointer> pointers) {
        HashMap<String, Object> relation = new HashMap<String, Object>();
        relation.put("__op", "RemoveRelation");
        relation.put("objects", pointers);
        this.addMultiFieldOperation(relationKey, relation);
        return this;
    }

    public LASUpdate addRelation(String relationKey, LASPointer ... pointers) {
        return this.addRelation(relationKey, Arrays.asList(pointers));
    }

    public LASUpdate addRelation(String relationKey, List<LASPointer> pointers) {
        HashMap<String, Object> relation = new HashMap<String, Object>();
        relation.put("__op", "AddRelation");
        relation.put("objects", pointers);
        this.addMultiFieldOperation(relationKey, relation);
        return this;
    }

    public <T> LASUpdate arrayAdd(String arrayKey, T ... items) {
        return this.arrayAdd(arrayKey, Arrays.asList(items));
    }

    public <T> LASUpdate arrayAdd(String arrayKey, List items) {
        HashMap<String, Object> addUnique = new HashMap<String, Object>();
        addUnique.put("__op", "Add");
        addUnique.put("objects", items);
        this.addMultiFieldOperation(arrayKey, addUnique);
        return this;
    }

    public <T> LASUpdate arrayAddUnique(String arrayKey, T ... items) {
        return this.arrayAddUnique(arrayKey, Arrays.asList(items));
    }

    public <T> LASUpdate arrayAddUnique(String arrayKey, List items) {
        HashMap<String, Object> addUnique = new HashMap<String, Object>();
        addUnique.put("__op", "AddUnique");
        addUnique.put("objects", items);
        this.addMultiFieldOperation(arrayKey, addUnique);
        return this;
    }

    public <T> LASUpdate arrayRemove(String arrayKey, T ... items) {
        return this.arrayRemove(arrayKey, Arrays.asList(items));
    }

    public <T> LASUpdate arrayRemove(String arrayKey, List items) {
        HashMap<String, Object> addUnique = new HashMap<String, Object>();
        addUnique.put("__op", "Remove");
        addUnique.put("objects", items);
        this.addMultiFieldOperation(arrayKey, addUnique);
        return this;
    }

    public LASUpdate inc(String key, Number inc) {
        HashMap<String, Object> $inc = new HashMap<String, Object>();
        $inc.put("__op", "Increment");
        $inc.put("amount", inc);
        this.addMultiFieldOperation(key, $inc);
        return this;
    }

    public LASUpdate addToSet(String key, Object value) {
        this.addMultiFieldOperation(key, value);
        return this;
    }

    public Map update() {
        return this.modifierOps;
    }

    protected void addMultiFieldOperation(String key, Object value) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Key for update must not be null or blank.");
        }
        this.modifierOps.put(key, TypesUtils.toMap(value));
    }

    public static enum Position {
        LAST,
        FIRST;

    }
}

