/*
 * Decompiled with CFR 0.152.
 */
package as.leap.las.sdk;

import as.leap.las.sdk.types.LASGeoPoint;
import as.leap.las.sdk.types.LASPointer;
import as.leap.las.sdk.types.TypesUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LASQuery {
    protected String hint;
    protected Map queryDBObject = new HashMap();
    public static final int SORT_DESC = -1;
    public static final int SORT_ASC = 1;
    private Map<String, Integer> sort;
    private int skip = -1;
    private int limit = -1;
    private String includes;
    private List<String> keys;
    private boolean keysFlag;

    public LASQuery() {
    }

    public LASQuery(Map query) {
        this.queryDBObject = TypesUtils.toMap(query);
    }

    public LASQuery(Map query, List keys) {
        this.queryDBObject = TypesUtils.toMap(query);
        this.keys = keys;
    }

    public static LASQuery instance() {
        return new LASQuery();
    }

    public static LASQuery instance(Map query) {
        return new LASQuery(query);
    }

    public LASQuery not(String key, SingleElemMatcher elemMatcher) {
        this.addOperand(key, SunQueryType.NOT, elemMatcher.getElemMatherFiler());
        return this;
    }

    public <T> LASQuery equalTo(String key, T value) {
        this.addOperand(key, null, value);
        return this;
    }

    public <T> LASQuery notEqualTo(String key, T value) {
        this.addOperand(key, SunQueryType.NE, value);
        return this;
    }

    public LASQuery exists(String key) {
        this.addOperand(key, SunQueryType.EXIST, true);
        return this;
    }

    public LASQuery notExist(String key) {
        this.addOperand(key, SunQueryType.EXIST, false);
        return this;
    }

    public <T> LASQuery greaterThan(String key, T value) {
        this.addOperand(key, SunQueryType.GT, value);
        return this;
    }

    public <T> LASQuery greaterThanOrEqualTo(String key, T value) {
        this.addOperand(key, SunQueryType.GTE, value);
        return this;
    }

    public <T> LASQuery lessThan(String key, T value) {
        this.addOperand(key, SunQueryType.LT, value);
        return this;
    }

    public <T> LASQuery lessThanOrEqualTo(String key, T value) {
        this.addOperand(key, SunQueryType.LTE, value);
        return this;
    }

    public LASQuery matches(String key, String regex) {
        throw new UnsupportedOperationException("Unsupported. Please use regex(String key, String regex)");
    }

    public LASQuery regex(String key, String regex) {
        this.addOperand(key, SunQueryType.REGULAR, regex);
        return this;
    }

    public <T> LASQuery in(String key, T ... value) {
        if (value.length == 0) {
            throw new IllegalArgumentException("value must be empty.");
        }
        this.addOperand(key, SunQueryType.IN, this.translator(value));
        return this;
    }

    public <T> LASQuery in(String key, List<T> values) {
        if (values != null && values.size() == 0) {
            throw new IllegalArgumentException("value must be empty.");
        }
        this.addOperand(key, SunQueryType.IN, this.translator(values));
        return this;
    }

    public <T> LASQuery notIn(String key, T ... value) {
        if (value.length == 0) {
            throw new IllegalArgumentException("value must be empty.");
        }
        this.addOperand(key, SunQueryType.NIN, this.translator(value));
        return this;
    }

    public <T> LASQuery notIn(String key, List<T> values) {
        if (values != null && values.size() == 0) {
            throw new IllegalArgumentException("value must be empty.");
        }
        this.addOperand(key, SunQueryType.NIN, this.translator(values));
        return this;
    }

    public <T> LASQuery all(String key, T ... values) {
        this.arrayAll(key, values);
        return this;
    }

    public <T> LASQuery arrayAll(String key, T ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("value must be empty.");
        }
        this.addOperand(key, SunQueryType.ALL, this.translator(values));
        return this;
    }

    public <T> LASQuery arrayAll(String key, List<T> values) {
        if (values != null && values.size() == 0) {
            throw new IllegalArgumentException("value must be empty.");
        }
        this.addOperand(key, SunQueryType.ALL, this.translator(values));
        return this;
    }

    public LASQuery nearSpherePoint(String key, LASGeoPoint geoPoint, double maxDistance) {
        HashMap<String, Object> geoMap = new HashMap<String, Object>();
        geoMap.put("$nearSphere", geoPoint.toMap());
        geoMap.put("$maxDistance", maxDistance);
        this.addOperand(key, null, geoMap);
        return this;
    }

    public LASQuery withinPolygon(String key, List<LASGeoPoint> points) {
        throw new UnsupportedOperationException("");
    }

    public <T> LASQuery inQuery(String key, InQueryOperator queryOperator) {
        this.addOperand(key, SunQueryType.INQUERY, queryOperator.toMap());
        return this;
    }

    public <T> LASQuery notInQuery(String key, InQueryOperator queryOperator) {
        this.addOperand(key, SunQueryType.NINQUERY, queryOperator);
        return this;
    }

    public <T> LASQuery select(String key, SelectOperator selectOperator) {
        this.addOperand(key, SunQueryType.SELECT, selectOperator.toMap());
        return this;
    }

    public <T> LASQuery notSelect(String key, SelectOperator selectOperator) {
        this.addOperand(key, SunQueryType.DONTSELECT, selectOperator.toMap());
        return this;
    }

    public LASQuery or(LASQuery ... queries) {
        HashMap $or = new HashMap();
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(this.query());
        for (LASQuery query : queries) {
            if (query == null) continue;
            list.add(query.query());
        }
        $or.put(SunQueryType.OR.getOperator(), list);
        this.queryDBObject = $or;
        return this;
    }

    public LASQuery and(LASQuery ... queries) {
        HashMap $and = new HashMap();
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(this.query());
        for (LASQuery query : queries) {
            if (query == null) continue;
            list.add(query.query());
        }
        $and.put(SunQueryType.AND.getOperator(), list);
        this.queryDBObject = $and;
        return this;
    }

    public LASQuery addKey(String key) {
        if (this.keys == null) {
            this.keys = new ArrayList<String>();
            this.keysFlag = true;
        }
        if (!this.keysFlag) {
            throw new IllegalArgumentException("BadValue Projection cannot have a mix of inclusion and exclusion.");
        }
        this.keys.add(key);
        return this;
    }

    public LASQuery addKeys(List keys) {
        if (this.keys == null) {
            this.keys = new ArrayList<String>();
            this.keysFlag = true;
        }
        this.keys.addAll(keys);
        if (!this.keysFlag) {
            throw new IllegalArgumentException("BadValue Projection cannot have a mix of inclusion and exclusion.");
        }
        return this;
    }

    public LASQuery excludeKey(String key) {
        throw new UnsupportedOperationException("UnsupportedOperation.");
    }

    public LASQuery excludeKeys(String[] keys) {
        throw new UnsupportedOperationException("UnsupportedOperation.");
    }

    public void setKeys(List keys) {
        this.keys = keys;
    }

    public String keys() {
        if (this.keys != null) {
            StringBuilder sb = new StringBuilder();
            int size = this.keys.size();
            for (int i = 0; i < size; ++i) {
                if (size - 1 == i) {
                    sb.append(this.keys.get(i));
                    continue;
                }
                sb.append(this.keys.get(i) + ",");
            }
            return sb.toString();
        }
        return null;
    }

    public LASQuery setSort(Map<String, Integer> sort) {
        if (this.sort == null) {
            this.sort = new LinkedHashMap<String, Integer>();
        }
        for (String key : sort.keySet()) {
            this.sort.put(key, sort.get(key));
        }
        return this;
    }

    public LASQuery sort(int direction, String ... keys) {
        if (this.sort == null) {
            this.sort = new LinkedHashMap<String, Integer>();
        }
        for (String key : keys) {
            String trim = key.trim();
            this.sort.put(trim, direction);
        }
        return this;
    }

    public LASQuery relatedTo(String key, LASPointer pointer) {
        HashMap<String, Object> $relatedTo = new HashMap<String, Object>();
        $relatedTo.put("object", pointer.toMap());
        $relatedTo.put("key", key);
        this.equalTo("$relatedTo", $relatedTo);
        return this;
    }

    public String sort() {
        if (this.sort != null) {
            StringBuilder sb = new StringBuilder();
            int size = this.sort.size();
            int i = 0;
            for (Map.Entry<String, Integer> entry : this.sort.entrySet()) {
                ++i;
                String key = entry.getKey();
                if (entry.getValue() == -1) {
                    sb.append("-");
                }
                sb.append(key);
                if (i >= size) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    public int skip() {
        return this.skip;
    }

    public LASQuery setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public int limit() {
        return this.limit;
    }

    public LASQuery setIncludes(String includes) {
        this.includes = includes;
        return this;
    }

    public String includes() {
        return this.includes;
    }

    public LASQuery setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public Map query() {
        return this.queryDBObject;
    }

    public LASQuery from(Map map) {
        this.queryDBObject.putAll(map);
        return this;
    }

    private <T> List translator(T ... value) {
        ArrayList<Object> ts = new ArrayList<Object>();
        for (T t : value) {
            ts.add(TypesUtils.toMap(t));
        }
        return ts;
    }

    protected void addOperand(String key, SunQueryType queryType, Object value) {
        Map<String, Object> operand;
        value = TypesUtils.toMap(value);
        if (queryType == null) {
            this.queryDBObject.put(key, value);
            return;
        }
        Object storedValue = this.queryDBObject.get(key);
        if (storedValue == null || !(storedValue instanceof Map)) {
            operand = new HashMap();
            this.queryDBObject.put(key, operand);
        } else {
            operand = (Map)this.queryDBObject.get(key);
        }
        operand.put(queryType.operator, value);
    }

    public static class SingleElemMatcher {
        Map elemMatherFiler = new LinkedHashMap();

        public static SingleElemMatcher instance() {
            return new SingleElemMatcher();
        }

        public SingleElemMatcher $eq(Object filter) {
            this.elemMatherFiler.put("$eq", filter);
            return this;
        }

        public SingleElemMatcher $gt(Object filter) {
            this.elemMatherFiler.put("$gt", filter);
            return this;
        }

        public SingleElemMatcher $gte(Object filter) {
            this.elemMatherFiler.put("$gte", filter);
            return this;
        }

        public SingleElemMatcher $lt(Object filter) {
            this.elemMatherFiler.put("$lt", filter);
            return this;
        }

        public SingleElemMatcher $lte(Object filter) {
            this.elemMatherFiler.put("$lte", filter);
            return this;
        }

        public SingleElemMatcher $size(int size) {
            this.elemMatherFiler.put("$size", size);
            return this;
        }

        public SingleElemMatcher $ne(Object filter) {
            this.elemMatherFiler.put("$ne", filter);
            return this;
        }

        public SingleElemMatcher $in(Object ... filters) {
            this.elemMatherFiler.put("$in", filters);
            return this;
        }

        public SingleElemMatcher $nin(Object ... filters) {
            this.elemMatherFiler.put("$nin", filters);
            return this;
        }

        public Map getElemMatherFiler() {
            return this.elemMatherFiler;
        }
    }

    public static class ElemMatcher {
        Map elemMatherFiler = new HashMap();

        public static ElemMatcher instance() {
            return new ElemMatcher();
        }

        public ElemMatcher $eq(String key, Object filter) {
            this.elemMatherFiler.put(key, this.toMap("$eq", filter));
            return this;
        }

        public ElemMatcher $gt(String key, Object filter) {
            HashMap<String, Object> $eq = new HashMap<String, Object>();
            $eq.put(key, filter);
            this.elemMatherFiler.put(key, this.toMap("$gt", filter));
            return this;
        }

        public ElemMatcher $gte(String key, Object filter) {
            this.elemMatherFiler.put(key, this.toMap("$gte", filter));
            return this;
        }

        public ElemMatcher $lt(String key, Object filter) {
            this.elemMatherFiler.put(key, this.toMap("$lt", filter));
            return this;
        }

        public ElemMatcher $lte(String key, Object filter) {
            this.elemMatherFiler.put(key, this.toMap("$lte", filter));
            return this;
        }

        public ElemMatcher $exists(String key, Object filter) {
            this.elemMatherFiler.put(key, this.toMap("$exists", filter));
            return this;
        }

        public ElemMatcher $ne(String key, Object filter) {
            this.elemMatherFiler.put(key, this.toMap("$ne", filter));
            return this;
        }

        public ElemMatcher $in(String key, Object ... filters) {
            this.elemMatherFiler.put(key, this.toMap("$in", filters));
            return this;
        }

        public ElemMatcher $nin(String key, Object ... filters) {
            this.elemMatherFiler.put(key, this.toMap("$nin", filters));
            return this;
        }

        Map toMap(String op, Object filter) {
            HashMap<String, Object> opMap = new HashMap<String, Object>();
            opMap.put(op, filter);
            return opMap;
        }

        Map getElemMatherFiler() {
            return this.elemMatherFiler;
        }
    }

    public static class InQueryOperator {
        String className;
        ElemMatcher elemMatcher = new ElemMatcher();

        public InQueryOperator(String className) {
            this.className = className;
        }

        public InQueryOperator $eq(String key, Object filter) {
            this.elemMatcher.$eq(key, filter);
            return this;
        }

        public InQueryOperator $gt(String key, Object filter) {
            this.elemMatcher.$gt(key, filter);
            return this;
        }

        public InQueryOperator $gte(String key, Object filter) {
            this.elemMatcher.$gte(key, filter);
            return this;
        }

        public InQueryOperator $lt(String key, Object filter) {
            this.elemMatcher.$lt(key, filter);
            return this;
        }

        public InQueryOperator $exists(String key, Object filter) {
            this.elemMatcher.$exists(key, filter);
            return this;
        }

        public InQueryOperator $lte(String key, Object filter) {
            this.elemMatcher.$lte(key, filter);
            return this;
        }

        public InQueryOperator $ne(String key, Object filter) {
            this.elemMatcher.$ne(key, filter);
            return this;
        }

        public InQueryOperator $in(String key, Object ... filters) {
            this.elemMatcher.$in(key, filters);
            return this;
        }

        public InQueryOperator $nin(String key, Object ... filters) {
            this.elemMatcher.$nin(key, filters);
            return this;
        }

        Map toMap() {
            HashMap<String, Object> query = new HashMap<String, Object>();
            query.put("className", this.className);
            query.put("where", this.elemMatcher.getElemMatherFiler());
            return query;
        }
    }

    public static class SelectOperator {
        String className;
        String key;
        ElemMatcher elemMatcher = new ElemMatcher();

        public SelectOperator(String className, String key) {
            this.className = className;
            this.key = key;
        }

        public SelectOperator $eq(String key, Object filter) {
            this.elemMatcher.$eq(key, filter);
            return this;
        }

        public SelectOperator $gt(String key, Object filter) {
            this.elemMatcher.$gt(key, filter);
            return this;
        }

        public SelectOperator $gte(String key, Object filter) {
            this.elemMatcher.$gte(key, filter);
            return this;
        }

        public SelectOperator $lt(String key, Object filter) {
            this.elemMatcher.$lt(key, filter);
            return this;
        }

        public SelectOperator $exists(String key, Object filter) {
            this.elemMatcher.$exists(key, filter);
            return this;
        }

        public SelectOperator $lte(String key, Object filter) {
            this.elemMatcher.$lte(key, filter);
            return this;
        }

        public SelectOperator $ne(String key, Object filter) {
            this.elemMatcher.$ne(key, filter);
            return this;
        }

        public SelectOperator $in(String key, Object ... filters) {
            this.elemMatcher.$in(key, filters);
            return this;
        }

        public SelectOperator $nin(String key, Object ... filters) {
            this.elemMatcher.$nin(key, filters);
            return this;
        }

        Map toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            HashMap<String, Object> query = new HashMap<String, Object>();
            query.put("className", this.className);
            query.put("where", this.elemMatcher.getElemMatherFiler());
            map.put("query", query);
            map.put("key", this.key);
            return map;
        }
    }

    public static enum SunQueryType {
        OR("$or", "or"),
        AND("$and", "and"),
        NE("$ne", "!="),
        LT("$lt", "<"),
        LTE("$lte", "<="),
        GT("$gt", ">"),
        GTE("$gte", ">="),
        IN("$in", "similar sql in"),
        NIN("$nin", "similar sql not in"),
        NOT("$not", ""),
        ALL("$all", ""),
        WITHIN("$geoWithin", "queries for a defined point, line or shape that exists entirely within another defined shape"),
        NEAR_SPHERE("$nearSphere", "Specifies a point for which a geospatial query returns the closest documents first"),
        MAX_DISTANCE("$maxDistance", " constrains the results of a geospatial $near or $nearSphere query to the specified distance"),
        REGULAR("$regex", "Matches documents that have the specified field in perl regular expression"),
        EXIST("$exists", "Matches documents that have the specified field"),
        SELECT("$select", "Matching the return value of another query"),
        DONTSELECT("$dontSelect", " Don't matching the return value of another query"),
        INQUERY("$inQuery", "In the return value of another query"),
        NINQUERY("$ninQuery", "Not in the return value of another query"),
        RELATETO("$relatedTo", "Relation query in zcloud");

        private String operator;
        private String desc;

        private SunQueryType(String operator, String desc) {
            this.operator = operator;
            this.desc = desc;
        }

        public String getOperator() {
            return this.operator;
        }

        public String getDesc() {
            return this.desc;
        }

        public static SunQueryType from(String operator) {
            if (operator == null) {
                return null;
            }
            if (operator.equals(SunQueryType.OR.operator)) {
                return OR;
            }
            if (operator.equals(SunQueryType.AND.operator)) {
                return AND;
            }
            if (operator.equals(SunQueryType.NE.operator)) {
                return NE;
            }
            if (operator.equals(SunQueryType.LT.operator)) {
                return LT;
            }
            if (operator.equals(SunQueryType.LTE.operator)) {
                return LTE;
            }
            if (operator.equals(SunQueryType.GT.operator)) {
                return GT;
            }
            if (operator.equals(SunQueryType.GTE.operator)) {
                return GTE;
            }
            if (operator.equals(SunQueryType.IN.operator)) {
                return IN;
            }
            if (operator.equals(SunQueryType.NIN.operator)) {
                return NIN;
            }
            if (operator.equals(SunQueryType.ALL.operator)) {
                return ALL;
            }
            if (operator.equals(SunQueryType.EXIST.operator)) {
                return EXIST;
            }
            if (operator.equals(SunQueryType.REGULAR.operator)) {
                return REGULAR;
            }
            if (operator.equals(SunQueryType.SELECT.operator)) {
                return SELECT;
            }
            if (operator.equals(SunQueryType.DONTSELECT.operator)) {
                return DONTSELECT;
            }
            if (operator.equals(SunQueryType.INQUERY.operator)) {
                return INQUERY;
            }
            if (operator.equals(SunQueryType.NINQUERY.operator)) {
                return NINQUERY;
            }
            if (operator.equals(SunQueryType.RELATETO.operator)) {
                return RELATETO;
            }
            if (operator.equals(SunQueryType.NEAR_SPHERE.operator)) {
                return NEAR_SPHERE;
            }
            if (operator.equals(SunQueryType.WITHIN.operator)) {
                return WITHIN;
            }
            return null;
        }
    }
}

