/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.test.framework;

import as.leap.code.Definer;
import as.leap.code.LASHandler;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.Request;
import as.leap.code.RequestCategory;
import as.leap.code.Response;
import as.leap.code.data.access.DataAccessMethod;
import as.leap.code.impl.JobRunner;
import as.leap.code.impl.LASClassManagerHandler;
import as.leap.code.impl.LASRequest;
import as.leap.code.impl.LASResponse;
import as.leap.code.test.framework.BootstrapCloudCode;
import as.leap.code.test.framework.LASJsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;

public abstract class TestCloudCode {
    private static final Logger logger = LoggerFactory.getLogger(TestCloudCode.class);
    private BootstrapCloudCode bootstrapCloudCode = new BootstrapCloudCode();

    protected TestCloudCode() throws Exception {
        this.bootstrapCloudCode.start();
    }

    protected TestCloudCode(String restAddr) throws Exception {
        this.bootstrapCloudCode.setRestAddr(restAddr);
        this.bootstrapCloudCode.start();
    }

    protected Response runFunction(String name, String params) {
        Response response;
        block7: {
            LASRequest request = new LASRequest(params);
            response = null;
            Definer definer = (Definer)this.bootstrapCloudCode.getLoader().definers().get(RequestCategory.FUNCTION.alias());
            if (definer == null) {
                System.err.println("doesn't exist function definer");
            } else {
                LASHandler handler = definer.getHandler(name);
                if (handler != null) {
                    try {
                        response = handler.handle((Request)request);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        StackTraceElement[] elements = e.getStackTrace();
                        if (elements != null && elements.length > 0) {
                            System.err.println(e.toString() + " at " + elements[0]);
                            break block7;
                        }
                        System.err.println(e.toString());
                    }
                } else {
                    response = new LASResponse(String.class);
                    response.setError("function " + name + " undefined.");
                    System.err.println("function " + name + " undefined.");
                }
            }
        }
        return response;
    }

    protected void runJob(String name, String params) {
        LASRequest request = new LASRequest(params);
        Definer definer = (Definer)this.bootstrapCloudCode.getLoader().definers().get(RequestCategory.JOB.alias());
        if (definer == null) {
            logger.error((Object)"doesn't exist job definer");
        } else {
            LASHandler handler = definer.getHandler(name);
            if (handler != null) {
                JobRunner jobRunner = new JobRunner(handler, (Request)request);
                jobRunner.start();
                try {
                    jobRunner.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                logger.error((Object)("job " + name + " undefined."));
            }
        }
    }

    protected <T> Response runEntityHook(T object, DataAccessMethod method) throws Exception {
        return this.runEntityHook(object.getClass().getSimpleName(), method, object);
    }

    protected <T> Response runEntityHook(String managerName, DataAccessMethod method, T object) throws Exception {
        LASClassManagerHandler entityManagerHandler = this.bootstrapCloudCode.getClassesManagerHandler(managerName);
        JsonNode params = LASJsonParser.asJsonNode(object);
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        requestParams.put("params", params);
        requestParams.put("method", method == DataAccessMethod.FINDBYID ? "findById" : method.name().toLowerCase());
        LASRequest request = new LASRequest(LASJsonParser.asJson(requestParams));
        Response response = entityManagerHandler.handle((Request)request);
        return response;
    }
}

