/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.test.framework;

import as.leap.code.ClassManager;
import as.leap.code.CloudCodeContants;
import as.leap.code.LASClassManager;
import as.leap.code.LASClassManagerFactory;
import as.leap.code.LASClassManagerHook;
import as.leap.code.LASException;
import as.leap.code.Loader;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.impl.GlobalConfig;
import as.leap.code.impl.LASClassManagerHandler;
import as.leap.code.impl.LASClassManagerHookBase;
import as.leap.code.impl.LASClassManagerImpl;
import as.leap.code.impl.LoaderBase;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.file.FileURLConnection;

class BootstrapCloudCode {
    private GlobalConfig globalConfig;
    private static final Logger logger = LoggerFactory.getLogger(BootstrapCloudCode.class);
    private LoaderBase loader;
    private ClassLoader classLoader;
    private Set<Class> hookClasses;
    private Map<String, LASClassManagerHandler> classesManagerHandlerMap = new ConcurrentHashMap<String, LASClassManagerHandler>();
    private String restAddr;

    BootstrapCloudCode() {
    }

    public void setRestAddr(String restAddr) {
        this.restAddr = restAddr;
    }

    public void start() throws Exception {
        CloudCodeContants.init();
        if (this.restAddr != null) {
            CloudCodeContants.DEFAULT_API_ADDRESS_PREFIX = this.restAddr;
        }
        this.globalConfig = CloudCodeContants.GLOBAL_CONFIG;
        this.hookClasses = new HashSet<Class>();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.loadHookAndManager();
        this.cacheClasses();
        this.loadMain(this.globalConfig.getCodeMain());
    }

    public LASClassManagerHandler getClassesManagerHandler(String managerName) {
        return this.classesManagerHandlerMap.get(managerName);
    }

    public Loader getLoader() {
        return this.loader;
    }

    private void loadMain(String userMainClassPath) throws Exception {
        Class<?> clazz = Class.forName(userMainClassPath);
        this.loader = (LoaderBase)clazz.newInstance();
        this.loader.main(this.globalConfig);
    }

    private void cacheClasses() {
        String classesPackage = this.globalConfig.getPackageClasses();
        if (this.isBlank(classesPackage)) {
            logger.warn((Object)"Your packageClasses is empty.You will can't operate any LASClassesManager interfaces.");
            return;
        }
        try {
            List<Class<Class>> allClasses = this.getClassesForPackage(this.classLoader, classesPackage);
            if (allClasses.size() == 0) {
                logger.warn((Object)"Your packageClasses is empty.You will can't operate any LASClassesManager interfaces.Please check your global.json config");
                return;
            }
            allClasses.removeAll(this.hookClasses);
            for (Class<?> clazz : allClasses) {
                LASClassManagerImpl classesManager = new LASClassManagerImpl(null, clazz);
                LASClassManagerFactory.putManager(clazz, (LASClassManager)classesManager);
                logger.info("cache entity to factory:" + clazz.getSimpleName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
    }

    private void loadHookAndManager() throws Exception {
        File[] files;
        String hookPackage = this.globalConfig.getPackageHook();
        if (this.isBlank(hookPackage)) {
            return;
        }
        URL packageRoot = this.classLoader.getResource(hookPackage.replace(".", "/"));
        if (packageRoot == null) {
            throw new LASException("your packageHook is invalid.Please check your global.json config");
        }
        for (File file : files = new File(packageRoot.getFile()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".class");
            }
        })) {
            String name = file.getName();
            if (!name.endsWith(".class")) continue;
            this.parseClass(hookPackage, name.substring(0, name.length() - 6));
        }
    }

    private void parseClass(String hookPackage, String clazzName) {
        try {
            Class<?> hookClazz = this.classLoader.loadClass(hookPackage + "." + clazzName);
            ClassManager classManagerAnnotation = hookClazz.getAnnotation(ClassManager.class);
            if (classManagerAnnotation == null) {
                return;
            }
            String managerName = classManagerAnnotation.value();
            if (managerName.equals("")) {
                String[] managerNames = managerName.split("ManagerHook");
                if (managerNames.length >= 2) {
                    managerName = managerNames[0];
                } else {
                    managerNames = managerName.split("Hook");
                    if (managerNames.length >= 2) {
                        managerName = managerNames[0];
                    } else {
                        throw new IllegalArgumentException(String.format("class %s should be annotate value.", hookClazz.getSimpleName()));
                    }
                }
            }
            LASClassManagerHookBase hook = (LASClassManagerHookBase)hookClazz.newInstance();
            Type[] types = ((ParameterizedType)hookClazz.getGenericSuperclass()).getActualTypeArguments();
            Class classesClazz = (Class)types[0];
            LASClassManagerImpl classesManager = new LASClassManagerImpl((LASClassManagerHook)hook, classesClazz);
            this.classesManagerHandlerMap.put(managerName, new LASClassManagerHandler((LASClassManager)classesManager, (LASClassManagerHook)hook, classesClazz));
            LASClassManagerFactory.putManager((Class)classesClazz, (LASClassManager)classesManager);
            logger.info("cache hook classes to factory:" + classesClazz.getSimpleName());
            this.hookClasses.add(classesClazz);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isBlank(String str) {
        return str == null || str.trim().equals("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Class<?>> getClassesForPackage(ClassLoader cld, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        try {
            URL url;
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(packageName.replace('.', '/'));
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        this.checkJarFile((JarURLConnection)connection, packageName, classes);
                        continue;
                    }
                    if (!(connection instanceof FileURLConnection)) throw new ClassNotFoundException(packageName + " (" + url.getPath() + ") does not appear to be a valid package");
                    try {
                        this.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), packageName, classes);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ClassNotFoundException(packageName + " does not appear to be a valid package (Unsupported encoding)", ex);
                    }
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + packageName, e);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(packageName + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ioEx) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + packageName, ioEx);
        }
    }

    private void checkDirectory(File directory, String packageName, ArrayList<Class<?>> classes) throws ClassNotFoundException {
        if (directory.exists() && directory.isDirectory()) {
            String[] files;
            for (String file : files = directory.list()) {
                if (file.endsWith(".class")) {
                    try {
                        classes.add(Class.forName(packageName + '.' + file.substring(0, file.length() - 6)));
                    }
                    catch (NoClassDefFoundError e) {}
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory()) continue;
                this.checkDirectory(tmpDirectory, packageName + "." + file, classes);
            }
        }
    }

    private void checkJarFile(JarURLConnection connection, String packageName, ArrayList<Class<?>> classes) throws ClassNotFoundException, IOException {
        JarEntry jarEntry;
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class") || !(name = name.substring(0, name.length() - 6).replace('/', '.')).contains(packageName)) continue;
            classes.add(this.classLoader.loadClass(name));
        }
    }
}

