/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.test.framework;

import as.leap.code.LASException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class LASJsonParser {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeFactory typeFactory = TypeFactory.defaultInstance();

    LASJsonParser() {
    }

    public static <T> T asObject(String source, Class<T> clazz) {
        try {
            return (T)mapper.readValue(source, typeFactory.uncheckedSimpleType(clazz));
        }
        catch (IOException e) {
            throw new LASException((Throwable)e);
        }
    }

    public static <T> T asObject(String source, JavaType type) {
        try {
            return (T)mapper.readValue(source, type);
        }
        catch (IOException e) {
            throw new LASException((Throwable)e);
        }
    }

    public static JsonNode asJsonNode(String source) {
        try {
            return mapper.readTree(source);
        }
        catch (IOException e) {
            throw new LASException((Throwable)e);
        }
    }

    public static Map<String, Object> jsonNodeToMap(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        Iterator paramsIterator = jsonNode.fieldNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (paramsIterator.hasNext()) {
            String paramName = (String)paramsIterator.next();
            JsonNode jsonSonNode = jsonNode.get(paramName);
            if (jsonSonNode.isInt()) {
                map.put(paramName, jsonSonNode.asInt());
                continue;
            }
            if (jsonSonNode.isLong()) {
                map.put(paramName, jsonSonNode.asLong());
                continue;
            }
            if (jsonSonNode.isTextual()) {
                map.put(paramName, jsonSonNode.asText());
                continue;
            }
            if (jsonSonNode.isObject()) {
                Map<String, Object> tempMap = LASJsonParser.jsonNodeToMap(jsonSonNode);
                if (tempMap == null) continue;
                map.put(paramName, tempMap);
                continue;
            }
            if (!jsonSonNode.isArray()) continue;
            Iterator nodeIterator = jsonSonNode.elements();
            ArrayList<Map<String, Object>> mapArrayList = new ArrayList<Map<String, Object>>();
            while (nodeIterator.hasNext()) {
                JsonNode tempJsonNode = (JsonNode)nodeIterator.next();
                Map<String, Object> tempM = LASJsonParser.jsonNodeToMap(tempJsonNode);
                if (tempM == null) continue;
                mapArrayList.add(tempM);
            }
            map.put(paramName, mapArrayList);
        }
        return map;
    }

    public static <T> String asJson(T obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new LASException((Throwable)e);
        }
    }

    public static JsonNode asJsonNode(Object obj) {
        return LASJsonParser.asJsonNode(LASJsonParser.asJson(obj));
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }
}

