/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.CloudCodeContants;
import as.leap.code.LASException;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.impl.WebUtils;
import as.leap.code.themis.Themis;
import java.util.HashMap;
import java.util.Map;

public class ThemisImpl
implements Themis {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThemisImpl.class);
    private String version;
    private String countAddress;
    private String lockAddress;
    private Map<String, String> headers = new HashMap<String, String>();

    public ThemisImpl() {
        this.version = CloudCodeContants.GLOBAL_CONFIG.getVersion();
        this.countAddress = CloudCodeContants.DEFAULT_API_ADDRESS_PREFIX + "/themis/count/";
        this.lockAddress = CloudCodeContants.DEFAULT_API_ADDRESS_PREFIX + "/themis/lock/";
        this.headers.put("X-ZCloud-AppId", CloudCodeContants.GLOBAL_CONFIG.getApplicationID());
        this.headers.put("X-ZCloud-MasterKey", CloudCodeContants.GLOBAL_CONFIG.getApplicationKey());
    }

    private String getFullCountAddress(String operator, String name) {
        if (operator == null) {
            return this.countAddress + this.version + "/" + name;
        }
        return this.countAddress + operator + "/" + this.version + "/" + name;
    }

    private String getFullLockAddress(String name) {
        return this.lockAddress + this.version + "/" + name;
    }

    public void generateCounter(String name) {
        try {
            String response = WebUtils.doPost(this.getFullCountAddress(null, name), this.headers, null, 5000, 15000);
            LOGGER.info("get response of generateCounter[" + this.getFullCountAddress(null, name) + "]:" + response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public Long get(String name) {
        try {
            String response = WebUtils.doGet(this.getFullCountAddress(null, name), this.headers, null);
            LOGGER.info("get response of get[" + this.getFullCountAddress(null, name) + "]:" + response);
            return Long.parseLong(response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public Long incrementAndGet(String name) {
        try {
            String response = WebUtils.doPut(this.getFullCountAddress("incrementAndGet", name), this.headers, "", 5000, 15000);
            LOGGER.info("get response of incrementAndGet[" + this.getFullCountAddress("incrementAndGet", name) + "]:" + response);
            return Long.parseLong(response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public Long getAndIncrement(String name) {
        try {
            String response = WebUtils.doPut(this.getFullCountAddress("getAndIncrement", name), this.headers, "", 5000, 15000);
            LOGGER.info("get response of getAndIncrement[" + this.getFullCountAddress("getAndIncrement", name) + "]:" + response);
            return Long.parseLong(response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public Long decrementAndGet(String name) {
        try {
            String response = WebUtils.doPut(this.getFullCountAddress("decrementAndGet", name), this.headers, "", 5000, 15000);
            LOGGER.info("get response of decrementAndGet[" + this.getFullCountAddress("decrementAndGet", name) + "]:" + response);
            return Long.parseLong(response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public Long addAndGet(String name, long value) {
        try {
            String response = WebUtils.doPut(this.getFullCountAddress("addAndGet", name) + "/" + String.valueOf(value), this.headers, "", 5000, 15000);
            LOGGER.info("get response of addAndGet[" + this.getFullCountAddress("addAndGet", name) + "/" + String.valueOf(value) + "]:" + response);
            return Long.parseLong(response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public Long getAndAdd(String name, long value) {
        try {
            String response = WebUtils.doPut(this.getFullCountAddress("getAndAdd", name) + "/" + String.valueOf(value), this.headers, "", 5000, 15000);
            LOGGER.info("get response of getAndAdd[" + this.getFullCountAddress("getAndAdd", name) + "/" + String.valueOf(value) + "]:" + response);
            return Long.parseLong(response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public Boolean compareAndSet(String name, long expected, long value) {
        try {
            String response = WebUtils.doPost(this.getFullCountAddress("getAndAdd", name) + "/" + String.valueOf(expected) + "/" + String.valueOf(value), this.headers, null, 5000, 15000);
            LOGGER.info("get response of compareAndSet[" + this.getFullCountAddress("compareAndSet", name) + "/" + String.valueOf(expected) + "/" + String.valueOf(value) + "]:" + response);
            return Boolean.parseBoolean(response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public void getLock(String name) {
        try {
            String response = WebUtils.doGet(this.getFullLockAddress(name), this.headers, null);
            LOGGER.info("get response of getLock[" + this.getFullLockAddress(name) + "]:" + response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public void lockRelease(String name) {
        try {
            String response = WebUtils.doDelete(this.getFullLockAddress(name), this.headers, null);
            LOGGER.info("get response of getLock[" + this.getFullLockAddress(name) + "]:" + response);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }
}

