/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.CloudCodeContants;
import as.leap.code.LASException;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.assist.AssistLASClassManager;
import as.leap.code.assist.Path;
import as.leap.code.impl.LASJsonParser;
import as.leap.code.impl.WebUtils;
import as.leap.las.sdk.DeleteMsg;
import as.leap.las.sdk.FindMsg;
import as.leap.las.sdk.LASQuery;
import as.leap.las.sdk.LASUpdate;
import as.leap.las.sdk.SaveMsg;
import as.leap.las.sdk.UpdateMsg;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AssistLASClassManagerImpl<T>
implements AssistLASClassManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssistLASClassManagerImpl.class);
    private Class<T> tClass;
    String apiAddress;

    public AssistLASClassManagerImpl(Class<T> tClass) {
        this.tClass = tClass;
        String path = this.tClass.getAnnotation(Path.class).value();
        this.apiAddress = CloudCodeContants.DEFAULT_API_ADDRESS_PREFIX + path;
    }

    public FindMsg<T> find(LASQuery query) {
        try {
            String response = WebUtils.doPost(this.apiAddress + "/query", CloudCodeContants.HEADERS, this.serializeLasQueryForPostQuest(query), 5000, 15000);
            LOGGER.info("get response of find[" + this.apiAddress + "/query]:" + response);
            JsonNode jsonNode = LASJsonParser.asJsonNode((String)response);
            ArrayNode results = (ArrayNode)jsonNode.get("results");
            int c = 0;
            ArrayList<Object> r = new ArrayList<Object>();
            if (results != null) {
                c = results.size();
                for (JsonNode result : results) {
                    r.add(LASJsonParser.asObject((String)result.toString(), this.tClass));
                }
            }
            return new FindMsg(c, r);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public SaveMsg create(T obj) throws LASException {
        try {
            String response = WebUtils.doPost(this.apiAddress, CloudCodeContants.HEADERS, LASJsonParser.asJson(obj), 5000, 15000);
            LOGGER.info("get response of create[" + this.apiAddress + "]:" + response);
            return (SaveMsg)LASJsonParser.asObject((String)response, SaveMsg.class);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public T findById(String id) {
        try {
            String response = WebUtils.doGet(this.apiAddress + "/" + id, CloudCodeContants.HEADERS, null);
            LOGGER.info("get response of findById[" + this.apiAddress + "/" + id + "]:" + response);
            if ("{}".equals(response)) {
                return null;
            }
            return (T)LASJsonParser.asObject((String)response, this.tClass);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public UpdateMsg update(String id, LASUpdate update) throws LASException {
        try {
            String response = WebUtils.doPut(this.apiAddress + "/" + id, (Map<String, String>)CloudCodeContants.HEADERS, LASJsonParser.asJson((Object)update.update()), 5000, 15000);
            LOGGER.info("get response of update[" + this.apiAddress + "/" + id + "](" + update.update() + "):" + response);
            return (UpdateMsg)LASJsonParser.asObject((String)response, UpdateMsg.class);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public DeleteMsg delete(String id) {
        try {
            String response = WebUtils.doDelete(this.apiAddress + "/" + id, CloudCodeContants.HEADERS, null);
            LOGGER.info("get response of delete[" + this.apiAddress + "/" + id + "]:" + response);
            return (DeleteMsg)LASJsonParser.asObject((String)response, DeleteMsg.class);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    String serializeLasQueryForPostQuest(LASQuery lasQuery) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (lasQuery.query() != null) {
            map.put("where", LASJsonParser.asJson((Object)lasQuery.query()));
        }
        if (lasQuery.sort() != null) {
            map.put("order", lasQuery.sort());
        }
        if (lasQuery.keys() != null) {
            map.put("keys", lasQuery.keys());
        }
        if (lasQuery.includes() != null) {
            map.put("include", lasQuery.includes());
        }
        map.put("limit", lasQuery.limit());
        map.put("skip", lasQuery.skip());
        return LASJsonParser.asJson(map);
    }
}

