/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.AfterResult;
import as.leap.code.BeforeResult;
import as.leap.code.DeleteResult;
import as.leap.code.LASClassManager;
import as.leap.code.LASClassManagerHook;
import as.leap.code.LASException;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.SaveResult;
import as.leap.code.impl.LASJsonParser;
import as.leap.code.impl.WebUtils;
import as.leap.las.sdk.DeleteMsg;
import as.leap.las.sdk.FindMsg;
import as.leap.las.sdk.LASQuery;
import as.leap.las.sdk.LASUpdate;
import as.leap.las.sdk.SaveMsg;
import as.leap.las.sdk.UpdateMsg;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LASClassManagerImpl<T>
implements LASClassManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LASClassManagerImpl.class);
    private String appId;
    private String masterKey;
    private LASClassManagerHook<T> hook;
    private Class<T> entityClazz;
    private String className;
    private String apiAddress;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_READ_TIMEOUT = 15000;
    private static final String DEFAULT_API_ADDRESS_PREFIX = "http://apiuat.zcloud.io/2.0";
    private static final String HEADER_ZCLOUD_APPID = "X-ZCloud-AppId";
    private static final String HEADER_ZCLOUD_MASTERKEY = "X-ZCloud-MasterKey";
    private static final String HEADER_ZCLOUD_REQUEST_FROM_CLOUDCODE = "X-ZCloud-Request-From-Cloudcode";

    public LASClassManagerImpl(String appId, String masterKey, LASClassManagerHook<T> hook, Class<T> entityClazz) {
        this(appId, masterKey, hook, entityClazz, null);
    }

    public LASClassManagerImpl(String appId, String masterKey, LASClassManagerHook<T> hook, Class<T> entityClazz, String restAddress) {
        this.appId = appId;
        this.masterKey = masterKey;
        this.hook = hook;
        this.entityClazz = entityClazz;
        this.className = entityClazz.getSimpleName();
        this.apiAddress = (restAddress == null ? DEFAULT_API_ADDRESS_PREFIX : restAddress) + "/classes/";
    }

    public SaveResult<T> create(T object) throws LASException {
        try {
            BeforeResult beforeResult;
            BeforeResult beforeResult2 = beforeResult = this.hook == null ? new BeforeResult(object, true) : this.hook.beforeCreate(object);
            if (!beforeResult.isResult()) {
                return new SaveResult(beforeResult.getFailMessage());
            }
            String response = WebUtils.doPost(this.getAPIAddress(), this.getHeader(), LASJsonParser.asJson(object), 5000, 15000);
            LOGGER.info("get response of create[" + this.getAPIAddress() + "]:" + response);
            SaveMsg saveMsg = (SaveMsg)LASJsonParser.asObject((String)response, SaveMsg.class);
            SaveResult saveResult = new SaveResult(beforeResult, saveMsg);
            if (this.hook == null) {
                return saveResult;
            }
            AfterResult afterResult = this.hook.afterCreate(beforeResult, saveMsg);
            if (!afterResult.isSuccess()) {
                saveResult.setFailMessage(afterResult.getFailMessage());
            }
            return saveResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LASException((Throwable)e);
        }
    }

    public FindMsg<T> find(LASQuery query) {
        return this.find(query, false);
    }

    public FindMsg<T> find(LASQuery query, boolean count) throws LASException {
        try {
            String postQuery = this.serializeLasQueryForPostQuest(query);
            String response = WebUtils.doPost(this.getAPIAddress() + "/query", this.getHeader(), postQuery, 5000, 15000);
            LOGGER.info("get response of find[" + this.getAPIAddress() + "/query](" + postQuery + "):" + response);
            JsonNode responseJson = LASJsonParser.asJsonNode((String)response);
            ArrayNode results = (ArrayNode)responseJson.get("results");
            ArrayList<Object> r = new ArrayList<Object>();
            if (results == null || results.size() == 0) {
                return new FindMsg();
            }
            for (JsonNode result : results) {
                r.add(LASJsonParser.asObject((String)result.toString(), this.entityClazz));
            }
            return new FindMsg(count ? results.size() : 0, r);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LASException((Throwable)e);
        }
    }

    public T findById(String id) throws LASException {
        try {
            String response = WebUtils.doGet(this.getAPIAddress() + "/" + id, this.getHeader(), null);
            LOGGER.info("get response of findById[" + this.getAPIAddress() + "/" + id + "]:" + response);
            if ("{}".equals(response)) {
                return null;
            }
            return (T)LASJsonParser.asObject((String)response, this.entityClazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LASException((Throwable)e);
        }
    }

    public UpdateMsg update(String id, LASUpdate update) throws LASException {
        try {
            String response = WebUtils.doPut(this.getAPIAddress() + "/" + id, this.getHeader(), LASJsonParser.asJson((Object)update.update()), 5000, 15000);
            LOGGER.info("get response of update[" + this.getAPIAddress() + "/" + id + "](" + update.update() + "):" + response);
            UpdateMsg updateMsg = (UpdateMsg)LASJsonParser.asObject((String)response, UpdateMsg.class);
            if (this.hook != null) {
                this.hook.afterUpdate(id, updateMsg);
            }
            return updateMsg;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LASException((Throwable)e);
        }
    }

    public DeleteResult delete(String id) throws LASException {
        BeforeResult beforeResult;
        BeforeResult beforeResult2 = beforeResult = this.hook == null ? new BeforeResult((Object)id, true) : this.hook.beforeDelete(id);
        if (!beforeResult.isResult()) {
            return new DeleteResult(beforeResult.getFailMessage());
        }
        try {
            String response = WebUtils.doDelete(this.getAPIAddress() + "/" + id, this.getHeader(), null);
            LOGGER.info("get response of delete[" + this.getAPIAddress() + "/" + id + "]:" + response);
            DeleteMsg deleteMsg = (DeleteMsg)LASJsonParser.asObject((String)response, DeleteMsg.class);
            DeleteResult deleteResult = new DeleteResult(beforeResult, deleteMsg);
            if (this.hook == null) {
                return deleteResult;
            }
            AfterResult afterResult = this.hook.afterDelete(beforeResult, deleteMsg);
            if (!afterResult.isSuccess()) {
                deleteResult.setFailMessage(afterResult.getFailMessage());
            }
            return deleteResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LASException((Throwable)e);
        }
    }

    public DeleteResult delete(String[] ids) {
        if (ids != null && ids.length > 50) {
            throw new LASException("delete bach max limit 50.");
        }
        try {
            BeforeResult beforeResult;
            BeforeResult beforeResult2 = beforeResult = this.hook == null ? new BeforeResult((Object)ids, true) : this.hook.beforeDelete(ids);
            if (!beforeResult.isResult()) {
                return new DeleteResult(beforeResult.getFailMessage());
            }
            ArrayNode arrays = JsonNodeFactory.instance.arrayNode();
            for (String id : ids) {
                arrays.add(id);
            }
            ObjectNode params = JsonNodeFactory.instance.objectNode();
            params.put("objectIds", (JsonNode)arrays);
            String response = WebUtils.doPost(this.getAPIAddress() + "/delete", this.getHeader(), params.toString(), 5000, 15000);
            LOGGER.info("get response of deleteBatch[" + this.getAPIAddress() + "/delete](" + ids + "):" + response);
            return new DeleteResult(beforeResult, (DeleteMsg)LASJsonParser.asObject((String)response, DeleteMsg.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LASException((Throwable)e);
        }
    }

    String serializeLasQueryForPostQuest(LASQuery lasQuery) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (lasQuery.query() != null) {
            map.put("where", LASJsonParser.asJson((Object)lasQuery.query()));
        }
        if (lasQuery.sort() != null) {
            map.put("order", lasQuery.sort());
        }
        if (lasQuery.keys() != null) {
            map.put("keys", lasQuery.keys());
        }
        if (lasQuery.includes() != null) {
            map.put("include", lasQuery.includes());
        }
        map.put("limit", lasQuery.limit());
        map.put("skip", lasQuery.skip());
        return LASJsonParser.asJson(map);
    }

    private String getAPIAddress() {
        return this.apiAddress + this.className;
    }

    private Map<String, String> getHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_ZCLOUD_APPID, this.appId);
        headers.put(HEADER_ZCLOUD_MASTERKEY, this.masterKey);
        headers.put(HEADER_ZCLOUD_REQUEST_FROM_CLOUDCODE, "true");
        return headers;
    }
}

