/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.LASHandler;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.Request;
import as.leap.code.Response;
import as.leap.code.impl.LASJsonParser;
import as.leap.code.impl.LASResponse;
import com.fasterxml.jackson.databind.JavaType;

public class JobRunner<T>
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(JobRunner.class);
    private LASHandler<Request, Response<T>> handler;
    private Request request;
    private boolean running;

    public JobRunner(LASHandler<Request, Response<T>> handler, Request request) {
        this.handler = handler;
        this.request = request;
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        try {
            LASResponse response = (LASResponse)this.handler.handle(this.request);
            if (response.succeeded()) {
                JavaType type = response.getResultType();
                String result = type.isPrimitive() || type.getRawClass() == Integer.class || type.getRawClass() == String.class || type.getRawClass() == Long.class || type.getRawClass() == Boolean.class || type.getRawClass() == Float.class ? response.getResult().toString() : LASJsonParser.asJson((Object)response.getResult());
                logger.info(result);
            } else {
                logger.error((Object)response.getError());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
    }
}

