/*
 * Decompiled with CFR 0.152.
 */
package as.leap.code.impl;

import as.leap.code.LASException;
import as.leap.code.Logger;
import as.leap.code.LoggerFactory;
import as.leap.code.assist.AssistLASClassManager;
import as.leap.code.assist.Path;
import as.leap.code.impl.GlobalConfig;
import as.leap.code.impl.LASJsonParser;
import as.leap.code.impl.WebUtils;
import as.leap.las.sdk.DeleteMsg;
import as.leap.las.sdk.FindMsg;
import as.leap.las.sdk.LASQuery;
import as.leap.las.sdk.LASUpdate;
import as.leap.las.sdk.SaveMsg;
import as.leap.las.sdk.UpdateMsg;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AssistLASClassManagerImpl<T>
implements AssistLASClassManager<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssistLASClassManagerImpl.class);
    private String appId;
    private String masterKey;
    private Class<T> tClass;
    private String apiAddress;
    private String path;
    static final int DEFAULT_TIMEOUT = 5000;
    static final int DEFAULT_READ_TIMEOUT = 15000;
    public static String DEFAULT_API_ADDRESS_PREFIX = "http://apiuat.zcloud.io/2.0";
    private static final String HEADER_ZCLOUD_APPID = "X-ZCloud-AppId";
    private static final String HEADER_ZCLOUD_MASTERKEY = "X-ZCloud-MasterKey";
    private static final String HEADER_ZCLOUD_REQUEST_FROM_CLOUDCODE = "X-ZCloud-Request-From-Cloudcode";

    public AssistLASClassManagerImpl(Class<T> tClass) {
        this.tClass = tClass;
        this.path = this.tClass.getAnnotation(Path.class).value();
        GlobalConfig globalConfig = this.getGlabalConfig();
        this.appId = globalConfig.getApplicationID();
        this.masterKey = globalConfig.getApplicationKey();
        this.apiAddress = DEFAULT_API_ADDRESS_PREFIX;
    }

    String getAPIAddress() {
        return this.apiAddress + this.path;
    }

    public FindMsg<T> find(LASQuery query) {
        try {
            String response = WebUtils.doPost(this.getAPIAddress() + "/query", this.getHeader(), this.serializeLasQueryForPostQuest(query), 5000, 15000);
            LOGGER.info("get response of find[" + this.getAPIAddress() + "/query]:" + response);
            JsonNode jsonNode = LASJsonParser.asJsonNode((String)response);
            ArrayNode results = (ArrayNode)jsonNode.get("results");
            int c = 0;
            ArrayList<Object> r = new ArrayList<Object>();
            if (results != null) {
                c = results.size();
                for (JsonNode result : results) {
                    r.add(LASJsonParser.asObject((String)result.toString(), this.tClass));
                }
            }
            return new FindMsg(c, r);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public SaveMsg create(T obj) throws LASException {
        try {
            String response = WebUtils.doPost(this.getAPIAddress(), this.getHeader(), LASJsonParser.asJson(obj), 5000, 15000);
            LOGGER.info("get response of create[" + this.getAPIAddress() + "]:" + response);
            return (SaveMsg)LASJsonParser.asObject((String)response, SaveMsg.class);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public T findById(String id) {
        try {
            String response = WebUtils.doGet(this.getAPIAddress() + "/" + id, this.getHeader(), null);
            LOGGER.info("get response of findById[" + this.getAPIAddress() + "/" + id + "]:" + response);
            if ("{}".equals(response)) {
                return null;
            }
            return (T)LASJsonParser.asObject((String)response, this.tClass);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public UpdateMsg update(String id, LASUpdate update) throws LASException {
        try {
            String response = WebUtils.doPut(this.getAPIAddress() + "/" + id, this.getHeader(), LASJsonParser.asJson((Object)update.update()), 5000, 15000);
            LOGGER.info("get response of update[" + this.getAPIAddress() + "/" + id + "](" + update.update() + "):" + response);
            return (UpdateMsg)LASJsonParser.asObject((String)response, UpdateMsg.class);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    public DeleteMsg delete(String id) {
        try {
            String response = WebUtils.doDelete(this.getAPIAddress() + "/" + id, this.getHeader(), null);
            LOGGER.info("get response of delete[" + this.getAPIAddress() + "/" + id + "]:" + response);
            return (DeleteMsg)LASJsonParser.asObject((String)response, DeleteMsg.class);
        }
        catch (Exception e) {
            throw new LASException((Throwable)e);
        }
    }

    String serializeLasQueryForPostQuest(LASQuery lasQuery) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (lasQuery.query() != null) {
            map.put("where", LASJsonParser.asJson((Object)lasQuery.query()));
        }
        if (lasQuery.sort() != null) {
            map.put("order", lasQuery.sort());
        }
        if (lasQuery.keys() != null) {
            map.put("keys", lasQuery.keys());
        }
        if (lasQuery.includes() != null) {
            map.put("include", lasQuery.includes());
        }
        map.put("limit", lasQuery.limit());
        map.put("skip", lasQuery.skip());
        return LASJsonParser.asJson(map);
    }

    Map<String, String> getHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(HEADER_ZCLOUD_APPID, this.appId);
        headers.put(HEADER_ZCLOUD_MASTERKEY, this.masterKey);
        headers.put(HEADER_ZCLOUD_REQUEST_FROM_CLOUDCODE, "true");
        return headers;
    }

    private GlobalConfig getGlabalConfig() {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/global.json");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder globalBuilder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                globalBuilder.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GlobalConfig globalConfig = new GlobalConfig(globalBuilder.toString());
        return globalConfig;
    }
}

