/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache.math;

import ar.com.siripo.arcache.math.AbstractProbabilityFunction;

public class AdjustedExponentialProbabilityFunction
extends AbstractProbabilityFunction {
    protected double shapeFactor = 11.0;

    public AdjustedExponentialProbabilityFunction(double graceZone, double shapeFactor) {
        this.setGraceZone(graceZone);
        if (shapeFactor == 0.0) {
            throw new IllegalArgumentException("shapeFactor must be != 0");
        }
        this.shapeFactor = shapeFactor;
    }

    @Override
    public double getProbability(double x) {
        double xx = (x - this.graceZone) / (1.0 - this.graceZone);
        double y = (Math.exp(xx * this.shapeFactor) - 1.0) / (Math.exp(this.shapeFactor) - 1.0);
        if (y <= 0.0) {
            return 0.0;
        }
        if (y >= 1.0) {
            return 1.0;
        }
        return y;
    }
}

