/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache;

import ar.com.siripo.arcache.ArcacheConfigurationGetInterface;
import ar.com.siripo.arcache.BackendKeyBuilder;
import ar.com.siripo.arcache.CacheInvalidationObject;
import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class InvalidateKeyTask
implements Future<Boolean> {
    protected final String key;
    protected final boolean hardInvalidation;
    protected final long invalidationWindowMillis;
    protected final ArcacheBackendClient backendClient;
    protected final BackendKeyBuilder keyBuilder;
    protected final ArcacheConfigurationGetInterface config;
    protected boolean cancelled = false;
    protected boolean done = false;
    protected Boolean valueToReturn;
    protected Future<Object> prevVersionGetFuture;
    protected Future<Boolean> setFuture;

    protected InvalidateKeyTask(String key, boolean hardInvalidation, long invalidationWindowMillis, ArcacheBackendClient backendClient, BackendKeyBuilder keyBuilder, ArcacheConfigurationGetInterface config) {
        this.key = key;
        this.hardInvalidation = hardInvalidation;
        this.invalidationWindowMillis = invalidationWindowMillis;
        this.backendClient = backendClient;
        this.keyBuilder = keyBuilder;
        this.config = config;
        this.start();
    }

    private void start() {
        this.prevVersionGetFuture = this.backendClient.asyncGet(this.keyBuilder.createInvalidationBackendKey(this.key));
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.done) {
            return false;
        }
        if (this.prevVersionGetFuture != null) {
            this.prevVersionGetFuture.cancel(mayInterruptIfRunning);
        }
        if (this.setFuture != null) {
            this.setFuture.cancel(mayInterruptIfRunning);
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.config.getDefaultOperationTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException toe) {
            throw new ExecutionException(toe);
        }
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = unit.toMillis(timeout);
        long startTimeMillis = System.currentTimeMillis();
        return this.doTask(startTimeMillis, timeoutMillis);
    }

    protected synchronized Boolean doTask(long startTimeMillis, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.done) {
            return this.valueToReturn;
        }
        CacheInvalidationObject previousInvalidationObject = this.getPreviousInvalidationObject(startTimeMillis, timeoutMillis);
        CacheInvalidationObject invalidationObject = this.createInvalidationObject(startTimeMillis, previousInvalidationObject);
        this.valueToReturn = this.setInvalidationObject(startTimeMillis, timeoutMillis, invalidationObject);
        this.done = true;
        return this.valueToReturn;
    }

    protected CacheInvalidationObject createInvalidationObject(long startTimeMillis, CacheInvalidationObject previousInvalidationObject) {
        CacheInvalidationObject invalidationObject = new CacheInvalidationObject();
        invalidationObject.invalidationTimestampMillis = startTimeMillis;
        invalidationObject.invalidationWindowMillis = this.invalidationWindowMillis;
        invalidationObject.isHardInvalidation = this.hardInvalidation;
        invalidationObject.lastHardInvalidationTimestampMillis = 0L;
        invalidationObject.lastSoftInvalidationTimestampMillis = 0L;
        if (previousInvalidationObject != null) {
            invalidationObject.lastHardInvalidationTimestampMillis = previousInvalidationObject.lastHardInvalidationTimestampMillis;
            invalidationObject.lastSoftInvalidationTimestampMillis = previousInvalidationObject.lastSoftInvalidationTimestampMillis;
            if (previousInvalidationObject.isHardInvalidation) {
                invalidationObject.lastHardInvalidationTimestampMillis = previousInvalidationObject.invalidationTimestampMillis;
            } else {
                invalidationObject.lastSoftInvalidationTimestampMillis = previousInvalidationObject.invalidationTimestampMillis;
            }
        }
        return invalidationObject;
    }

    protected CacheInvalidationObject getPreviousInvalidationObject(long startTimeMillis, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            long remainingTimeMillis = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
            if (remainingTimeMillis <= 0L) {
                throw new TimeoutException();
            }
            Object rawCachedObject = this.prevVersionGetFuture.get(remainingTimeMillis, TimeUnit.MILLISECONDS);
            if (!(rawCachedObject instanceof CacheInvalidationObject)) {
                return null;
            }
            return (CacheInvalidationObject)rawCachedObject;
        }
        catch (TimeoutException te) {
            throw te;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean setInvalidationObject(long startTimeMillis, long timeoutMillis, CacheInvalidationObject invalidationObject) throws InterruptedException, ExecutionException, TimeoutException {
        this.setFuture = this.backendClient.asyncSet(this.keyBuilder.createInvalidationBackendKey(this.key), this.config.getDefaultStoredObjectRemovalTimeMillis(), (Object)invalidationObject);
        long remainingTimeMillis = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
        if (remainingTimeMillis <= 0L) {
            throw new TimeoutException();
        }
        return this.setFuture.get(remainingTimeMillis, TimeUnit.MILLISECONDS);
    }
}

