/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache;

public class CacheGetResult {
    protected Object value;
    protected Exception errorCause;
    protected Type type;
    protected String[] invalidationKeys;
    protected String invalidatedKey;
    protected long storeTimestampMillis;

    public boolean isHit() {
        return this.type == Type.HIT;
    }

    public boolean isMiss() {
        return this.type == Type.MISS;
    }

    public boolean isExpired() {
        return this.type == Type.EXPIRED;
    }

    public boolean isInvalidated() {
        return this.type == Type.INVALIDATED;
    }

    public boolean isHitOrExpired() {
        return this.type == Type.HIT || this.type == Type.EXPIRED;
    }

    public boolean isHitExpiredOrInvalidated() {
        return this.type == Type.HIT || this.type == Type.EXPIRED || this.type == Type.INVALIDATED;
    }

    public boolean isAnyTypeOfError() {
        return this.type == Type.TIMEOUT || this.type == Type.ERROR;
    }

    protected CacheGetResult(Type type) {
        this.type = type;
    }

    protected CacheGetResult(Type type, Exception cause) {
        this(type);
        this.errorCause = cause;
    }

    public Object getValue() {
        return this.value;
    }

    public Exception getErrorCause() {
        return this.errorCause;
    }

    public Type getType() {
        return this.type;
    }

    public String[] getInvalidationKeys() {
        return this.invalidationKeys;
    }

    public String getInvalidatedKey() {
        return this.invalidatedKey;
    }

    public long getStoreTimestampMillis() {
        return this.storeTimestampMillis;
    }

    public static class ErrorBuilder
    extends Builder {
        public ErrorBuilder() {
            super(Type.ERROR);
        }

        public ErrorBuilder(Exception errorCause) {
            this();
            this.withErrorCause(errorCause);
        }
    }

    public static class Builder {
        private CacheGetResult build;

        public Builder(Type type) {
            this.build = new CacheGetResult(type);
        }

        public Builder(CacheGetResult ref) {
            this(ref.type);
            this.build.errorCause = ref.errorCause;
            this.build.invalidatedKey = ref.invalidatedKey;
            this.build.invalidationKeys = ref.invalidationKeys;
            this.build.storeTimestampMillis = ref.storeTimestampMillis;
            this.build.value = ref.value;
        }

        public Builder withType(Type type) {
            this.build.type = type;
            return this;
        }

        public Builder withValue(Object value) {
            this.build.value = value;
            return this;
        }

        public Builder withErrorCause(Exception errorCause) {
            this.build.errorCause = errorCause;
            return this;
        }

        public Builder withInvalidationKeys(String[] invalidationKeys) {
            this.build.invalidationKeys = invalidationKeys;
            return this;
        }

        public Builder withInvalidatedKey(String invalidatedKey) {
            this.build.invalidatedKey = invalidatedKey;
            return this;
        }

        public Builder withStoreTimestampMillis(long storeTimestampMillis) {
            this.build.storeTimestampMillis = storeTimestampMillis;
            return this;
        }

        public CacheGetResult build() {
            return this.build;
        }
    }

    public static enum Type {
        HIT,
        MISS,
        EXPIRED,
        INVALIDATED,
        TIMEOUT,
        ERROR;

    }
}

