/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache;

import ar.com.siripo.arcache.ArcacheConfigurationGetInterface;
import ar.com.siripo.arcache.BackendKeyBuilder;
import ar.com.siripo.arcache.CacheInvalidationObject;
import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class InvalidateKeyTask
implements Future<Boolean> {
    protected final String key;
    protected final boolean hardInvalidation;
    protected final long invalidationWindowSecs;
    protected final ArcacheBackendClient backendClient;
    protected final BackendKeyBuilder keyBuilder;
    protected final ArcacheConfigurationGetInterface config;
    protected boolean cancelled = false;
    protected boolean done = false;
    protected Boolean valueToReturn;
    protected Future<Object> prevVersionGetFuture;
    protected Future<Boolean> setFuture;

    protected InvalidateKeyTask(String key, boolean hardInvalidation, long invalidationWindowSecs, ArcacheBackendClient backendClient, BackendKeyBuilder keyBuilder, ArcacheConfigurationGetInterface config) {
        this.key = key;
        this.hardInvalidation = hardInvalidation;
        this.invalidationWindowSecs = invalidationWindowSecs;
        this.backendClient = backendClient;
        this.keyBuilder = keyBuilder;
        this.config = config;
        this.start();
    }

    private void start() {
        this.prevVersionGetFuture = this.backendClient.asyncGet(this.keyBuilder.createInvalidationBackendKey(this.key));
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.done) {
            return false;
        }
        if (this.prevVersionGetFuture != null) {
            this.prevVersionGetFuture.cancel(mayInterruptIfRunning);
        }
        if (this.setFuture != null) {
            this.setFuture.cancel(mayInterruptIfRunning);
        }
        this.cancelled = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public Boolean get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.config.getDefaultOperationTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException toe) {
            throw new ExecutionException(toe);
        }
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutMillis = unit.toMillis(timeout);
        long startTimeMillis = System.currentTimeMillis();
        return this.doTask(startTimeMillis, timeoutMillis);
    }

    protected synchronized Boolean doTask(long startTimeMillis, long timeoutMillis) throws InterruptedException, ExecutionException, TimeoutException {
        long remainingTime;
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.done) {
            return this.valueToReturn;
        }
        CacheInvalidationObject lastValue = null;
        try {
            remainingTime = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
            if (remainingTime <= 0L) {
                throw new TimeoutException();
            }
            Object rawCachedObject = this.prevVersionGetFuture.get(remainingTime, TimeUnit.MILLISECONDS);
            if (rawCachedObject instanceof CacheInvalidationObject) {
                lastValue = (CacheInvalidationObject)rawCachedObject;
            }
        }
        catch (TimeoutException te) {
            throw te;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception ie) {
            // empty catch block
        }
        CacheInvalidationObject invalidationObject = new CacheInvalidationObject();
        invalidationObject.invalidationTimestamp = startTimeMillis / 1000L;
        invalidationObject.invalidationWindowSecs = this.invalidationWindowSecs;
        invalidationObject.isHardInvalidation = this.hardInvalidation;
        invalidationObject.lastHardInvalidationTimestamp = 0L;
        invalidationObject.lastSoftInvalidationTimestamp = 0L;
        if (lastValue != null) {
            invalidationObject.lastHardInvalidationTimestamp = lastValue.lastHardInvalidationTimestamp;
            invalidationObject.lastSoftInvalidationTimestamp = lastValue.lastSoftInvalidationTimestamp;
            if (lastValue.isHardInvalidation) {
                invalidationObject.lastHardInvalidationTimestamp = lastValue.invalidationTimestamp;
            } else {
                invalidationObject.lastSoftInvalidationTimestamp = lastValue.invalidationTimestamp;
            }
        }
        this.setFuture = this.backendClient.asyncSet(this.keyBuilder.createInvalidationBackendKey(this.key), (int)this.config.getDefaultStoredObjectRemovalTime(), (Object)invalidationObject);
        remainingTime = timeoutMillis - (System.currentTimeMillis() - startTimeMillis);
        if (remainingTime <= 0L) {
            throw new TimeoutException();
        }
        this.valueToReturn = this.setFuture.get(remainingTime, TimeUnit.MILLISECONDS);
        this.done = true;
        return this.valueToReturn;
    }
}

