/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache;

import ar.com.siripo.arcache.ArcacheClientInterface;
import ar.com.siripo.arcache.BackendKeyBuilder;
import ar.com.siripo.arcache.CacheGetResult;
import ar.com.siripo.arcache.CacheGetterTask;
import ar.com.siripo.arcache.ExpirableCacheObject;
import ar.com.siripo.arcache.InvalidateKeyTask;
import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import ar.com.siripo.arcache.util.DummyFuture;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ArcacheClient
implements ArcacheClientInterface,
BackendKeyBuilder {
    protected long defaultOperationTimeoutMillis = 500L;
    protected long timeMeasurementErrorSecs = 4L;
    protected long defaultInvalidationWindowSecs = 5L;
    protected boolean defaultHardInvalidation = true;
    protected String keyNamespace = null;
    protected String keyDelimiter = "|";
    protected String invalidationKeyPrefix = "InvKey";
    protected long defaultExpirationTimeSecs = 3600L;
    protected long defaultStoredObjectRemovalTimeSecs = 86400L;
    protected ArcacheBackendClient backendClient;
    protected Random randomGenerator = new Random();

    public ArcacheClient() {
    }

    protected ArcacheClient(ArcacheBackendClient backendClient) {
        this();
        this.setBackendClient(backendClient);
    }

    @Override
    public void setBackendClient(ArcacheBackendClient backendClient) {
        this.backendClient = backendClient;
    }

    @Override
    public ArcacheBackendClient getBackendClient() {
        return this.backendClient;
    }

    @Override
    public void setDefaultOperationTimeout(long timeoutMillis) {
        if (timeoutMillis <= 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultOperationTimeoutMillis = timeoutMillis;
    }

    @Override
    public long getDefaultOperationTimeout() {
        return this.defaultOperationTimeoutMillis;
    }

    @Override
    public void setTimeMeasurementError(long errorSecs) {
        if (errorSecs < 0L) {
            throw new IllegalArgumentException();
        }
        this.timeMeasurementErrorSecs = errorSecs;
    }

    @Override
    public long getTimeMeasurementError() {
        return this.timeMeasurementErrorSecs;
    }

    @Override
    public void setDefaultInvalidationWindow(long windowSecs) {
        if (windowSecs < 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultInvalidationWindowSecs = windowSecs;
    }

    @Override
    public long getDefaultInvalidationWindow() {
        return this.defaultInvalidationWindowSecs;
    }

    @Override
    public void setDefaultHardInvalidation(boolean hardInvalidation) {
        this.defaultHardInvalidation = hardInvalidation;
    }

    @Override
    public boolean getDefaultHardInvalidation() {
        return this.defaultHardInvalidation;
    }

    @Override
    public void setKeyNamespace(String namespace) {
        this.keyNamespace = namespace;
        if ("".equals(this.keyNamespace)) {
            this.keyNamespace = null;
        }
    }

    @Override
    public String getKeyNamespace() {
        return this.keyNamespace;
    }

    @Override
    public void setKeyDelimiter(String keyDelimiter) {
        if (keyDelimiter == null || keyDelimiter.equals("")) {
            throw new IllegalArgumentException("The key delimiter must be a non empty String");
        }
        this.keyDelimiter = keyDelimiter;
    }

    @Override
    public String getKeyDelimiter() {
        return this.keyDelimiter;
    }

    @Override
    public void setDefaultExpirationTime(long expirationTimeSecs) {
        if (expirationTimeSecs <= 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultExpirationTimeSecs = expirationTimeSecs;
    }

    @Override
    public long getDefaultExpirationTime() {
        return this.defaultExpirationTimeSecs;
    }

    @Override
    public void setDefaultStoredObjectRemovalTime(long removeTimeSecs) {
        if (removeTimeSecs <= 0L) {
            throw new IllegalArgumentException();
        }
        this.defaultStoredObjectRemovalTimeSecs = removeTimeSecs;
    }

    @Override
    public long getDefaultStoredObjectRemovalTime() {
        return this.defaultStoredObjectRemovalTimeSecs;
    }

    @Override
    public Object get(String key) throws TimeoutException, Exception {
        return this.get(key, this.defaultOperationTimeoutMillis);
    }

    @Override
    public Object get(String key, long timeoutMillis) throws TimeoutException, Exception {
        CacheGetResult cacheGetResult = this.getCacheObject(key, timeoutMillis);
        switch (cacheGetResult.type) {
            case HIT: {
                return cacheGetResult.value;
            }
            case ERROR: 
            case TIMEOUT: {
                throw cacheGetResult.cause;
            }
            case MISS: 
            case EXPIRED: 
            case INVALIDATED: {
                return null;
            }
        }
        throw new IllegalStateException("Unhandled cacheResultType: " + (Object)((Object)cacheGetResult.type));
    }

    @Override
    public CacheGetResult getCacheObject(String key) {
        return this.getCacheObject(key, this.defaultOperationTimeoutMillis);
    }

    @Override
    public CacheGetResult getCacheObject(String key, long timeoutMillis) {
        try {
            Future<CacheGetResult> getFuture = this.asyncGetCacheObject(key);
            CacheGetResult r = getFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (r == null) {
                throw new NullPointerException();
            }
            return r;
        }
        catch (TimeoutException tx) {
            CacheGetResult err = new CacheGetResult(CacheGetResult.Type.TIMEOUT, tx);
            return err;
        }
        catch (ExecutionException ee) {
            CacheGetResult err = ee.getCause() instanceof Exception ? new CacheGetResult(CacheGetResult.Type.ERROR, (Exception)ee.getCause()) : new CacheGetResult(CacheGetResult.Type.ERROR, ee);
            return err;
        }
        catch (Exception e) {
            CacheGetResult err = new CacheGetResult(CacheGetResult.Type.ERROR, e);
            return err;
        }
    }

    @Override
    public Future<CacheGetResult> asyncGetCacheObject(String key) {
        try {
            if (key == null || key.equals("")) {
                throw new IllegalArgumentException();
            }
            return this.buildCacheGetterTask(key);
        }
        catch (Exception e) {
            return DummyFuture.createWithException((Exception)e);
        }
    }

    protected Future<CacheGetResult> buildCacheGetterTask(String key) {
        return new CacheGetterTask(key, this.backendClient, this, this, this.randomGenerator);
    }

    @Override
    public void set(String key, Object value) throws TimeoutException, Exception {
        this.set(key, value, null);
    }

    @Override
    public void set(String key, Object value, String[] invalidationKeys) throws TimeoutException, Exception {
        Future<Boolean> future = this.asyncSet(key, value, invalidationKeys);
        try {
            future.get(this.defaultOperationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof Exception) {
                throw (Exception)ee.getCause();
            }
            throw ee;
        }
    }

    @Override
    public Future<Boolean> asyncSet(String key, Object value) {
        return this.asyncSet(key, value, null);
    }

    @Override
    public Future<Boolean> asyncSet(String key, Object value, String[] invalidationKeys) {
        try {
            if (key == null || key.equals("")) {
                throw new IllegalArgumentException();
            }
            ExpirableCacheObject expObj = new ExpirableCacheObject();
            expObj.timestamp = System.currentTimeMillis() / 1000L;
            expObj.value = value;
            expObj.invalidationKeys = invalidationKeys;
            expObj.maxTTLSecs = this.defaultExpirationTimeSecs;
            expObj.minTTLSecs = this.defaultExpirationTimeSecs / 2L;
            String backendKey = this.createBackendKey(key);
            return this.backendClient.asyncSet(backendKey, (int)this.defaultStoredObjectRemovalTimeSecs, (Object)expObj);
        }
        catch (Exception e) {
            return DummyFuture.createWithException((Exception)e);
        }
    }

    @Override
    public void invalidateKey(String key) throws TimeoutException, Exception {
        this.invalidateKey(key, this.defaultInvalidationWindowSecs);
    }

    @Override
    public void invalidateKey(String key, long invalidationWindowSecs) throws TimeoutException, Exception {
        this.invalidateKey(key, this.defaultHardInvalidation, invalidationWindowSecs);
    }

    @Override
    public void invalidateKey(String key, boolean hardInvalidation) throws TimeoutException, Exception {
        this.invalidateKey(key, hardInvalidation, this.defaultInvalidationWindowSecs);
    }

    @Override
    public void invalidateKey(String key, boolean hardInvalidation, long invalidationWindowSecs) throws TimeoutException, Exception {
        Future<Boolean> future = this.asyncInvalidateKey(key, hardInvalidation, invalidationWindowSecs);
        try {
            future.get(this.defaultOperationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof Exception) {
                throw (Exception)ee.getCause();
            }
            throw ee;
        }
    }

    @Override
    public Future<Boolean> asyncInvalidateKey(String key, boolean hardInvalidation, long invalidationWindowSecs) {
        try {
            if (invalidationWindowSecs < 0L) {
                throw new IllegalArgumentException();
            }
            if (key == null || key.equals("")) {
                throw new IllegalArgumentException();
            }
            return this.buildInvalidateKeyTask(key, hardInvalidation, invalidationWindowSecs);
        }
        catch (Exception e) {
            return DummyFuture.createWithException((Exception)e);
        }
    }

    protected Future<Boolean> buildInvalidateKeyTask(String key, boolean hardInvalidation, long invalidationWindowSecs) {
        return new InvalidateKeyTask(key, hardInvalidation, invalidationWindowSecs, this.backendClient, this, this);
    }

    @Override
    public String createBackendKey(String userKey) {
        if (this.keyNamespace == null) {
            return userKey;
        }
        return this.keyNamespace + this.keyDelimiter + userKey;
    }

    @Override
    public String createInvalidationBackendKey(String invalidationKey) {
        return this.createBackendKey(this.invalidationKeyPrefix + this.keyDelimiter + invalidationKey);
    }
}

