/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache.backend.speedup;

import ar.com.siripo.arcache.CacheInvalidationObjectType;
import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import ar.com.siripo.arcache.backend.inmemory.ArcacheInMemoryClient;
import ar.com.siripo.arcache.backend.speedup.ArcacheSpeedupBasicTracker;
import ar.com.siripo.arcache.backend.speedup.ArcacheSpeedupConfigurationGetInterface;
import ar.com.siripo.arcache.backend.speedup.ArcacheSpeedupConfigurationSetInterface;
import ar.com.siripo.arcache.backend.speedup.ArcacheSpeedupTracker;
import ar.com.siripo.arcache.backend.speedup.FutureBackendGetWrapper;
import ar.com.siripo.arcache.backend.speedup.RestoredSpeedupCacheObject;
import ar.com.siripo.arcache.backend.speedup.SpeedupCacheObject;
import ar.com.siripo.arcache.math.AdjustedExponentialProbabilityFunction;
import ar.com.siripo.arcache.math.ProbabilityFunction;
import ar.com.siripo.arcache.util.DummyFuture;
import java.util.Random;
import java.util.concurrent.Future;

public class ArcacheSpeedupClient
implements ArcacheBackendClient,
ArcacheSpeedupConfigurationSetInterface,
ArcacheSpeedupConfigurationGetInterface {
    protected ArcacheBackendClient backendClient;
    protected int invalidationKeysCacheSize = 0;
    protected int objectsCacheSize = 0;
    protected int missesCacheSize = 0;
    protected long invalidationKeysExpirationMillis = 0L;
    protected long objectsExpirationMillis = 0L;
    protected long missesExpirationMillis = 0L;
    protected boolean protectAgainstBackendFailures = true;
    protected long speedupCacheTTLMillis = 31536000000L;
    protected ProbabilityFunction expirationProbabilityFunction;
    protected ArcacheSpeedupTracker tracker = null;
    protected ArcacheInMemoryClient invalidationKeysCache = null;
    protected ArcacheInMemoryClient objectsCache = null;
    protected ArcacheInMemoryClient missesCache = null;
    protected boolean initialized = false;
    protected Random random;

    @Override
    public void setBackendClient(ArcacheBackendClient backendClient) {
        this.backendClient = backendClient;
    }

    @Override
    public void setInvalidationKeysCacheSize(int cacheSize) {
        this.validateSetCacheSize(cacheSize);
        this.invalidationKeysCacheSize = cacheSize;
    }

    @Override
    public void setObjectsCacheSize(int cacheSize) {
        this.validateSetCacheSize(cacheSize);
        this.objectsCacheSize = cacheSize;
    }

    @Override
    public void setMissesCacheSize(int cacheSize) {
        this.validateSetCacheSize(cacheSize);
        this.missesCacheSize = cacheSize;
    }

    @Override
    public void setInvalidationKeysExpirationMillis(long expirationMillis) {
        this.validateSetExpirationMillis(expirationMillis);
        this.invalidationKeysExpirationMillis = expirationMillis;
    }

    @Override
    public void setObjectsExpirationMillis(long expirationMillis) {
        this.validateSetExpirationMillis(expirationMillis);
        this.objectsExpirationMillis = expirationMillis;
    }

    @Override
    public void setMissesExpirationMillis(long expirationMillis) {
        this.validateSetExpirationMillis(expirationMillis);
        this.missesExpirationMillis = expirationMillis;
    }

    @Override
    public void setProtectAgainstBackendFailures(boolean protect) {
        this.protectAgainstBackendFailures = protect;
    }

    @Override
    public void setSpeedupCacheTTLMillis(long ttlMillis) {
        this.speedupCacheTTLMillis = ttlMillis;
    }

    @Override
    public void setExpirationProbabilityFunction(ProbabilityFunction probabilityFunction) {
        this.expirationProbabilityFunction = probabilityFunction;
    }

    @Override
    public void setTracker(ArcacheSpeedupTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public ArcacheBackendClient getBackendClient() {
        return this.backendClient;
    }

    @Override
    public int getInvalidationKeysCacheSize() {
        return this.invalidationKeysCacheSize;
    }

    @Override
    public int getObjectsCacheSize() {
        return this.objectsCacheSize;
    }

    @Override
    public int getMissesCacheSize() {
        return this.missesCacheSize;
    }

    @Override
    public long getInvalidationKeysExpirationMillis() {
        return this.invalidationKeysExpirationMillis;
    }

    @Override
    public long getObjectsExpirationMillis() {
        return this.objectsExpirationMillis;
    }

    @Override
    public long getMissesExpirationMillis() {
        return this.missesExpirationMillis;
    }

    @Override
    public boolean getProtectAgainstBackendFailures() {
        return this.protectAgainstBackendFailures;
    }

    @Override
    public long getSpeedupCacheTTLMillis() {
        return this.speedupCacheTTLMillis;
    }

    @Override
    public ProbabilityFunction getExpirationProbabilityFunction() {
        return this.expirationProbabilityFunction;
    }

    @Override
    public ArcacheSpeedupTracker getTracker() {
        return this.tracker;
    }

    public void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Already Initialized");
        }
        if (this.invalidationKeysCacheSize != 0 || this.invalidationKeysExpirationMillis != 0L) {
            if (this.invalidationKeysCacheSize == 0 || this.invalidationKeysExpirationMillis == 0L) {
                throw new IllegalArgumentException("InvalidationKeys Cache Policy is invalid");
            }
            this.invalidationKeysCache = new ArcacheInMemoryClient(this.invalidationKeysCacheSize);
        }
        if (this.objectsCacheSize != 0 || this.objectsExpirationMillis != 0L) {
            if (this.objectsCacheSize == 0 || this.objectsExpirationMillis == 0L) {
                throw new IllegalArgumentException("Objects Cache Policy is invalid");
            }
            this.objectsCache = new ArcacheInMemoryClient(this.objectsCacheSize);
        }
        if (this.missesCacheSize != 0 || this.missesExpirationMillis != 0L) {
            if (this.missesCacheSize == 0 || this.missesExpirationMillis == 0L) {
                throw new IllegalArgumentException("Misses Cache Policy is invalid");
            }
            this.missesCache = new ArcacheInMemoryClient(this.missesCacheSize);
        }
        if (this.objectsCache == null && this.invalidationKeysCache == null && this.missesCache == null) {
            throw new IllegalArgumentException("it was not configured neither invalidationKeys nor objects nor misses policy");
        }
        if (this.backendClient == null) {
            throw new IllegalArgumentException("Backend Client was not configured");
        }
        if (this.expirationProbabilityFunction == null) {
            this.expirationProbabilityFunction = new AdjustedExponentialProbabilityFunction(0.0, 11.0);
        }
        this.random = new Random();
        if (this.tracker == null) {
            this.tracker = new ArcacheSpeedupBasicTracker();
        }
        this.initialized = true;
    }

    public void clear() {
        if (this.objectsCache != null) {
            this.objectsCache.clear();
        }
        if (this.invalidationKeysCache != null) {
            this.invalidationKeysCache.clear();
        }
        if (this.missesCache != null) {
            this.missesCache.clear();
        }
    }

    protected void validateSetCacheSize(int cachesize) {
        if (cachesize < 0) {
            throw new IllegalArgumentException("Invalid cache size");
        }
    }

    protected void validateSetExpirationMillis(long expirationMillis) {
        if (expirationMillis <= 0L) {
            throw new IllegalArgumentException("Invalid expiration millis");
        }
    }

    public Future<Boolean> asyncSet(String key, long ttlMillis, Object value) {
        try {
            this.storeSpeedupCache(key, value);
        }
        catch (Exception e) {
            this.tracker.trackException(key, e);
        }
        return this.backendClient.asyncSet(key, ttlMillis, value);
    }

    protected ArcacheInMemoryClient storeSpeedupCache(String key, Object value) {
        ArcacheInMemoryClient destination = null;
        if (value == null) {
            if (this.invalidationKeysCache != null) {
                this.invalidationKeysCache.remove(key);
            }
            if (this.objectsCache != null) {
                this.objectsCache.remove(key);
            }
            if (this.missesCache != null) {
                destination = this.missesCache;
            }
        } else {
            if (value instanceof CacheInvalidationObjectType) {
                if (this.invalidationKeysCache != null) {
                    destination = this.invalidationKeysCache;
                }
                if (this.objectsCache != null) {
                    this.objectsCache.remove(key);
                }
            } else {
                if (this.objectsCache != null) {
                    destination = this.objectsCache;
                }
                if (this.invalidationKeysCache != null) {
                    this.invalidationKeysCache.remove(key);
                }
            }
            if (this.missesCache != null) {
                this.missesCache.remove(key);
            }
        }
        if (destination != null) {
            destination.set(key, this.speedupCacheTTLMillis, (Object)this.createSpeedupCacheObject(value));
        }
        return destination;
    }

    protected SpeedupCacheObject createSpeedupCacheObject(Object value) {
        SpeedupCacheObject sco = new SpeedupCacheObject();
        sco.storeTimeMillis = System.currentTimeMillis();
        sco.cachedObject = value;
        return sco;
    }

    public Future<Object> asyncGet(String key) {
        try {
            RestoredSpeedupCacheObject rsco = this.restoreObjectFromAnySpeedupCache(key);
            if (rsco != null && !rsco.expired) {
                if (rsco.fromCache == this.invalidationKeysCache) {
                    this.tracker.trackInvalidationKeysCacheHit(key);
                }
                if (rsco.fromCache == this.objectsCache) {
                    this.tracker.trackObjectsCacheHit(key);
                }
                if (rsco.fromCache == this.missesCache) {
                    this.tracker.trackMissesCacheHit(key);
                }
                return new DummyFuture(rsco.speedupCacheObject.cachedObject);
            }
        }
        catch (Exception e) {
            this.tracker.trackException(key, e);
        }
        Future backendFuture = this.backendClient.asyncGet(key);
        try {
            return this.createFutureBackendGetWrapper(backendFuture, key);
        }
        catch (Exception e) {
            this.tracker.trackException(key, e);
            return backendFuture;
        }
    }

    protected FutureBackendGetWrapper createFutureBackendGetWrapper(Future<Object> backendFuture, String key) {
        return new FutureBackendGetWrapper(this, backendFuture, key, this.protectAgainstBackendFailures, this.tracker);
    }

    protected RestoredSpeedupCacheObject restoreObjectFromAnySpeedupCache(String key) {
        RestoredSpeedupCacheObject rsco = null;
        if (this.invalidationKeysCache != null) {
            rsco = this.restoreObjectFromSpeedupCache(key, this.invalidationKeysCache, this.invalidationKeysExpirationMillis);
        }
        if (rsco == null && this.objectsCache != null) {
            rsco = this.restoreObjectFromSpeedupCache(key, this.objectsCache, this.objectsExpirationMillis);
        }
        if (rsco == null && this.missesCache != null) {
            rsco = this.restoreObjectFromSpeedupCache(key, this.missesCache, this.missesExpirationMillis);
        }
        return rsco;
    }

    protected RestoredSpeedupCacheObject restoreObjectFromSpeedupCache(String key, ArcacheInMemoryClient speedupCache, long timeoutMillis) {
        SpeedupCacheObject sco = (SpeedupCacheObject)speedupCache.get(key);
        if (sco == null) {
            return null;
        }
        RestoredSpeedupCacheObject rsco = new RestoredSpeedupCacheObject();
        rsco.speedupCacheObject = sco;
        double age = System.currentTimeMillis() - sco.storeTimeMillis;
        double normalizedTimeInsideWindow = age / (double)timeoutMillis;
        double invalidationProbability = this.expirationProbabilityFunction.getProbability(normalizedTimeInsideWindow);
        if (invalidationProbability >= 1.0 || invalidationProbability > this.random.nextDouble()) {
            rsco.expired = true;
        }
        rsco.fromCache = speedupCache;
        return rsco;
    }
}

