/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache.backend.inmemory;

import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import ar.com.siripo.arcache.backend.inmemory.MemoryObject;
import ar.com.siripo.arcache.util.DummyFuture;
import ar.com.siripo.arcache.util.ObjectSerializer;
import java.util.concurrent.Future;
import org.apache.commons.collections4.map.LRUMap;

public class ArcacheInMemoryClient
implements ArcacheBackendClient {
    protected LRUMap<String, MemoryObject> storage;
    protected ObjectSerializer objectSerializer;
    protected int lruMaxSize = 1000;
    protected boolean cacheIsolation;

    public ArcacheInMemoryClient() {
        this(1000, false);
    }

    public ArcacheInMemoryClient(int maxSize) {
        this(maxSize, false);
    }

    public ArcacheInMemoryClient(int maxSize, boolean cacheIsolation) {
        this.lruMaxSize = maxSize;
        this.cacheIsolation = cacheIsolation;
        this.initialize();
    }

    private void initialize() {
        this.storage = new LRUMap(this.lruMaxSize);
        if (this.cacheIsolation) {
            this.objectSerializer = new ObjectSerializer();
        }
    }

    public Future<Boolean> asyncSet(String key, long ttlMillis, Object value) {
        return new DummyFuture((Object)this.set(key, ttlMillis, value));
    }

    public Future<Object> asyncGet(String key) {
        return new DummyFuture(this.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        MemoryObject inMemoryObject;
        LRUMap<String, MemoryObject> lRUMap = this.storage;
        synchronized (lRUMap) {
            inMemoryObject = (MemoryObject)this.storage.get((Object)key);
        }
        Object obj = null;
        if (inMemoryObject != null && inMemoryObject.expirationTimeMillis > System.currentTimeMillis()) {
            obj = this.cacheIsolation ? this.objectSerializer.deserialize((byte[])inMemoryObject.data) : inMemoryObject.data;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String key, long ttlMillis, Object value) {
        MemoryObject inMemoryObject = new MemoryObject();
        inMemoryObject.expirationTimeMillis = System.currentTimeMillis() + ttlMillis;
        inMemoryObject.data = this.cacheIsolation ? (Object)this.objectSerializer.serializeToByteArray(value) : value;
        LRUMap<String, MemoryObject> lRUMap = this.storage;
        synchronized (lRUMap) {
            this.storage.put((Object)key, (Object)inMemoryObject);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        LRUMap<String, MemoryObject> lRUMap = this.storage;
        synchronized (lRUMap) {
            this.storage.remove((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRUMap<String, MemoryObject> lRUMap = this.storage;
        synchronized (lRUMap) {
            this.storage.clear();
        }
    }
}

