/*
 * Decompiled with CFR 0.152.
 */
package ar.com.siripo.arcache.backend.inmemory;

import ar.com.siripo.arcache.backend.ArcacheBackendClient;
import ar.com.siripo.arcache.backend.inmemory.MemoryObject;
import ar.com.siripo.arcache.util.DummyFuture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

public class ArcacheInMemoryClient
implements ArcacheBackendClient {
    protected ConcurrentHashMap<String, MemoryObject> storage;

    public ArcacheInMemoryClient() {
        this.initialize();
    }

    private void initialize() {
        this.storage = new ConcurrentHashMap();
    }

    public Future<Boolean> asyncSet(String key, int ttlSeconds, Object value) {
        return new DummyFuture((Object)this.set(key, ttlSeconds, value));
    }

    public Future<Object> asyncGet(String key) {
        return new DummyFuture(this.get(key));
    }

    public Object get(String key) {
        MemoryObject inMemoryObject = this.storage.get(key);
        Object obj = null;
        if (inMemoryObject != null && inMemoryObject.expirationTime > System.currentTimeMillis()) {
            obj = this.deserialize(inMemoryObject.data);
        }
        return obj;
    }

    public boolean set(String key, int ttlSeconds, Object value) {
        MemoryObject inMemoryObject = new MemoryObject();
        inMemoryObject.expirationTime = System.currentTimeMillis() + (long)(ttlSeconds * 1000);
        inMemoryObject.data = this.serialize(value);
        this.storage.put(key, inMemoryObject);
        return true;
    }

    public void clear() {
        this.storage.clear();
    }

    protected byte[] serialize(Object o) {
        if (o == null) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] rv = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(o);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        }
        finally {
            try {
                os.close();
            }
            catch (Exception exception) {}
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserialize(byte[] in) {
        Object rv = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            if (in != null) {
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
                is.close();
                bis.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                bis.close();
            }
            catch (Exception exception) {}
        }
        return rv;
    }
}

