/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.output;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.layout.ListLayoutManager;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;

public class FormatInfoRegistry {
    public static final String EXPORTER_CLASS_XLS = "net.sf.jasperreports.engine.export.JRXlsExporter";
    public static final String EXPORTER_CLASS_CSV = "net.sf.jasperreports.engine.export.JRCsvExporter";
    public static final String EXPORTER_CLASS_HTML = "net.sf.jasperreports.engine.export.JRHtmlExporter";
    public static final String EXPORTER_CLASS_PDF = "net.sf.jasperreports.engine.export.JRPdfExporter";
    public static final String EXPORTER_CLASS_XML = "net.sf.jasperreports.engine.export.JRXmlExporter";
    public static final String EXPORTER_CLASS_RTF = "net.sf.jasperreports.engine.export.JRRtfExporter";
    private static final Map<String, FormatInfo> FORMAT_INFO = new HashMap<String, FormatInfo>();
    private static final FormatInfoRegistry INSTANCE;

    public String getContentType(String _format) {
        FormatInfoRegistry.checkFormat(_format);
        return FORMAT_INFO.get(_format).getContentType();
    }

    public JRExporter getExporter(String _format) {
        FormatInfoRegistry.checkFormat(_format);
        JRExporter exporter = FORMAT_INFO.get(_format).getExporterInstance();
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        return exporter;
    }

    public LayoutManager getLayoutManager(String _format) {
        FormatInfoRegistry.checkFormat(_format);
        return FORMAT_INFO.get(_format).getLayoutManagerInstance();
    }

    private static void checkFormat(String _format) {
        if (!FORMAT_INFO.containsKey(_format)) {
            throw new IllegalArgumentException("Unsupported format: " + _format);
        }
    }

    public static FormatInfoRegistry getInstance() {
        return INSTANCE;
    }

    static {
        FORMAT_INFO.put("CSV", new FormatInfo("text/plain", EXPORTER_CLASS_CSV, ClassicLayoutManager.class.getName()));
        FORMAT_INFO.put("HTML", new FormatInfo("text/html", EXPORTER_CLASS_HTML, ClassicLayoutManager.class.getName()));
        FORMAT_INFO.put("PDF", new FormatInfo("application/pdf", EXPORTER_CLASS_PDF, ClassicLayoutManager.class.getName()));
        FORMAT_INFO.put("XLS", new FormatInfo("application/vnd.ms-excel", EXPORTER_CLASS_XLS, ListLayoutManager.class.getName()));
        FORMAT_INFO.put("XML", new FormatInfo("text/xml", EXPORTER_CLASS_XML, ClassicLayoutManager.class.getName()));
        FORMAT_INFO.put("RTF", new FormatInfo("application/rtf", EXPORTER_CLASS_RTF, ClassicLayoutManager.class.getName()));
        INSTANCE = new FormatInfoRegistry();
    }

    private static class FormatInfo {
        private String contentType;
        private String exporterClass;
        private String layoutManagerClass;

        private FormatInfo(String _contentType, String _exporterClass, String _layoutManagerClass) {
            this.contentType = _contentType;
            this.exporterClass = _exporterClass;
            this.layoutManagerClass = _layoutManagerClass;
        }

        public String getContentType() {
            return this.contentType;
        }

        public JRExporter getExporterInstance() {
            try {
                return (JRExporter)Class.forName(this.exporterClass).newInstance();
            }
            catch (Exception ex) {
                return null;
            }
        }

        public LayoutManager getLayoutManagerInstance() {
            try {
                return (LayoutManager)Class.forName(this.layoutManagerClass).newInstance();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

