/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.entities.columns;

import ar.com.fdvs.dj.domain.ColumnOperation;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.util.Iterator;
import java.util.List;

public class OperationColumn
extends AbstractColumn {
    private static final long serialVersionUID = 10000L;
    private ColumnOperation columnOperation;
    private List<SimpleColumn> columns;

    public ColumnOperation getColumnOperation() {
        return this.columnOperation;
    }

    public void setColumnOperation(ColumnOperation columnOperation) {
        this.columnOperation = columnOperation;
    }

    public List<SimpleColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<SimpleColumn> columns) {
        this.columns = columns;
    }

    @Override
    public String getTextForExpression() {
        StringBuilder exp = new StringBuilder();
        Iterator<SimpleColumn> iter = this.columns.iterator();
        while (iter.hasNext()) {
            SimpleColumn col = iter.next();
            exp.append(" ((java.lang.Number)$F{").append(col.getColumnProperty().getProperty()).append("}).doubleValue() ");
            if (!iter.hasNext()) continue;
            exp.append(this.columnOperation.getValue());
        }
        return "new java.lang.Double(" + exp.toString() + ")";
    }

    @Override
    public String getValueClassNameForExpression() {
        return "java.lang.Number";
    }

    @Override
    public String getGroupVariableName(String type, String columnToGroupByProperty) {
        return "variable-" + type + "_" + columnToGroupByProperty + "_" + this.columnOperation.getValue();
    }

    @Override
    public String getVariableClassName(DJCalculation op) {
        if (op == DJCalculation.COUNT || op == DJCalculation.DISTINCT_COUNT) {
            return Long.class.getName();
        }
        return Number.class.getName();
    }

    @Override
    public String getInitialExpression(DJCalculation op) {
        return "new java.lang.Long(\"0\")";
    }
}

