/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.domain.chart.builder;

import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.builder.DJScatterChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.hyperlink.LiteralExpression;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.view.JasperViewer;

public class ScatterChartBuilderTest
extends BaseDjReportTest {
    private DynamicReportBuilder drb;
    private JRDesignChart chart;

    protected void setUp() throws Exception {
        super.setUp();
        this.drb = new DynamicReportBuilder();
        Style headerStyle = new Style();
        headerStyle.setFont(Font.VERDANA_MEDIUM_BOLD);
        headerStyle.setBorderBottom(Border.PEN_2_POINT());
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setBackgroundColor(Color.DARK_GRAY);
        headerStyle.setTextColor(Color.WHITE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        this.drb.setDefaultStyles(null, null, headerStyle, null);
        AbstractColumn columnCode = ColumnBuilder.getNew().setColumnProperty("id", Long.class.getName()).setTitle("ID").setWidth(new Integer(40).intValue()).build();
        AbstractColumn columnaQuantity = ColumnBuilder.getNew().setColumnProperty("quantity", Long.class.getName()).setTitle("Quantity").setWidth(new Integer(80).intValue()).build();
        AbstractColumn columnAmount = ColumnBuilder.getNew().setColumnProperty("amount", Float.class.getName()).setTitle("Amount").setWidth(new Integer(90).intValue()).build();
        this.drb.addColumn(columnCode);
        this.drb.addColumn(columnaQuantity);
        this.drb.addColumn(columnAmount);
        this.drb.setUseFullPageWidth(true);
        DJAxisFormat xAxisFormat = new DJAxisFormat("x");
        xAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        xAxisFormat.setLabelColor(Color.DARK_GRAY);
        xAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        xAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        xAxisFormat.setTickLabelMask("#,###.#");
        xAxisFormat.setLineColor(Color.DARK_GRAY);
        DJAxisFormat yAxisFormat = new DJAxisFormat("y");
        yAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        yAxisFormat.setLabelColor(Color.DARK_GRAY);
        yAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        yAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        yAxisFormat.setTickLabelMask("#,##0.0");
        yAxisFormat.setLineColor(Color.DARK_GRAY);
        DJChart djChart = new DJScatterChartBuilder().setX(20).setY(10).setWidth(500).setHeight(250).setCentered(false).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)1).setTitle("title").setTitleColor(Color.DARK_GRAY).setTitleFont(Font.ARIAL_BIG_BOLD).setSubtitle("subtitle").setSubtitleColor(Color.DARK_GRAY).setSubtitleFont(Font.COURIER_NEW_BIG_BOLD).setLegendColor(Color.DARK_GRAY).setLegendFont(Font.COURIER_NEW_MEDIUM_BOLD).setLegendBackgroundColor(Color.WHITE).setLegendPosition(DJChartOptions.EDGE_BOTTOM).setTitlePosition(DJChartOptions.EDGE_TOP).setLineStyle(DJChartOptions.LINE_STYLE_DOTTED).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setXValue((PropertyColumn)columnCode).addSerie(columnaQuantity, "quant.").addSerie(columnAmount).setShowShapes(true).setShowLines(false).setXAxisFormat(xAxisFormat).setYAxisFormat(yAxisFormat).build();
        this.drb.addChart(djChart);
        DJHyperLink djlink = new DJHyperLink();
        djlink.setExpression(new StringExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return "http://thisIsAURL?count=" + variables.get("REPORT_COUNT");
            }
        });
        djlink.setTooltip((StringExpression)new LiteralExpression("I'm a literal tootltip"));
        djChart.setLink(djlink);
        HashMap<AbstractColumn, JRDesignVariable> vars = new HashMap<AbstractColumn, JRDesignVariable>();
        vars.put(columnaQuantity, new JRDesignVariable());
        vars.put(columnAmount, new JRDesignVariable());
        JRDesignGroup group = new JRDesignGroup();
        this.chart = djChart.transform(new DynamicJasperDesign(), "", group, group, vars, 0);
    }

    public void testChart() {
        ScatterChartBuilderTest.assertEquals((int)20, (int)this.chart.getX());
        ScatterChartBuilderTest.assertEquals((int)10, (int)this.chart.getY());
        ScatterChartBuilderTest.assertEquals((int)500, (int)this.chart.getWidth());
        ScatterChartBuilderTest.assertEquals((int)250, (int)this.chart.getHeight());
        ScatterChartBuilderTest.assertEquals((Object)Color.LIGHT_GRAY, (Object)this.chart.getBackcolor());
        ScatterChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)this.chart.getShowLegend());
        ScatterChartBuilderTest.assertNotNull((Object)this.chart.getTitleExpression().getText());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getTitleColor());
        this.testFont(Font.ARIAL_BIG_BOLD, this.chart.getTitleFont());
        ScatterChartBuilderTest.assertNotNull((Object)this.chart.getSubtitleExpression().getText());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getSubtitleColor());
        this.testFont(Font.COURIER_NEW_BIG_BOLD, this.chart.getSubtitleFont());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLegendColor());
        this.testFont(Font.COURIER_NEW_MEDIUM_BOLD, this.chart.getLegendFont());
        ScatterChartBuilderTest.assertEquals((Object)Color.WHITE, (Object)this.chart.getLegendBackgroundColor());
        ScatterChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_BOTTOM), (Object)this.chart.getLegendPositionValue().getValueByte());
        ScatterChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_TOP), (Object)this.chart.getTitlePositionValue().getValueByte());
        ScatterChartBuilderTest.assertEquals((Object)LineStyleEnum.getByValue((Byte)new Byte(DJChartOptions.LINE_STYLE_DOTTED)), (Object)this.chart.getLineBox().getPen().getLineStyleValue());
        ScatterChartBuilderTest.assertEquals((Object)Float.valueOf(1.0f), (Object)this.chart.getLineBox().getPen().getLineWidth());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLineBox().getPen().getLineColor());
        ScatterChartBuilderTest.assertEquals((Object)new Integer(5), (Object)this.chart.getLineBox().getPadding());
    }

    public void testDataset() {
        JRDesignXyDataset dataset = (JRDesignXyDataset)this.chart.getDataset();
        ScatterChartBuilderTest.assertEquals((int)2, (int)dataset.getSeriesList().size());
        ScatterChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getLabelExpression().getText());
        ScatterChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getSeriesExpression().getText());
    }

    public void testPlot() {
        JRDesignScatterPlot plot = (JRDesignScatterPlot)this.chart.getPlot();
        ScatterChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)plot.getShowShapes());
        ScatterChartBuilderTest.assertEquals((Object)Boolean.FALSE, (Object)plot.getShowLines());
        ScatterChartBuilderTest.assertNotNull((Object)plot.getXAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getXAxisLabelFont());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getXAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getXAxisTickLabelFont());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getXAxisTickLabelColor());
        ScatterChartBuilderTest.assertEquals((String)"#,###.#", (String)plot.getXAxisTickLabelMask());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getXAxisLineColor());
        ScatterChartBuilderTest.assertNotNull((Object)plot.getYAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getYAxisLabelFont());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getYAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getYAxisTickLabelFont());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getYAxisTickLabelColor());
        ScatterChartBuilderTest.assertEquals((String)"#,##0.0", (String)plot.getYAxisTickLabelMask());
        ScatterChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getYAxisLineColor());
    }

    @Override
    public DynamicReport buildReport() throws Exception {
        return this.drb.build();
    }

    private void testFont(Font djFont, JRFont jrFont) {
        ScatterChartBuilderTest.assertEquals((String)djFont.getFontName(), (String)jrFont.getFontName());
        ScatterChartBuilderTest.assertEquals((Object)Float.valueOf(djFont.getFontSize()), (Object)Float.valueOf(jrFont.getFontsize()));
        ScatterChartBuilderTest.assertEquals((boolean)djFont.isBold(), (boolean)jrFont.isBold());
        ScatterChartBuilderTest.assertEquals((boolean)djFont.isItalic(), (boolean)jrFont.isItalic());
    }

    public static void main(String[] args) throws Exception {
        ScatterChartBuilderTest test = new ScatterChartBuilderTest();
        test.setUp();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

