/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.domain.chart.builder;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.builder.DJAreaChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.hyperlink.LiteralExpression;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.view.JasperViewer;

public class AreaChartBuilderTest
extends BaseDjReportTest {
    private DynamicReportBuilder drb;
    private JRDesignChart chart;

    protected void setUp() throws Exception {
        super.setUp();
        this.drb = new DynamicReportBuilder();
        Style headerStyle = new Style();
        headerStyle.setFont(Font.VERDANA_MEDIUM_BOLD);
        headerStyle.setBorderBottom(Border.PEN_2_POINT());
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setBackgroundColor(Color.DARK_GRAY);
        headerStyle.setTextColor(Color.WHITE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        this.drb.setDefaultStyles(null, null, headerStyle, null);
        AbstractColumn columnState = ColumnBuilder.getNew().setColumnProperty("state", String.class.getName()).setTitle("State").setWidth(new Integer(85).intValue()).build();
        AbstractColumn columnBranch = ColumnBuilder.getNew().setColumnProperty("branch", String.class.getName()).setTitle("Branch").setWidth(new Integer(85).intValue()).build();
        AbstractColumn columnaQuantity = ColumnBuilder.getNew().setColumnProperty("quantity", Long.class.getName()).setTitle("Quantity").setWidth(new Integer(80).intValue()).build();
        AbstractColumn columnAmount = ColumnBuilder.getNew().setColumnProperty("amount", Float.class.getName()).setTitle("Amount").setWidth(new Integer(90).intValue()).build();
        this.drb.addColumn(columnState);
        this.drb.addColumn(columnBranch);
        this.drb.addColumn(columnaQuantity);
        this.drb.addColumn(columnAmount);
        GroupBuilder gb1 = new GroupBuilder();
        DJGroup g1 = gb1.setCriteriaColumn((PropertyColumn)columnState).addFooterVariable(columnAmount, DJCalculation.SUM).addFooterVariable(columnaQuantity, DJCalculation.SUM).addVariable("group_state_name", columnState, DJCalculation.FIRST).setGroupLayout(GroupLayout.DEFAULT).build();
        this.drb.addGroup(g1);
        this.drb.setUseFullPageWidth(true);
        DJAxisFormat categoryAxisFormat = new DJAxisFormat("category");
        categoryAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        categoryAxisFormat.setLabelColor(Color.DARK_GRAY);
        categoryAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        categoryAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        categoryAxisFormat.setTickLabelMask("");
        categoryAxisFormat.setLineColor(Color.DARK_GRAY);
        DJAxisFormat valueAxisFormat = new DJAxisFormat("value");
        valueAxisFormat.setLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelFont(Font.ARIAL_SMALL);
        valueAxisFormat.setTickLabelColor(Color.DARK_GRAY);
        valueAxisFormat.setTickLabelMask("#,##0.0");
        valueAxisFormat.setLineColor(Color.DARK_GRAY);
        DJChart djChart = new DJAreaChartBuilder().setX(20).setY(10).setWidth(500).setHeight(250).setCentered(false).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)1).setTitle(new StringExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return variables.get("group_state_name");
            }
        }).setTitleColor(Color.DARK_GRAY).setTitleFont(Font.ARIAL_BIG_BOLD).setSubtitle("subtitle").setSubtitleColor(Color.DARK_GRAY).setSubtitleFont(Font.COURIER_NEW_BIG_BOLD).setLegendColor(Color.DARK_GRAY).setLegendFont(Font.COURIER_NEW_MEDIUM_BOLD).setLegendBackgroundColor(Color.WHITE).setLegendPosition(DJChartOptions.EDGE_BOTTOM).setTitlePosition(DJChartOptions.EDGE_TOP).setLineStyle(DJChartOptions.LINE_STYLE_DOTTED).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setCategory((PropertyColumn)columnBranch).addSerie(columnAmount).addSerie(columnaQuantity, "quant.").setCategoryAxisFormat(categoryAxisFormat).setValueAxisFormat(valueAxisFormat).build();
        this.drb.addChart(djChart);
        DJHyperLink djlink = new DJHyperLink();
        djlink.setExpression(new StringExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                return "http://thisIsAURL?count=" + variables.get("REPORT_COUNT");
            }
        });
        djlink.setTooltip((StringExpression)new LiteralExpression("I'm a literal tootltip"));
        djChart.setLink(djlink);
        HashMap<AbstractColumn, JRDesignVariable> vars = new HashMap<AbstractColumn, JRDesignVariable>();
        vars.put(columnaQuantity, new JRDesignVariable());
        vars.put(columnAmount, new JRDesignVariable());
        JRDesignGroup group = new JRDesignGroup();
        this.chart = djChart.transform(new DynamicJasperDesign(), "", group, group, vars, 0);
    }

    public void testChart() {
        AreaChartBuilderTest.assertEquals((int)20, (int)this.chart.getX());
        AreaChartBuilderTest.assertEquals((int)10, (int)this.chart.getY());
        AreaChartBuilderTest.assertEquals((int)500, (int)this.chart.getWidth());
        AreaChartBuilderTest.assertEquals((int)250, (int)this.chart.getHeight());
        AreaChartBuilderTest.assertEquals((Object)Color.LIGHT_GRAY, (Object)this.chart.getBackcolor());
        AreaChartBuilderTest.assertEquals((Object)Boolean.TRUE, (Object)this.chart.getShowLegend());
        AreaChartBuilderTest.assertNotNull((Object)this.chart.getTitleExpression().getText());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getTitleColor());
        this.testFont(Font.ARIAL_BIG_BOLD, this.chart.getTitleFont());
        AreaChartBuilderTest.assertNotNull((Object)this.chart.getSubtitleExpression().getText());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getSubtitleColor());
        this.testFont(Font.COURIER_NEW_BIG_BOLD, this.chart.getSubtitleFont());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLegendColor());
        this.testFont(Font.COURIER_NEW_MEDIUM_BOLD, this.chart.getLegendFont());
        AreaChartBuilderTest.assertEquals((Object)Color.WHITE, (Object)this.chart.getLegendBackgroundColor());
        AreaChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_BOTTOM), (Object)this.chart.getLegendPositionValue().getValueByte());
        AreaChartBuilderTest.assertEquals((Object)new Byte(DJChartOptions.EDGE_TOP), (Object)this.chart.getTitlePositionValue().getValueByte());
        AreaChartBuilderTest.assertEquals((Object)LineStyleEnum.getByValue((Byte)new Byte(DJChartOptions.LINE_STYLE_DOTTED)), (Object)this.chart.getLineBox().getPen().getLineStyleValue());
        AreaChartBuilderTest.assertEquals((Object)Float.valueOf(1.0f), (Object)this.chart.getLineBox().getPen().getLineWidth());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)this.chart.getLineBox().getPen().getLineColor());
        AreaChartBuilderTest.assertEquals((Object)new Integer(5), (Object)this.chart.getLineBox().getPadding());
    }

    public void testDataset() {
        JRDesignCategoryDataset dataset = (JRDesignCategoryDataset)this.chart.getDataset();
        AreaChartBuilderTest.assertEquals((int)2, (int)dataset.getSeriesList().size());
        AreaChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getLabelExpression().getText());
        AreaChartBuilderTest.assertNotNull((Object)dataset.getSeries()[0].getSeriesExpression().getText());
    }

    public void testPlot() {
        JRDesignAreaPlot plot = (JRDesignAreaPlot)this.chart.getPlot();
        AreaChartBuilderTest.assertNotNull((Object)plot.getCategoryAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getCategoryAxisLabelFont());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getCategoryAxisTickLabelFont());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisTickLabelColor());
        AreaChartBuilderTest.assertEquals((String)"", (String)plot.getCategoryAxisTickLabelMask());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getCategoryAxisLineColor());
        AreaChartBuilderTest.assertNotNull((Object)plot.getValueAxisLabelExpression().getText());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisLabelFont());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLabelColor());
        this.testFont(Font.ARIAL_SMALL, plot.getValueAxisTickLabelFont());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisTickLabelColor());
        AreaChartBuilderTest.assertEquals((String)"#,##0.0", (String)plot.getValueAxisTickLabelMask());
        AreaChartBuilderTest.assertEquals((Object)Color.DARK_GRAY, (Object)plot.getValueAxisLineColor());
    }

    @Override
    public DynamicReport buildReport() throws Exception {
        return this.drb.build();
    }

    private void testFont(Font djFont, JRFont jrFont) {
        AreaChartBuilderTest.assertEquals((String)djFont.getFontName(), (String)jrFont.getFontName());
        AreaChartBuilderTest.assertEquals((Object)Float.valueOf(djFont.getFontSize()), (Object)Float.valueOf(jrFont.getFontsize()));
        AreaChartBuilderTest.assertEquals((boolean)djFont.isBold(), (boolean)jrFont.isBold());
        AreaChartBuilderTest.assertEquals((boolean)djFont.isItalic(), (boolean)jrFont.isItalic());
    }

    public static void main(String[] args) throws Exception {
        AreaChartBuilderTest test = new AreaChartBuilderTest();
        test.setUp();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

