/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.crosstab;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.CrosstabBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import ar.com.fdvs.dj.test.TestRepositoryProducts;
import ar.com.fdvs.dj.util.SortUtils;
import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

public class CrosstabReportWithNullValuesTest
extends BaseDjReportTest {
    private Style totalColHeaderStyle;
    private Style totalRowHeaderStyle;
    private Style colHeaderStyle;
    private Style rowHeaderStyle;
    private Style mainHeaderStyle;
    private Style totalColStyle;
    private Style totalRowStyle;
    private Style measureStyle2;
    private Style titleStyle;

    @Override
    public DynamicReport buildReport() throws Exception {
        this.initStyles();
        FastReportBuilder drb = new FastReportBuilder();
        drb.setTitle("November " + this.getYear() + " sales report").setSubtitle("This report was generated at " + new Date()).setPageSizeAndOrientation(Page.Page_A4_Landscape()).setPrintColumnNames(false).setUseFullPageWidth(true).setDefaultStyles(this.titleStyle, null, null, null);
        DJCrosstab djcross = new CrosstabBuilder().setHeight(200).setWidth(500).setHeaderStyle(this.mainHeaderStyle).setDatasource("sr", 0, 0).setUseFullWidth(true).setColorScheme(6).setAutomaticTitle(true).setCellBorder(Border.PEN_1_POINT()).addRow("Product Line", "productLine", String.class.getName(), true).addColumn("State", "state", String.class.getName(), true).addRow("Branch", "branch", String.class.getName(), true).addColumn("Item", "item", String.class.getName(), true).addMeasure("quantity", Long.class.getName(), DJCalculation.FIRST, "Time", this.measureStyle2, null).setRowStyles(this.rowHeaderStyle, this.totalRowStyle, this.totalRowHeaderStyle).setColumnStyles(this.colHeaderStyle, this.totalColStyle, this.totalColHeaderStyle).setCellDimension(34, 60).setColumnHeaderHeight(30).setRowHeaderWidth(80).build();
        drb.addHeaderCrosstab(djcross);
        DynamicReport dr = drb.build();
        this.params.put("sr", SortUtils.sortCollection((Collection)TestRepositoryProducts.getDummyCollectionSmall(), (DJCrosstab)djcross));
        return dr;
    }

    public static String getAsMinutes(Long value) {
        if (value == null) {
            return null;
        }
        Long amount = value;
        int sec = amount.intValue() % 60;
        int mins = amount.intValue() / 60;
        return mins + "' " + sec + "\"";
    }

    private void initStyles() {
        this.titleStyle = new StyleBuilder(false).setFont(Font.ARIAL_BIG_BOLD).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.MIDDLE).setTransparency(Transparency.OPAQUE).setBorderBottom(Border.PEN_1_POINT()).build();
        this.totalColHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_MEDIUM_BOLD).setTextColor(Color.WHITE).setBackgroundColor(Color.BLUE).build();
        this.totalRowHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_MEDIUM_BOLD).setTextColor(Color.WHITE).setBackgroundColor(Color.GREEN).build();
        this.rowHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.TOP).setFont(Font.ARIAL_MEDIUM_BOLD).build();
        this.mainHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_BIG_BOLD).setTextColor(Color.WHITE).setTransparency(Transparency.OPAQUE).setBackgroundColor(Color.BLACK).build();
        this.totalColStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM_BOLD).setTextColor(Color.GREEN).build();
        this.totalRowStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM_BOLD).setTextColor(Color.MAGENTA).build();
        Style measureStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM).build();
        this.measureStyle2 = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(new Font(10, "Arial", false, true, false)).setTextColor(Color.BLUE).build();
    }

    public static void main(String[] args) throws Exception {
        CrosstabReportWithNullValuesTest test = new CrosstabReportWithNullValuesTest();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

