/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test.crosstab;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJCrosstab;
import ar.com.fdvs.dj.domain.DJCrosstabColumn;
import ar.com.fdvs.dj.domain.DJCrosstabRow;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.CrosstabBuilder;
import ar.com.fdvs.dj.domain.builders.CrosstabColumnBuilder;
import ar.com.fdvs.dj.domain.builders.CrosstabRowBuilder;
import ar.com.fdvs.dj.domain.builders.FastReportBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import ar.com.fdvs.dj.test.TestRepositoryProducts;
import ar.com.fdvs.dj.util.SortUtils;
import java.awt.Color;
import java.util.Date;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperDesignViewer;
import net.sf.jasperreports.view.JasperViewer;

public class CrosstabReportTest
extends BaseDjReportTest {
    private Style totalHeader;
    private Style colAndRowHeaderStyle;
    private Style mainHeaderStyle;
    private Style totalStyle;
    private Style measureStyle;

    @Override
    public DynamicReport buildReport() throws Exception {
        FastReportBuilder drb = new FastReportBuilder();
        drb.addColumn("State", "state", String.class.getName(), 30).addColumn("Branch", "branch", String.class.getName(), 30).addColumn("Product Line", "productLine", String.class.getName(), 50).addColumn("Item", "item", String.class.getName(), 50).addColumn("Item Code", "id", Long.class.getName(), 30, true).addColumn("Quantity", "quantity", Long.class.getName(), 60, true).addColumn("Amount", "amount", Float.class.getName(), 70, true).addGroups(1).addFooterVariable(1, 7, DJCalculation.SUM, null).addFooterVariable(1, 6, DJCalculation.SUM, null).setTitle("November " + this.getYear() + " sales report").setSubtitle("This report was generated at " + new Date()).setPageSizeAndOrientation(Page.Page_A4_Landscape()).setUseFullPageWidth(true);
        this.initStyles();
        CrosstabBuilder cb = new CrosstabBuilder();
        cb.setHeight(200).setWidth(500).setHeaderStyle(this.mainHeaderStyle).setDatasource("sr", 0, 0).setUseFullWidth(true).setColorScheme(4).setAutomaticTitle(true).setCellBorder(Border.PEN_1_POINT());
        cb.addMeasure("amount", Float.class.getName(), DJCalculation.SUM, "Amount", this.measureStyle);
        DJCrosstabRow row = new CrosstabRowBuilder().setProperty("productLine", String.class.getName()).setHeaderWidth(100).setHeight(0).setTitle("Product Line my mother teressa").setShowTotals(true).setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addRow(row);
        row = new CrosstabRowBuilder().setProperty("item", String.class.getName()).setHeaderWidth(100).setHeight(20).setTitle("Item").setShowTotals(true).setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        row.setTotalHeaderHeight(100);
        cb.addRow(row);
        DJCrosstabColumn col = new CrosstabColumnBuilder().setProperty("state", String.class.getName()).setHeaderHeight(60).setWidth(50).setTitle("State").setShowTotals(true).setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addColumn(col);
        col = new CrosstabColumnBuilder().setProperty("branch", String.class.getName()).setHeaderHeight(30).setWidth(60).setShowTotals(true).setTitle("Branch").setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setTotalLegend("Total for \"+ $V{branch}+ \"").setHeaderStyle(this.colAndRowHeaderStyle).build();
        cb.addColumn(col);
        col = new CrosstabColumnBuilder().setProperty("id", Long.class.getName()).setHeaderHeight(40).setWidth(70).setShowTotals(true).setTitle("ID").setTotalStyle(this.totalStyle).setTotalHeaderStyle(this.totalHeader).setHeaderStyle(this.colAndRowHeaderStyle).build();
        DJCrosstab djcross = cb.build();
        drb.addHeaderCrosstab(djcross);
        DynamicReport dr = drb.build();
        this.params.put("sr", SortUtils.sortCollection(TestRepositoryProducts.getDummyCollection(), (DJCrosstab)djcross));
        return dr;
    }

    private void initStyles() {
        this.totalHeader = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_MEDIUM_BOLD).setTextColor(Color.BLUE).build();
        this.colAndRowHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.LEFT).setVerticalAlign(VerticalAlign.TOP).setFont(Font.ARIAL_MEDIUM_BOLD).build();
        this.mainHeaderStyle = new StyleBuilder(false).setHorizontalAlign(HorizontalAlign.CENTER).setVerticalAlign(VerticalAlign.MIDDLE).setFont(Font.ARIAL_BIG_BOLD).setTextColor(Color.BLACK).build();
        this.totalStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM_BOLD).build();
        this.measureStyle = new StyleBuilder(false).setPattern("#,###.##").setHorizontalAlign(HorizontalAlign.RIGHT).setFont(Font.ARIAL_MEDIUM).build();
    }

    public static void main(String[] args) throws Exception {
        CrosstabReportTest test = new CrosstabReportTest();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
        JasperDesignViewer.viewReportDesign((JRReport)test.jr);
    }
}

