/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportExporter {
    private static final Log logger = LogFactory.getLog(ReportExporter.class);

    public static void exportReport(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        logger.debug((Object)("Exporing report to: " + path));
        JRPdfExporter exporter = new JRPdfExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        SimpleExporterInput simpleExporterInput = new SimpleExporterInput(jp);
        SimpleOutputStreamExporterOutput simpleOutputStreamExporterOutput = new SimpleOutputStreamExporterOutput((OutputStream)fos);
        exporter.setExporterInput((ExporterInput)simpleExporterInput);
        exporter.setExporterOutput((ExporterOutput)simpleOutputStreamExporterOutput);
        exporter.exportReport();
        logger.debug((Object)("Report exported: " + path));
    }

    public static void exportReportXls(JasperPrint jp, String path, SimpleXlsReportConfiguration configuration) throws JRException, FileNotFoundException {
        JRXlsExporter exporter = new JRXlsExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        exporter.setConfiguration((ReportExportConfiguration)configuration);
        SimpleExporterInput simpleExporterInput = new SimpleExporterInput(jp);
        SimpleOutputStreamExporterOutput simpleOutputStreamExporterOutput = new SimpleOutputStreamExporterOutput((OutputStream)fos);
        exporter.setExporterInput((ExporterInput)simpleExporterInput);
        exporter.setExporterOutput((ExporterOutput)simpleOutputStreamExporterOutput);
        exporter.exportReport();
        logger.debug((Object)("Xlsx Report exported: " + path));
    }

    public static void exportReportXls(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
        configuration.setDetectCellType(Boolean.valueOf(true));
        configuration.setWhitePageBackground(Boolean.valueOf(false));
        configuration.setIgnoreGraphics(Boolean.valueOf(false));
        configuration.setIgnorePageMargins(Boolean.valueOf(true));
        ReportExporter.exportReportXls(jp, path, configuration);
    }

    public static void exportReportHtml(JasperPrint jp, String path) throws JRException, FileNotFoundException {
        HtmlExporter exporter = new HtmlExporter();
        File outputFile = new File(path);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(outputFile);
        SimpleExporterInput simpleExporterInput = new SimpleExporterInput(jp);
        SimpleHtmlExporterOutput simpleOutputStreamExporterOutput = new SimpleHtmlExporterOutput((OutputStream)fos);
        exporter.setExporterInput((ExporterInput)simpleExporterInput);
        exporter.setExporterOutput((ExporterOutput)simpleOutputStreamExporterOutput);
        SimpleHtmlExporterConfiguration configuration = new SimpleHtmlExporterConfiguration();
        exporter.setConfiguration((ExporterConfiguration)configuration);
        exporter.exportReport();
        logger.debug((Object)("HTML Report exported: " + path));
    }
}

