/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.ReflectiveReportBuilder;
import ar.com.fdvs.dj.test.ReportExporter;
import ar.com.fdvs.dj.test.TestRepositoryProducts;
import ar.com.fdvs.dj.test.domain.Product;
import ar.com.fdvs.dj.util.SortUtils;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;

public class ReflectiveReportTest
extends TestCase {
    public void testReport() {
        List<Product> data = TestRepositoryProducts.getDummyCollection();
        DynamicReport dynamicReport = new ReflectiveReportBuilder(data).build();
        this.doReport(dynamicReport, data, "");
    }

    public void testOrderedReport() {
        List<Product> data = TestRepositoryProducts.getDummyCollection();
        List items = SortUtils.sortCollection(data, Arrays.asList("productLine", "item", "state"));
        String[] columOrders = new String[]{"productLine", "item", "state", "id", "branch", "quantity", "amount"};
        DynamicReport dynamicReport = new ReflectiveReportBuilder((Collection)items, columOrders).addGroups(3).build();
        this.doReport(dynamicReport, items, "ordered");
    }

    public void doReport(DynamicReport _report, Collection _data, String name) {
        try {
            JasperPrint jasperPrint = DynamicJasperHelper.generateJasperPrint((DynamicReport)_report, (LayoutManager)new ClassicLayoutManager(), (Collection)_data);
            ReportExporter.exportReport(jasperPrint, System.getProperty("user.dir") + "/target/ReflectiveReportTest " + name + ".pdf");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] _args) {
        ReflectiveReportTest reportTest = new ReflectiveReportTest();
        reportTest.testReport();
        reportTest.testOrderedReport();
    }
}

