/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.ExpressionHelper;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.awt.Color;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;

public class CustomExpressionReportTest3
extends BaseDjReportTest {
    @Override
    public DynamicReport buildReport() throws Exception {
        Style detailStyle = new Style();
        Style headerStyle = new Style();
        headerStyle.setFont(Font.ARIAL_MEDIUM_BOLD);
        headerStyle.setBorder(Border.PEN_2_POINT());
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        Style titleStyle = new Style();
        titleStyle.setFont(new Font(18, "Verdana", true));
        Style amountStyle = new Style();
        amountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        Style oddRowStyle = new Style();
        oddRowStyle.setBorder(Border.NO_BORDER());
        Color veryLightGrey = new Color(230, 230, 230);
        oddRowStyle.setBackgroundColor(veryLightGrey);
        oddRowStyle.setTransparency(Transparency.OPAQUE);
        DynamicReportBuilder drb = new DynamicReportBuilder();
        Integer margin = 20;
        drb.setTitle("November " + this.getYear() + " sales report").setSubtitle("The items in this report correspond to the main products: DVDs, Books, Foods and Magazines").setTitleStyle(titleStyle).setTitleHeight(30).setSubtitleHeight(20).setDetailHeight(15).setLeftMargin(margin.intValue()).setRightMargin(margin.intValue()).setTopMargin(margin.intValue()).setBottomMargin(margin.intValue()).setPrintBackgroundOnOddRows(true).setOddRowBackgroundStyle(oddRowStyle).setColumnsPerPage(1).setColumnSpace(5);
        AbstractColumn columnState = ColumnBuilder.getNew().setColumnProperty("state", String.class.getName()).setTitle("State").setWidth(new Integer(85).intValue()).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnaItem = ColumnBuilder.getNew().setColumnProperty("item", String.class.getName()).setTitle("item").setWidth(new Integer(85).intValue()).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnCode = ColumnBuilder.getNew().setColumnProperty("id", Long.class.getName()).setTitle("ID").setWidth(new Integer(40).intValue()).setStyle(amountStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnaCantidad = ColumnBuilder.getNew().setColumnProperty("quantity", Long.class.getName()).setTitle("Quantity").setWidth(new Integer(80).intValue()).setStyle(amountStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnAmount = ColumnBuilder.getNew().setColumnProperty("amount", Float.class.getName()).setTitle("Amount").setWidth(new Integer(90).intValue()).setPattern("$ 0.00").setStyle(amountStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnaCustomExpression = ColumnBuilder.getNew().setCustomExpression(this.getRatioExpression()).setTitle("CustomExp").setWidth(new Integer(90).intValue()).setPattern("#,##0.0").setStyle(detailStyle).setHeaderStyle(headerStyle).build();
        drb.addColumn(columnState);
        drb.addColumn(columnaItem);
        drb.addColumn(columnCode);
        drb.addColumn(columnaCantidad);
        drb.addColumn(columnAmount);
        drb.addColumn(columnaCustomExpression);
        drb.addGlobalVariable("quantity_sum", columnaCantidad, DJCalculation.SUM);
        drb.addGlobalVariable("amount_sum", columnAmount, DJCalculation.SUM);
        drb.addGlobalFooterVariable(columnaCustomExpression, this.getGlobalRatioExpression());
        GroupBuilder gb1 = new GroupBuilder("g1");
        DJGroupVariable var = new DJGroupVariable(columnaCantidad, DJCalculation.SUM);
        var.setPrintWhenExpression(ExpressionHelper.printWhenGroupHasMoreThanOneRecord((String)"g1"));
        DJGroup g1 = gb1.setCriteriaColumn((PropertyColumn)columnState).addFooterVariable(var).addVariable("quantity_sum_g1", columnaCantidad, DJCalculation.SUM).addVariable("amount_sum_g1", columnAmount, DJCalculation.SUM).addFooterVariable(columnaCustomExpression, this.getGroupRatioExpression()).setGroupLayout(GroupLayout.VALUE_IN_HEADER).setFooterVariablesHeight(20).setFooterHeight(50, true).setHeaderVariablesHeight(35).build();
        drb.addGroup(g1);
        drb.setUseFullPageWidth(true);
        drb.addField("productLine", String.class.getName());
        drb.addField("branch", String.class.getName());
        DynamicReport dr = drb.build();
        return dr;
    }

    private CustomExpression getRatioExpression() {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                Long quantity = (Long)fields.get("quantity");
                Float amount = (Float)fields.get("amount");
                return amount.doubleValue() / quantity.doubleValue();
            }

            public String getClassName() {
                return Double.class.getName();
            }
        };
    }

    private CustomExpression getGlobalRatioExpression() {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                Long quantity = (Long)variables.get("quantity_sum");
                Float amount = (Float)variables.get("amount_sum");
                return amount.doubleValue() / quantity.doubleValue();
            }

            public String getClassName() {
                return Double.class.getName();
            }
        };
    }

    private CustomExpression getGroupRatioExpression() {
        return new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                Long quantity = (Long)variables.get("quantity_sum_g1");
                Float amount = (Float)variables.get("amount_sum_g1");
                return amount.doubleValue() / quantity.doubleValue();
            }

            public String getClassName() {
                return Double.class.getName();
            }
        };
    }

    public static void main(String[] args) throws Exception {
        CustomExpressionReportTest3 test = new CustomExpressionReportTest3();
        test.testReport();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

