/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.test;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionStyleExpression;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.StatusLightCondition;
import ar.com.fdvs.dj.test.BaseDjReportTest;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JasperViewer;
import org.apache.commons.beanutils.BeanUtils;

public class ConditionalStylesReportTest
extends BaseDjReportTest {
    @Override
    public DynamicReport buildReport() throws Exception {
        Style detailStyle = new Style();
        Style headerStyle = new Style();
        headerStyle.setFont(Font.ARIAL_BIG_BOLD);
        headerStyle.setBorderBottom(Border.PEN_2_POINT());
        headerStyle.setHorizontalAlign(HorizontalAlign.CENTER);
        headerStyle.setVerticalAlign(VerticalAlign.MIDDLE);
        headerStyle.setBackgroundColor(Color.LIGHT_GRAY);
        headerStyle.setTextColor(Color.WHITE);
        headerStyle.setTransparency(Transparency.OPAQUE);
        Style titleStyle = new Style();
        titleStyle.setFont(new Font(18, "Verdana", true));
        Style amountStyle = new Style();
        amountStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        Style oddRowStyle = new Style();
        oddRowStyle.setBorder(Border.NO_BORDER());
        Color veryLightGrey = new Color(230, 230, 230);
        oddRowStyle.setBackgroundColor(veryLightGrey);
        oddRowStyle.setTransparency(Transparency.OPAQUE);
        DynamicReportBuilder drb = new DynamicReportBuilder();
        Integer margin = 20;
        drb.setTitle("November " + this.getYear() + " sales report").setSubtitle("The items in this report correspond to the main products: DVDs, Books, Foods and Magazines").setTitleStyle(titleStyle).setTitleHeight(30).setSubtitleHeight(20).setDetailHeight(15).setLeftMargin(margin.intValue()).setRightMargin(margin.intValue()).setTopMargin(margin.intValue()).setBottomMargin(margin.intValue()).setPrintBackgroundOnOddRows(true).setOddRowBackgroundStyle(oddRowStyle).setColumnsPerPage(1).setColumnSpace(5);
        AbstractColumn columnState = ColumnBuilder.getNew().setColumnProperty("state", String.class.getName()).setTitle("State").setWidth(new Integer(85).intValue()).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnBranch = ColumnBuilder.getNew().setColumnProperty("branch", String.class.getName()).setTitle("Branch").setWidth(new Integer(85).intValue()).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnaProductLine = ColumnBuilder.getNew().setColumnProperty("productLine", String.class.getName()).setTitle("Product Line").setWidth(new Integer(85).intValue()).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnaItem = ColumnBuilder.getNew().setColumnProperty("item", String.class.getName()).setTitle("Item").setWidth(new Integer(85).intValue()).setStyle(detailStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnCode = ColumnBuilder.getNew().setColumnProperty("id", Long.class.getName()).setTitle("ID").setWidth(new Integer(40).intValue()).setStyle(amountStyle).setHeaderStyle(headerStyle).build();
        AbstractColumn columnaCantidad = ColumnBuilder.getNew().setColumnProperty("quantity", Long.class.getName()).setTitle("Quantity").setWidth(new Integer(80).intValue()).setStyle(amountStyle).setHeaderStyle(headerStyle).build();
        ArrayList conditionalStyles = this.createConditionalStyles(amountStyle);
        AbstractColumn columnAmount = ColumnBuilder.getNew().setColumnProperty("amount", Float.class.getName()).setTitle("Amount").setWidth(new Integer(90).intValue()).setPattern("$ 0.00").addConditionalStyles((Collection)conditionalStyles).setStyle(amountStyle).setHeaderStyle(headerStyle).build();
        drb.addColumn(columnState);
        drb.addColumn(columnBranch);
        drb.addColumn(columnaProductLine);
        drb.addColumn(columnaItem);
        drb.addColumn(columnCode);
        drb.addColumn(columnaCantidad);
        drb.addColumn(columnAmount);
        drb.setUseFullPageWidth(true);
        DynamicReport dr = drb.build();
        return dr;
    }

    private ArrayList createConditionalStyles(Style baseStyle) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Style style0 = (Style)BeanUtils.cloneBean((Object)baseStyle);
        style0.setTextColor(Color.RED);
        style0.setFont(Font.GEORGIA_MEDIUM_BOLD);
        Style style1 = (Style)BeanUtils.cloneBean((Object)baseStyle);
        style1.setTextColor(new Color(128, 128, 0));
        Style style2 = (Style)BeanUtils.cloneBean((Object)baseStyle);
        style2.setTextColor(new Color(0, 128, 0));
        style2.setFont(Font.ARIAL_SMALL_BOLD);
        StatusLightCondition status0 = new StatusLightCondition(Double.valueOf(0.0), Double.valueOf(3000.0));
        StatusLightCondition status1 = new StatusLightCondition(Double.valueOf(5000.0), Double.valueOf(6000.0));
        StatusLightCondition status2 = new StatusLightCondition(Double.valueOf(6000.0), Double.valueOf(100000.0));
        ConditionalStyle condition0 = new ConditionalStyle((ConditionStyleExpression)status0, style0);
        ConditionalStyle condition1 = new ConditionalStyle((ConditionStyleExpression)status1, style1);
        ConditionalStyle condition2 = new ConditionalStyle((ConditionStyleExpression)status2, style2);
        ArrayList<ConditionalStyle> conditionalStyles = new ArrayList<ConditionalStyle>();
        conditionalStyles.add(condition0);
        conditionalStyles.add(condition1);
        conditionalStyles.add(condition2);
        return conditionalStyles;
    }

    public static void main(String[] args) throws Exception {
        ConditionalStylesReportTest test = new ConditionalStylesReportTest();
        test.testReport();
        test.exportToJRXML();
        JasperViewer.viewReport((JasperPrint)test.jp);
    }
}

