/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core.layout;

import ar.com.fdvs.dj.core.layout.AbstractLayoutManager;
import ar.com.fdvs.dj.core.layout.AutoTextExpressionUtils;
import ar.com.fdvs.dj.core.layout.HorizontalBandAlignment;
import ar.com.fdvs.dj.domain.AutoText;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.util.ExpressionUtils;
import java.util.Random;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;

public class CommonExpressionsHelper {
    private static String KEY_autotext_page = "autotext.page";
    private static String KEY_autotext_of = "autotext.of";
    private static String KEY_autotext_created_on = "autotext.created_on";
    private static Random random = new Random();

    public static void addPageXofY(int yOffset, DynamicJasperDesign design, DynamicReport report, AbstractLayoutManager lm, JRDesignBand band, AutoText autoText) {
        boolean hasStyle;
        int height = autoText.getHeight();
        JRDesignTextField pageNumber = new JRDesignTextField();
        pageNumber.setHorizontalAlignment(HorizontalAlignEnum.RIGHT);
        boolean bl = hasStyle = autoText.getStyle() != null;
        if (hasStyle) {
            lm.applyStyleToElement(autoText.getStyle(), (JRDesignElement)pageNumber);
        }
        pageNumber.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression(KEY_autotext_page, KEY_autotext_of, true));
        pageNumber.setHeight(height);
        pageNumber.setWidth(autoText.getWidth().intValue());
        pageNumber.setY(yOffset);
        pageNumber.setPositionType(PositionTypeEnum.FLOAT);
        JRDesignTextField pageCounter = new JRDesignTextField();
        if (hasStyle) {
            lm.applyStyleToElement(autoText.getStyle(), (JRDesignElement)pageCounter);
        }
        pageCounter.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression(" ", "", false));
        pageCounter.setHeight(height);
        pageCounter.setWidth(autoText.getWidth2().intValue());
        pageCounter.setY(yOffset);
        pageCounter.setEvaluationTime(EvaluationTimeEnum.REPORT);
        pageCounter.setHorizontalAlignment(HorizontalAlignEnum.LEFT);
        pageCounter.setPositionType(PositionTypeEnum.FLOAT);
        band.addElement((JRDesignElement)pageCounter);
        int pageNumberOffset = 0;
        HorizontalBandAlignment alignment = autoText.getAlignment();
        if (alignment == HorizontalBandAlignment.RIGHT) {
            pageNumberOffset = pageCounter.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageNumberOffset = -pageCounter.getWidth() / 2;
        }
        int pageCounterOffset = 0;
        if (alignment == HorizontalBandAlignment.LEFT) {
            pageCounterOffset = pageNumber.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageCounterOffset = pageNumber.getWidth() / 2;
        }
        alignment.align(report.getOptions().getPrintableWidth(), pageNumberOffset, band, (JRDesignElement)pageNumber);
        alignment.align(report.getOptions().getPrintableWidth(), pageCounterOffset, band, (JRDesignElement)pageCounter);
        if (autoText.getPrintWhenExpression() != null) {
            JRDesignExpression printWhenExpression = CommonExpressionsHelper.getPrintWhenExpression(design, autoText);
            pageNumber.setPrintWhenExpression((JRExpression)printWhenExpression);
            pageCounter.setPrintWhenExpression((JRExpression)printWhenExpression);
        }
        band.setHeight(band.getHeight() + height);
    }

    public static void addPageXSlashY(int yOffset, DynamicJasperDesign design, DynamicReport report, AbstractLayoutManager lm, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField pageNumber = new JRDesignTextField();
        if (autoText.getStyle() != null) {
            lm.applyStyleToElement(autoText.getStyle(), (JRDesignElement)pageNumber);
        }
        pageNumber.setHorizontalAlignment(HorizontalAlignEnum.RIGHT);
        pageNumber.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression("", "", false));
        pageNumber.setHeight(height);
        pageNumber.setWidth(autoText.getWidth().intValue());
        pageNumber.setY(yOffset);
        JRDesignTextField pageCounter = new JRDesignTextField();
        if (autoText.getStyle() != null) {
            lm.applyStyleToElement(autoText.getStyle(), (JRDesignElement)pageCounter);
        }
        pageCounter.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression("/", "", false));
        pageCounter.setHeight(height);
        pageCounter.setWidth(autoText.getWidth().intValue());
        pageCounter.setHorizontalAlignment(HorizontalAlignEnum.LEFT);
        pageCounter.setEvaluationTime(EvaluationTimeEnum.REPORT);
        pageCounter.setX(pageNumber.getX() + pageNumber.getWidth());
        pageCounter.setY(yOffset);
        int pageNumberOffset = 0;
        HorizontalBandAlignment alignment = autoText.getAlignment();
        if (alignment == HorizontalBandAlignment.RIGHT) {
            pageNumberOffset = pageCounter.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageNumberOffset = -pageCounter.getWidth() / 2;
        }
        int pageCounterOffset = 0;
        if (alignment == HorizontalBandAlignment.LEFT) {
            pageCounterOffset = pageNumber.getWidth();
        } else if (alignment == HorizontalBandAlignment.CENTER) {
            pageCounterOffset = pageNumber.getWidth() / 2;
        }
        alignment.align(report.getOptions().getPrintableWidth(), pageNumberOffset, band, (JRDesignElement)pageNumber);
        alignment.align(report.getOptions().getPrintableWidth(), pageCounterOffset, band, (JRDesignElement)pageCounter);
        if (autoText.getPrintWhenExpression() != null) {
            JRDesignExpression printWhenExpression = CommonExpressionsHelper.getPrintWhenExpression(design, autoText);
            pageNumber.setPrintWhenExpression((JRExpression)printWhenExpression);
            pageCounter.setPrintWhenExpression((JRExpression)printWhenExpression);
        }
        band.setHeight(band.getHeight() + height);
    }

    public static void addPageX(int yOffset, DynamicJasperDesign design, DynamicReport report, AbstractLayoutManager lm, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField pageNumber = new JRDesignTextField();
        if (autoText.getStyle() != null) {
            lm.applyStyleToElement(autoText.getStyle(), (JRDesignElement)pageNumber);
        }
        pageNumber.setHorizontalAlignment(HorizontalAlignEnum.RIGHT);
        pageNumber.setExpression((JRExpression)AutoTextExpressionUtils.getPageNumberExpression("", "", false));
        pageNumber.setHeight(height);
        if (AutoText.WIDTH_NOT_SET.equals(autoText.getWidth())) {
            pageNumber.setWidth(report.getOptions().getPrintableWidth());
        } else {
            pageNumber.setWidth(autoText.getWidth().intValue());
        }
        pageNumber.setY(yOffset);
        autoText.getAlignment().align(report.getOptions().getPrintableWidth(), 0, band, (JRDesignElement)pageNumber);
        if (autoText.getPrintWhenExpression() != null) {
            JRDesignExpression printWhenExpression = CommonExpressionsHelper.getPrintWhenExpression(design, autoText);
            pageNumber.setPrintWhenExpression((JRExpression)printWhenExpression);
        }
        band.setHeight(band.getHeight() + height);
    }

    public static void addCreationDate(int yOffset, DynamicJasperDesign design, DynamicReport report, AbstractLayoutManager lm, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField dateTf = new JRDesignTextField();
        if (autoText.getStyle() != null) {
            lm.applyStyleToElement(autoText.getStyle(), (JRDesignElement)dateTf);
        }
        dateTf.setExpression((JRExpression)AutoTextExpressionUtils.getDateExpression(KEY_autotext_created_on, "", report.getReportLocale(), autoText.getPattern()));
        dateTf.setHeight(height);
        if (AutoText.WIDTH_NOT_SET.equals(autoText.getWidth())) {
            dateTf.setWidth(report.getOptions().getPrintableWidth());
        } else {
            dateTf.setWidth(autoText.getWidth().intValue());
        }
        dateTf.setHorizontalAlignment(HorizontalAlignEnum.getByValue((byte)autoText.getAlignment().getAlignment()));
        dateTf.setY(yOffset);
        dateTf.setPositionType(PositionTypeEnum.FLOAT);
        autoText.getAlignment().align(report.getOptions().getPrintableWidth(), 0, band, (JRDesignElement)dateTf);
        if (autoText.getPrintWhenExpression() != null) {
            JRDesignExpression printWhenExpression = CommonExpressionsHelper.getPrintWhenExpression(design, autoText);
            dateTf.setPrintWhenExpression((JRExpression)printWhenExpression);
        }
        band.setHeight(band.getHeight() + height);
    }

    public static void addMessage(int yOffset, DynamicJasperDesign design, DynamicReport report, AbstractLayoutManager lm, JRDesignBand band, AutoText autoText) {
        int height = autoText.getHeight();
        JRDesignTextField textfield = new JRDesignTextField();
        if (autoText.getStyle() != null) {
            lm.applyStyleToElement(autoText.getStyle(), (JRDesignElement)textfield);
        }
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("\"" + autoText.getMessageKey() + "\"");
        textfield.setExpression((JRExpression)expression);
        textfield.setHeight(autoText.getHeight().intValue());
        textfield.setMarkup("styled");
        if (AutoText.WIDTH_NOT_SET.equals(autoText.getWidth())) {
            textfield.setWidth(report.getOptions().getPrintableWidth());
        } else {
            textfield.setWidth(autoText.getWidth().intValue());
        }
        textfield.setY(yOffset);
        autoText.getAlignment().align(report.getOptions().getPrintableWidth(), 0, band, (JRDesignElement)textfield);
        textfield.setHorizontalAlignment(HorizontalAlignEnum.getByValue((byte)autoText.getAlignment().getAlignment()));
        if (autoText.getPrintWhenExpression() != null) {
            JRDesignExpression printWhenExpression = CommonExpressionsHelper.getPrintWhenExpression(design, autoText);
            textfield.setPrintWhenExpression((JRExpression)printWhenExpression);
        }
        band.setHeight(band.getHeight() + height);
    }

    private static JRDesignExpression getPrintWhenExpression(DynamicJasperDesign design, AutoText autoText) {
        long random_ = Math.abs(random.nextLong());
        String name = "autotext_" + random_ + "_printWhenExpression";
        return ExpressionUtils.createAndRegisterExpression(design, name, autoText.getPrintWhenExpression());
    }

    public static void add(int yOffset, DynamicJasperDesign design, AbstractLayoutManager lm, JRDesignBand band, AutoText text) {
        DynamicReport report = lm.getReport();
        switch (text.getType()) {
            case 0: {
                CommonExpressionsHelper.addPageXofY(yOffset, design, report, lm, band, text);
                break;
            }
            case 1: {
                CommonExpressionsHelper.addPageXSlashY(yOffset, design, report, lm, band, text);
                break;
            }
            case 2: {
                CommonExpressionsHelper.addPageX(yOffset, design, report, lm, band, text);
                break;
            }
            case 3: {
                CommonExpressionsHelper.addCreationDate(yOffset, design, report, lm, band, text);
                break;
            }
            case 4: {
                CommonExpressionsHelper.addMessage(yOffset, design, report, lm, band, text);
            }
        }
    }
}

