/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.core;

import ar.com.fdvs.dj.core.CoreException;
import ar.com.fdvs.dj.domain.DJQuery;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.DynamicReportOptions;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.util.LayoutUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DJJRDesignHelper {
    private static final Log log = LogFactory.getLog(DJJRDesignHelper.class);

    public static DynamicJasperDesign getNewDesign(DynamicReport dr) {
        log.info((Object)"Creating DynamicJasperDesign");
        DynamicJasperDesign des = new DynamicJasperDesign();
        DynamicReportOptions options = dr.getOptions();
        Page page = options.getPage();
        des.setPrintOrder(PrintOrderEnum.VERTICAL);
        OrientationEnum orientation = OrientationEnum.PORTRAIT;
        if (!page.isOrientationPortrait()) {
            orientation = OrientationEnum.LANDSCAPE;
        }
        des.setOrientation(orientation);
        des.setPageWidth(page.getWidth());
        des.setPageHeight(page.getHeight());
        des.setColumnWidth(options.getColumnWidth());
        des.setColumnSpacing(options.getColumnSpace());
        des.setLeftMargin(options.getLeftMargin());
        des.setRightMargin(options.getRightMargin());
        des.setTopMargin(options.getTopMargin());
        des.setBottomMargin(options.getBottomMargin());
        if (dr.getLanguage() != null) {
            des.setLanguage(dr.getLanguage().toLowerCase());
        }
        JRDesignSection detailSection = (JRDesignSection)des.getDetailSection();
        detailSection.getBandsList().add(new JRDesignBand());
        des.setPageHeader((JRBand)new JRDesignBand());
        des.setPageFooter((JRBand)new JRDesignBand());
        des.setSummary((JRBand)new JRDesignBand());
        DJJRDesignHelper.populateBehavioralOptions(dr, des);
        if (dr.getQuery() != null) {
            JRDesignQuery query = DJJRDesignHelper.getJRDesignQuery(dr);
            des.setQuery(query);
        }
        for (Object o : dr.getProperties().keySet()) {
            String name = (String)o;
            des.setProperty(name, (String)dr.getProperties().get(name));
        }
        des.setName(dr.getReportName() != null ? dr.getReportName() : "DJR");
        return des;
    }

    protected static void populateBehavioralOptions(DynamicReport dr, DynamicJasperDesign des) {
        DynamicReportOptions options = dr.getOptions();
        des.setColumnCount(options.getColumnsPerPage());
        des.setWhenNoDataType(WhenNoDataTypeEnum.getByValue((byte)dr.getWhenNoDataType()));
        des.setWhenResourceMissingType(WhenResourceMissingTypeEnum.getByValue((byte)dr.getWhenResourceMissing()));
        des.setTitleNewPage(options.isTitleNewPage());
        des.setIgnorePagination(options.isIgnorePagination());
        JRDesignSection detailSection = (JRDesignSection)des.getDetailSection();
        List bands = detailSection.getBandsList();
        if (!bands.isEmpty()) {
            JRDesignBand detailBand = (JRDesignBand)bands.iterator().next();
            detailBand.setSplitType(LayoutUtils.getSplitTypeFromBoolean(dr.isAllowDetailSplit()));
        }
        des.setSummaryNewPage(options.isSummaryNewPage());
    }

    protected static JRDesignQuery getJRDesignQuery(DynamicReport dr) {
        JRDesignQuery query = new JRDesignQuery();
        query.setText(dr.getQuery().getText());
        query.setLanguage(dr.getQuery().getLanguage());
        return query;
    }

    public static DynamicJasperDesign downCast(JasperDesign jd, DynamicReport dr) throws CoreException {
        DynamicJasperDesign djd = new DynamicJasperDesign();
        log.info((Object)"downcasting JasperDesign");
        try {
            BeanUtils.copyProperties((Object)((Object)djd), (Object)jd);
            if (dr.isTemplateImportParameters()) {
                for (Object element : jd.getParametersList()) {
                    try {
                        djd.addParameter((JRParameter)element);
                    }
                    catch (JRException e) {
                        String message;
                        if (!log.isDebugEnabled() || (message = e.getMessage()).startsWith("Duplicate declaration of parameter")) continue;
                        log.warn((Object)message);
                    }
                }
            }
            if (dr.isTemplateImportFields()) {
                for (Object element : jd.getFieldsList()) {
                    try {
                        djd.addField((JRField)element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportVariables()) {
                for (Object element : jd.getVariablesList()) {
                    try {
                        if (!(element instanceof JRDesignVariable)) continue;
                        djd.addVariable((JRDesignVariable)element);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            if (dr.isTemplateImportDatasets()) {
                JRQuery query = jd.getQuery();
                if (query instanceof JRDesignQuery) {
                    djd.setQuery((JRDesignQuery)query);
                    dr.setQuery(new DJQuery(query.getText(), query.getLanguage()));
                }
                for (JRDataset jrDataset : jd.getDatasetsList()) {
                    JRDesignDataset dataset = (JRDesignDataset)jrDataset;
                    try {
                        djd.addDataset(dataset);
                    }
                    catch (JRException e) {
                        if (!log.isDebugEnabled()) continue;
                        log.warn((Object)e.getMessage());
                    }
                }
            }
            JRVariable properties = jd.getPropertyNames();
            for (Object propName : properties) {
                String propValue = jd.getProperty((String)propName);
                djd.setProperty((String)propName, propValue);
            }
            for (JRStyle style : jd.getStylesList()) {
                try {
                    djd.addStyle(style);
                }
                catch (JRException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.warn((Object)("Duplicated style (style name \"" + style.getName() + "\") when loading design: " + e.getMessage()), (Throwable)e);
                }
            }
            JRReportTemplate[] templates = jd.getTemplates();
            if (templates != null) {
                for (JRReportTemplate template : templates) {
                    djd.addTemplate(template);
                }
            }
            DJJRDesignHelper.populateBehavioralOptions(dr, djd);
        }
        catch (IllegalAccessException e) {
            throw new CoreException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new CoreException(e.getMessage(), e);
        }
        return djd;
    }

    protected static void populateReportOptionsFromDesign(DynamicJasperDesign jd, DynamicReport dr) {
        DynamicReportOptions options = dr.getOptions();
        options.setBottomMargin(jd.getBottomMargin());
        options.setTopMargin(jd.getTopMargin());
        options.setLeftMargin(jd.getLeftMargin());
        options.setRightMargin(jd.getRightMargin());
        options.setColumnSpace(jd.getColumnSpacing());
        options.setColumnsPerPage(jd.getColumnCount());
        boolean isPortrait = true;
        if (jd.getOrientationValue() == OrientationEnum.LANDSCAPE) {
            isPortrait = false;
        }
        options.setPage(new Page(jd.getPageHeight(), jd.getPageWidth(), isPortrait));
        if (dr.getQuery() != null) {
            JRDesignQuery query = DJJRDesignHelper.getJRDesignQuery(dr);
            jd.setQuery(query);
        }
        if (dr.getReportName() != null) {
            jd.setName(dr.getReportName());
        }
    }
}

