/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain;

import ar.com.fdvs.dj.domain.constants.Border;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.util.LayoutUtils;
import java.awt.Color;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;

public class Style
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 10000L;
    private String name;
    private String parentStyleName;
    private Color backgroundColor = Color.WHITE;
    private Color textColor = Color.BLACK;
    private Font font = Font.ARIAL_MEDIUM;
    private Border border = Border.NO_BORDER();
    private Border borderTop = null;
    private Border borderBottom = null;
    private Border borderLeft = null;
    private Border borderRight = null;
    private Integer paddingBottom;
    private Integer paddingTop;
    private Integer paddingLeft;
    private Integer paddingRight;
    private Integer padding = new Integer(2);
    private Integer radius = new Integer(0);
    private Transparency transparency = Transparency.TRANSPARENT;
    private VerticalAlign verticalAlign = VerticalAlign.BOTTOM;
    private HorizontalAlign horizontalAlign = HorizontalAlign.LEFT;
    private Rotation rotation = Rotation.NONE;
    private Stretching streching = Stretching.RELATIVE_TO_TALLEST_OBJECT;
    private boolean stretchWithOverflow = true;
    private boolean blankWhenNull = true;
    private String pattern;
    private boolean overridesExistingStyle = false;

    public boolean isOverridesExistingStyle() {
        return this.overridesExistingStyle;
    }

    public void setOverridesExistingStyle(boolean overridesExistingStyle) {
        this.overridesExistingStyle = overridesExistingStyle;
    }

    public Style() {
    }

    public Style(String name) {
        this.name = name;
    }

    public Style(String name, String parentName) {
        this.name = name;
        this.parentStyleName = parentName;
    }

    public boolean isBlankWhenNull() {
        return this.blankWhenNull;
    }

    public void setBlankWhenNull(boolean blankWhenNull) {
        this.blankWhenNull = blankWhenNull;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font != null ? (Font)font.clone() : null;
    }

    public HorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(HorizontalAlign horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public Integer getPadding() {
        return this.padding;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public Stretching getStreching() {
        return this.streching;
    }

    public void setStreching(Stretching streching) {
        this.streching = streching;
    }

    public boolean isStretchWithOverflow() {
        return this.stretchWithOverflow;
    }

    public void setStretchWithOverflow(boolean stretchWithOverflow) {
        this.stretchWithOverflow = stretchWithOverflow;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Transparency getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Transparency transparency) {
        this.transparency = transparency;
    }

    public void setTransparent(boolean transparent) {
        if (transparent) {
            this.setTransparency(Transparency.TRANSPARENT);
        } else {
            this.setTransparency(Transparency.OPAQUE);
        }
    }

    public boolean isTransparent() {
        return this.transparency.equals(Transparency.TRANSPARENT);
    }

    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public JRDesignConditionalStyle transformAsConditinalStyle() {
        JRDesignConditionalStyle ret = new JRDesignConditionalStyle();
        this.setJRBaseStyleProperties((JRBaseStyle)ret);
        return ret;
    }

    public JRDesignStyle transform() {
        JRDesignStyle transformedStyle = new JRDesignStyle();
        transformedStyle.setName(this.name);
        transformedStyle.setParentStyleNameReference(this.parentStyleName);
        this.setJRBaseStyleProperties((JRBaseStyle)transformedStyle);
        return transformedStyle;
    }

    protected void setJRBaseStyleProperties(JRBaseStyle transformedStyle) {
        JRBoxPen pen = transformedStyle.getLineBox().getPen();
        if (this.getBorder() != null) {
            LayoutUtils.convertBorderToPen(this.getBorder(), (JRPen)transformedStyle.getLineBox().getPen());
        }
        if (this.getBorderBottom() != null) {
            LayoutUtils.convertBorderToPen(this.getBorderBottom(), (JRPen)transformedStyle.getLineBox().getBottomPen());
        }
        if (this.getBorderTop() != null) {
            LayoutUtils.convertBorderToPen(this.getBorderTop(), (JRPen)transformedStyle.getLineBox().getTopPen());
        }
        if (this.getBorderLeft() != null) {
            LayoutUtils.convertBorderToPen(this.getBorderLeft(), (JRPen)transformedStyle.getLineBox().getLeftPen());
        }
        if (this.getBorderRight() != null) {
            LayoutUtils.convertBorderToPen(this.getBorderRight(), (JRPen)transformedStyle.getLineBox().getRightPen());
        }
        transformedStyle.getLineBox().setPadding(this.getPadding());
        if (this.paddingBottom != null) {
            transformedStyle.getLineBox().setBottomPadding(this.paddingBottom);
        }
        if (this.paddingTop != null) {
            transformedStyle.getLineBox().setTopPadding(this.paddingTop);
        }
        if (this.paddingLeft != null) {
            transformedStyle.getLineBox().setLeftPadding(this.paddingLeft);
        }
        if (this.paddingRight != null) {
            transformedStyle.getLineBox().setRightPadding(this.paddingRight);
        }
        if (this.getHorizontalAlign() != null) {
            transformedStyle.setHorizontalAlignment(HorizontalAlignEnum.getByValue((byte)this.getHorizontalAlign().getValue()));
        }
        if (this.getVerticalAlign() != null) {
            transformedStyle.setVerticalAlignment(VerticalAlignEnum.getByValue((byte)this.getVerticalAlign().getValue()));
        }
        transformedStyle.setBlankWhenNull(this.blankWhenNull);
        if (this.font != null) {
            transformedStyle.setFontName(this.font.getFontName());
            transformedStyle.setFontSize(this.font.getFontSize());
            transformedStyle.setBold(this.font.isBold());
            transformedStyle.setItalic(this.font.isItalic());
            transformedStyle.setUnderline(this.font.isUnderline());
            transformedStyle.setPdfFontName(this.font.getPdfFontName());
            transformedStyle.setPdfEmbedded(this.font.isPdfFontEmbedded());
            transformedStyle.setPdfEncoding(this.font.getPdfFontEncoding());
        }
        transformedStyle.setBackcolor(this.getBackgroundColor());
        transformedStyle.setForecolor(this.getTextColor());
        if (this.getTransparency() != null) {
            transformedStyle.setMode(ModeEnum.getByValue((byte)this.getTransparency().getValue()));
        }
        if (this.getRotation() != null) {
            transformedStyle.setRotation(RotationEnum.getByValue((byte)this.getRotation().getValue()));
        }
        if (this.getRadius() != null) {
            transformedStyle.setRadius(this.getRadius().intValue());
        }
        transformedStyle.setPattern(this.pattern);
    }

    public Border getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(Border borderBottom) {
        this.borderBottom = borderBottom;
    }

    public Border getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(Border borderLeft) {
        this.borderLeft = borderLeft;
    }

    public Border getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(Border borderRight) {
        this.borderRight = borderRight;
    }

    public Border getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(Border borderTop) {
        this.borderTop = borderTop;
    }

    @Deprecated
    public Color getBorderColor() {
        if (this.getBorder() == null) {
            return null;
        }
        return this.getBorder().getColor();
    }

    @Deprecated
    public void setBorderColor(Color borderColor) {
        if (this.getBorder() == null) {
            return;
        }
        this.getBorder().setColor(borderColor);
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    public Integer getRadius() {
        return this.radius;
    }

    public void setRadius(Integer radius) {
        this.radius = radius;
    }

    public Integer getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(Integer paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public Integer getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(Integer paddingTop) {
        this.paddingTop = paddingTop;
    }

    public Integer getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(Integer paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public Integer getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(Integer paddingRight) {
        this.paddingRight = paddingRight;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentStyleName() {
        return this.parentStyleName;
    }

    public void setParentStyleName(String parentStyleName) {
        this.parentStyleName = parentStyleName;
    }

    public static Style createBlankStyle(String name) {
        Style style = new Style(name);
        style.setBackgroundColor(null);
        style.setBorderColor(null);
        style.setTransparency(null);
        style.setTextColor(null);
        style.setBorder(null);
        style.setFont(null);
        style.setPadding(null);
        style.setRadius(null);
        style.setVerticalAlign(null);
        style.setHorizontalAlign(null);
        style.setRotation(null);
        style.setStreching(null);
        return style;
    }

    public static Style createBlankStyle(String name, String parent) {
        Style s = Style.createBlankStyle(name);
        s.setParentStyleName(parent);
        return s;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Object clone() throws CloneNotSupportedException {
        Style style = (Style)super.clone();
        style.setFont(this.font);
        return style;
    }
}

